/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.macos;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.jetbrains.gateway.macos.GatewayLocalNetworkRequesterKt;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/macos/GatewayLocalNetworkAlertService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "alertTriggered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "MULTICAST_HOST", "", "triggerMacOsLocalNetworkAlert", "", "Companion", "intellij.gateway.core"})
public final class GatewayLocalNetworkAlertService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicBoolean alertTriggered;
    @NotNull
    private final String MULTICAST_HOST;

    public GatewayLocalNetworkAlertService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.alertTriggered = new AtomicBoolean(false);
        this.MULTICAST_HOST = "230.230.230.230";
    }

    public final void triggerMacOsLocalNetworkAlert() {
        String string = System.getProperty("gateway.trigger.mac.os.local.network.alert");
        boolean bl = string != null ? !Boolean.parseBoolean(string) : false;
        if (bl) {
            return;
        }
        if (!PlatformUtils.isGateway() || !SystemInfo.isMacOSSequoia) {
            return;
        }
        if (!this.alertTriggered.compareAndSet(false, true)) {
            return;
        }
        GatewayLocalNetworkRequesterKt.access$getLOG$p().info("Trying to trigger macOS local network access alert");
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GatewayLocalNetworkAlertService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            Closeable closeable = new MulticastSocket(0);
                            GatewayLocalNetworkAlertService gatewayLocalNetworkAlertService = this.this$0;
                            Throwable throwable = null;
                            try {
                                MulticastSocket socket = (MulticastSocket)closeable;
                                boolean bl = false;
                                InetSocketAddress multicastAddress = new InetSocketAddress(GatewayLocalNetworkAlertService.access$getMULTICAST_HOST$p(gatewayLocalNetworkAlertService), socket.getLocalPort());
                                byte[] buf = new byte[1];
                                DatagramPacket packet = new DatagramPacket(buf, buf.length, multicastAddress);
                                socket.send(packet);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (Exception e) {
                            GatewayLocalNetworkRequesterKt.access$getLOG$p().warn("Error during requesting local network access alert", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final GatewayLocalNetworkAlertService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ String access$getMULTICAST_HOST$p(GatewayLocalNetworkAlertService $this) {
        return $this.MULTICAST_HOST;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/macos/GatewayLocalNetworkAlertService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/gateway/macos/GatewayLocalNetworkAlertService;", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nGatewayLocalNetworkRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayLocalNetworkRequester.kt\ncom/jetbrains/gateway/macos/GatewayLocalNetworkAlertService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n40#2,3:75\n*S KotlinDebug\n*F\n+ 1 GatewayLocalNetworkRequester.kt\ncom/jetbrains/gateway/macos/GatewayLocalNetworkAlertService$Companion\n*L\n72#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GatewayLocalNetworkAlertService getInstance() {
            boolean $i$f$service = false;
            Class<GatewayLocalNetworkAlertService> serviceClass$iv = GatewayLocalNetworkAlertService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GatewayLocalNetworkAlertService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

