/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedSubqueryItemInspection;
import com.intellij.sql.inspections.SqlUnusedVariableInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedSubqueryItemInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlUnusedSubqueryItemInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                selectClause = o.getSelectClause();
                if (selectClause == null) {
                    return;
                }
                hasNoArgAggregate = false;
                for (SqlExpression expression : selectClause.getExpressions()) {
                    Intrinsics.checkNotNull((Object)expression);
                    if (this.isStarReference(expression)) {
                        return;
                    }
                    if (!(expression instanceof SqlFunctionCallExpression) || ((SqlFunctionCallExpression)expression).getParameterList() == null) continue;
                    if (parameterList.getExpressionList().size() != 0) ** GOTO lbl-1000
                    var7_7 = ((SqlFunctionCallExpression)expression).getFunctionDefinition();
                    v0 /* !! */  = var7_7 instanceof BuiltinFunction != false ? var7_7 : null;
                    v1 = v0 /* !! */  != null ? SqlPsiUtilCoreKt.isAggregate((BuiltinFunction)v0 /* !! */ ) : false;
                    if (v1) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    hasNoArgAggregate = v2;
                }
                v3 = o.getTableExpression();
                v4 = v3 != null && (v3 = v3.getFromClause()) != null ? v3.getFromExpression() : (fromExpression = null);
                if (fromExpression instanceof SqlAsExpression && !this.checkIfAliasIsUsed((SqlAsExpression)fromExpression, o)) {
                    fromExpression = ((SqlAsExpression)fromExpression).getExpression();
                }
                while (fromExpression instanceof SqlParenthesizedExpression) {
                    Intrinsics.checkNotNullExpressionValue((Object)((SqlParenthesizedExpression)fromExpression).getExpressionList(), (String)"getExpressionList(...)");
                    if (expressionList.size() != 1) break;
                    fromExpression = (SqlExpression)expressionList.get(0);
                }
                v5 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"emptyList(...)");
                expressionBranches = v5;
                while (fromExpression instanceof SqlNAryExpression) {
                    if (expressionBranches.isEmpty()) {
                        expressionBranches = new ArrayList<E>();
                    }
                    v6 = ((SqlNAryExpression)fromExpression).getOperands();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getOperands(...)");
                    expressionBranches.addAll(v6);
                    fromExpression = ((SqlNAryExpression)fromExpression).getLOperand();
                }
                if (fromExpression instanceof SqlQueryExpression) {
                    this.inspectQueryExpression((SqlQueryExpression)fromExpression, (SearchScope)new LocalSearchScope((PsiElement)o), expressionBranches, hasNoArgAggregate);
                }
                super.visitSqlQueryExpression(o);
            }

            private final boolean checkIfAliasIsUsed(SqlAsExpression alias, SqlQueryExpression o) {
                boolean bl;
                block4: {
                    if (SqlUnusedVariableInspection.foundAnyRefs((PsiElement)alias, (Condition<? super SqlElement>)((Condition)arg_0 -> createAnnotationVisitor.1.checkIfAliasIsUsed$lambda$1(arg_0 -> createAnnotationVisitor.1.checkIfAliasIsUsed$lambda$0(alias, this, arg_0), arg_0)), o.getUseScope())) {
                        return true;
                    }
                    List list = alias.getColumnAliasList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumnAliasList(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlDefinition colAlias = (SqlDefinition)element$iv;
                            boolean bl2 = false;
                            if (!SqlUnusedVariableInspection.foundAnyRefs((PsiElement)colAlias, (Condition<? super SqlElement>)((Condition)arg_0 -> createAnnotationVisitor.1.checkIfAliasIsUsed$lambda$4$lambda$3(arg_0 -> createAnnotationVisitor.1.checkIfAliasIsUsed$lambda$4$lambda$2(colAlias, arg_0), arg_0)), o.getUseScope())) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final SqlExpression skipParenthesized(SqlExpression expression) {
                PsiElement parent;
                createAnnotationVisitor.1 var2_2 = this;
                while ((parent = SqlImplUtil.sqlParent((PsiElement)((PsiElement)expression))) instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)parent).getExpressionList().size() == 1) {
                    createAnnotationVisitor.1 var4_4 = var2_2;
                    SqlParenthesizedExpression sqlParenthesizedExpression = (SqlParenthesizedExpression)parent;
                    var2_2 = var4_4;
                    expression = (SqlExpression)sqlParenthesizedExpression;
                }
                return expression;
            }

            private final boolean isQualifier(SqlReferenceExpression expression) {
                SqlExpression baseExpression = this.skipParenthesized((SqlExpression)expression);
                PsiElement psiElement = baseExpression.getParent();
                SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                return Intrinsics.areEqual((Object)(sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null), (Object)baseExpression);
            }

            private final boolean isStarReference(SqlExpression expression) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)((PsiElement)expression)).filter(SqlReferenceExpression.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlReferenceExpression e = (SqlReferenceExpression)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"*", (Object)e.getName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectQueryExpression(SqlQueryExpression o, SearchScope searchScope, List<? extends SqlExpression> expressionBranches, boolean hasNoArgAggregate) {
                boolean bl;
                List expressions;
                block9: {
                    SqlSelectClause sqlSelectClause = o.getSelectClause();
                    if (sqlSelectClause == null) {
                        return;
                    }
                    SqlSelectClause selectClause = sqlSelectClause;
                    List list = selectClause.getExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
                    expressions = list;
                    if (expressions.size() == 1 && hasNoArgAggregate) {
                        return;
                    }
                    List list2 = selectClause.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptions(...)");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlSelectOption it = (SqlSelectOption)element$iv;
                            boolean bl2 = false;
                            String string = it.getOptionName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOptionName(...)");
                            if (!StringsKt.startsWith((String)string, (String)"DISTINCT", (boolean)true)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                for (SqlExpression expression : expressions) {
                    PsiElement element;
                    if (expression instanceof SqlAsExpression) {
                        this.reportErrorForName(expression, this.getErrorElementName(o, (SqlAsExpression)expression, expressionBranches, searchScope));
                    }
                    if (SqlImplUtil.isAsteriskRef((PsiElement)((PsiElement)expression))) {
                        Intrinsics.checkNotNull((Object)expression);
                        this.validateStarReference(o, expression, expressionBranches, searchScope);
                        continue;
                    }
                    if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || (element = ((SqlReferenceExpression)expression).resolve()) == null) continue;
                    this.reportErrorForName(expression, this.getErrorElementName(o, element, (PsiElement)expression, expressionBranches, searchScope, false));
                }
            }

            private final void validateStarReference(SqlQueryExpression o, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope searchScope) {
                SqlTableType dasType;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                Object object = dasType = sqlTableExpression != null ? sqlTableExpression.getDasType() : null;
                if (dasType == null || dasType instanceof SqlTableTypeBase.Empty) {
                    return;
                }
                HashSet<String> unusedNames = new HashSet<String>(dasType.getColumnCount());
                HashSet<String> usedNames = new HashSet<String>(dasType.getColumnCount());
                int index = 0;
                int n = dasType.getColumnCount();
                if (index <= n) {
                    while (true) {
                        try {
                            PsiElement element;
                            String name2;
                            Intrinsics.checkNotNullExpressionValue((Object)dasType.getColumnElement(index), (String)"getColumnElement(...)");
                            String string = name2 = this.getErrorElementName(o, element, (PsiElement)expression, expressionBranches, searchScope, false);
                            boolean bl = string != null ? unusedNames.add(string) : usedNames.add(dasType.getColumnName(index));
                        }
                        catch (Throwable e) {
                            return;
                        }
                        if (index == n) break;
                        ++index;
                    }
                }
                if (unusedNames.isEmpty()) {
                    return;
                }
                Object[] objectArray = new Object[]{unusedNames.stream().map(arg_0 -> createAnnotationVisitor.1.validateStarReference$lambda$8(createAnnotationVisitor.1::validateStarReference$lambda$7, arg_0)).collect(Collectors.joining(", ")), "select " + StringUtil.join((Collection)usedNames, (String)", ")};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message((String)"subquery.item.star.includes.unused", (Object[])objectArray), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final String getErrorElementName(SqlQueryExpression inspected, SqlAsExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope scope2) {
                List list = expression.getColumnAliasList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumnAliasList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlDefinition colAlias = (SqlDefinition)element$iv;
                    boolean bl = false;
                    PsiElement psiElement = (PsiElement)colAlias;
                    Intrinsics.checkNotNull((Object)colAlias);
                    if (this.getErrorElementName(inspected, psiElement, (PsiElement)colAlias, expressionBranches, scope2, true) != null) continue;
                    return null;
                }
                if (this.getErrorElementName(inspected, (PsiElement)expression, (PsiElement)expression, expressionBranches, scope2, true) == null) {
                    return null;
                }
                Object object = expression.getNameElement();
                if (object == null || (object = object.getName()) == null) {
                    object = expression.getText();
                }
                return object;
            }

            private final String getErrorElementName(SqlQueryExpression inspected, PsiElement element, PsiElement originalElement, List<? extends SqlExpression> expressionBranches, SearchScope scope2, boolean isAlias) {
                if (SqlUnusedVariableInspection.foundAnyRefs(element, (Condition<? super SqlElement>)((Condition)arg_0 -> createAnnotationVisitor.1.getErrorElementName$lambda$11(arg_0 -> createAnnotationVisitor.1.getErrorElementName$lambda$10(this, originalElement, expressionBranches, inspected, isAlias, arg_0), arg_0)), scope2)) {
                    return null;
                }
                PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
                return psiNamedElement != null ? psiNamedElement.getName() : null;
            }

            private final void reportErrorForName(SqlExpression expression, String name2) {
                if (name2 == null) {
                    return;
                }
                Object[] objectArray = new Object[]{name2};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message((String)"subquery.item.never.used", (Object[])objectArray), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final boolean hasOnlyInnerUsages(SqlQueryExpression inspected, PsiElement it, boolean isAlias) {
                if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)inspected), (PsiElement)it, (boolean)true)) {
                    return false;
                }
                SqlSelectClause selectClause = inspected.getSelectClause();
                if (selectClause == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)it, (boolean)true)) {
                    return !isAlias;
                }
                Class[] classArray = new Class[]{SqlSelectClause.class};
                return PsiTreeUtil.getParentOfType((PsiElement)it, SqlAsExpression.class, (boolean)true, (Class[])classArray) == null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasOnlyLocalRefs(SqlElement e, PsiElement originalElement, List<? extends SqlExpression> expressionBranches) {
                SqlExpression b;
                if (e == originalElement) return true;
                Iterable $this$any$iv = expressionBranches;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    b = (SqlExpression)element$iv;
                    boolean bl = false;
                } while (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)b), (PsiElement)((PsiElement)e), (boolean)true));
                return true;
            }

            private static final boolean checkIfAliasIsUsed$lambda$0(SqlAsExpression $alias, createAnnotationVisitor.1 this$0, SqlElement it) {
                return it == $alias ? true : it instanceof SqlReferenceExpression && this$0.isQualifier((SqlReferenceExpression)it);
            }

            private static final boolean checkIfAliasIsUsed$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean checkIfAliasIsUsed$lambda$4$lambda$2(SqlDefinition $colAlias, SqlElement e) {
                return $colAlias == e || $colAlias.getNameElement() == e;
            }

            private static final boolean checkIfAliasIsUsed$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final String validateStarReference$lambda$7(String n) {
                return "'" + n + "'";
            }

            private static final String validateStarReference$lambda$8(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }

            private static final boolean getErrorElementName$lambda$10(createAnnotationVisitor.1 this$0, PsiElement $originalElement, List $expressionBranches, SqlQueryExpression $inspected, boolean $isAlias, SqlElement it) {
                Intrinsics.checkNotNull((Object)it);
                return this$0.hasOnlyLocalRefs(it, $originalElement, $expressionBranches) ? true : this$0.hasOnlyInnerUsages($inspected, (PsiElement)it, $isAlias);
            }

            private static final boolean getErrorElementName$lambda$11(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

