/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.intellij.httpClient.postman.HttpUrl;
import com.intellij.httpClient.postman.PostmanUrlProviderKt;
import com.intellij.httpClient.postman.converter.ConverterHelperKt;
import com.intellij.httpClient.postman.converter.PostmanUniqueNameGenerator;
import com.intellij.httpClient.postman.converter.PostmanVariablesBuilder;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpResponse;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpResponseContent;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanRequest;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanResponse;
import com.intellij.util.PathUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0005J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/postman/converter/HttpResponseBuilder;", "", "variablesBuilder", "Lcom/intellij/httpClient/postman/converter/PostmanVariablesBuilder;", "httpFileName", "", "<init>", "(Lcom/intellij/httpClient/postman/converter/PostmanVariablesBuilder;Ljava/lang/String;)V", "httpResponses", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpResponseContent;", "responseNameFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "postmanUniqueNameGenerator", "Lcom/intellij/httpClient/postman/converter/PostmanUniqueNameGenerator;", "responsesFolder", "getResponsesFolderName", "getResponses", "", "buildResponse", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpResponse;", "response", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanResponse;", "generateFileName", "name", "extension", "getOriginalUrl", "Lcom/intellij/httpClient/postman/HttpUrl;", "intellij.restClient"})
final class HttpResponseBuilder {
    @NotNull
    private final PostmanVariablesBuilder variablesBuilder;
    @NotNull
    private final Map<String, HttpResponseContent> httpResponses;
    private final DateTimeFormatter responseNameFormatter;
    @NotNull
    private final PostmanUniqueNameGenerator postmanUniqueNameGenerator;
    @NotNull
    private final String responsesFolder;

    public HttpResponseBuilder(@NotNull PostmanVariablesBuilder variablesBuilder, @NotNull String httpFileName) {
        Intrinsics.checkNotNullParameter((Object)variablesBuilder, (String)"variablesBuilder");
        Intrinsics.checkNotNullParameter((Object)httpFileName, (String)"httpFileName");
        this.variablesBuilder = variablesBuilder;
        this.httpResponses = new LinkedHashMap();
        this.responseNameFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmss");
        this.postmanUniqueNameGenerator = new PostmanUniqueNameGenerator();
        this.responsesFolder = httpFileName + "_responses";
    }

    @NotNull
    public final String getResponsesFolderName() {
        return this.responsesFolder;
    }

    @NotNull
    public final List<HttpResponseContent> getResponses() {
        return CollectionsKt.toList((Iterable)this.httpResponses.values());
    }

    @Nullable
    public final HttpResponse buildResponse(@NotNull PostmanResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        String string = response2.getBody();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return null;
        }
        String body2 = string;
        String string2 = response2.getName();
        if (string2 == null) {
            string2 = this.responseNameFormatter.format(LocalDateTime.now());
        }
        String name = string2;
        Integer n = response2.getCode();
        int code = n != null ? n : 200;
        Intrinsics.checkNotNull((Object)name);
        String string3 = StringsKt.removeSuffix((String)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)name)).toString(), (String)" ", (String)"_", (boolean)false, (int)4, null), (CharSequence)".").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String responseName = string3;
        String extension = ConverterHelperKt.getExtension(response2);
        String nameWithCode = responseName + "." + code;
        String fileName = this.generateFileName(nameWithCode, extension);
        HttpResponseContent existingByName = this.httpResponses.get(fileName);
        String uniqueFileName = existingByName != null && !Intrinsics.areEqual((Object)existingByName.getContent(), (Object)body2) ? this.generateFileName(this.postmanUniqueNameGenerator.generateUniqueName(nameWithCode, false), extension) : fileName;
        this.httpResponses.put(uniqueFileName, new HttpResponseContent(uniqueFileName, body2));
        return new HttpResponse(this.responsesFolder + "/" + uniqueFileName, this.getOriginalUrl(response2));
    }

    private final String generateFileName(String name, String extension) {
        String string = PathUtil.makeFileName((String)name, (String)extension);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"makeFileName(...)");
        String fileName = string;
        String string2 = PathUtil.suggestFileName((String)fileName, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestFileName(...)");
        return string2;
    }

    private final HttpUrl getOriginalUrl(PostmanResponse response2) {
        HttpUrl httpUrl;
        PostmanRequest postmanRequest = response2.getOriginalRequest();
        if (postmanRequest == null) {
            return HttpUrl.Companion.getEmptyUrl();
        }
        PostmanRequest request = postmanRequest;
        PostmanRequest postmanRequest2 = request;
        if (postmanRequest2 instanceof PostmanRequest.RequestString) {
            httpUrl = PostmanUrlProviderKt.toHttpUrl(((PostmanRequest.RequestString)request).value);
        } else if (postmanRequest2 instanceof PostmanRequest.RequestObject) {
            httpUrl = PostmanUrlProviderKt.retrieveUrl(((PostmanRequest.RequestObject)request).url, this.variablesBuilder);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return httpUrl;
    }
}

