﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehendmedical/model/DescribeSNOMEDCTInferenceJobResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ComprehendMedical::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeSNOMEDCTInferenceJobResult::DescribeSNOMEDCTInferenceJobResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

DescribeSNOMEDCTInferenceJobResult& DescribeSNOMEDCTInferenceJobResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ComprehendMedicalAsyncJobProperties")) {
    m_comprehendMedicalAsyncJobProperties = jsonValue.GetObject("ComprehendMedicalAsyncJobProperties");
    m_comprehendMedicalAsyncJobPropertiesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
