/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLParameters;

public abstract class SSLServerSocket
extends ServerSocket {
    protected SSLServerSocket() throws IOException {
    }

    protected SSLServerSocket(int n) throws IOException {
        super(n);
    }

    protected SSLServerSocket(int n, int n2) throws IOException {
        super(n, n2);
    }

    protected SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
    }

    public abstract String[] getEnabledCipherSuites();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getSupportedProtocols();

    public abstract String[] getEnabledProtocols();

    public abstract void setEnabledProtocols(String[] var1);

    public abstract void setNeedClientAuth(boolean var1);

    public abstract boolean getNeedClientAuth();

    public abstract void setWantClientAuth(boolean var1);

    public abstract boolean getWantClientAuth();

    public abstract void setUseClientMode(boolean var1);

    public abstract boolean getUseClientMode();

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract boolean getEnableSessionCreation();

    public SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(this.getEnabledCipherSuites());
        sSLParameters.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        }
        return sSLParameters;
    }

    public void setSSLParameters(SSLParameters sSLParameters) {
        String[] stringArray = sSLParameters.getCipherSuites();
        if (stringArray != null) {
            this.setEnabledCipherSuites(stringArray);
        }
        if ((stringArray = sSLParameters.getProtocols()) != null) {
            this.setEnabledProtocols(stringArray);
        }
        if (sSLParameters.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }
}

