/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.config;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class OraclePackageConfigurator
implements DBEObjectConfigurator<OraclePackage> {
    public OraclePackage configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull OraclePackage oraclePackage, @NotNull Map<String, Object> options) {
        return (OraclePackage)UITask.run(() -> {
            EntityEditPage editPage = new EntityEditPage((DBPDataSource)oraclePackage.getDataSource(), DBSEntityType.PACKAGE);
            if (!editPage.edit()) {
                return null;
            }
            String packName = editPage.getEntityName();
            oraclePackage.setName(packName);
            oraclePackage.setObjectDefinitionText("CREATE OR REPLACE PACKAGE " + packName + "\nAS\n-- Package header\nEND " + packName + ";");
            oraclePackage.setExtendedDefinitionText("CREATE OR REPLACE PACKAGE BODY " + packName + "\nAS\n-- Package body\nEND " + packName + ";");
            return oraclePackage;
        });
    }
}

