/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadWizard;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;

public class DriverDownloadDialog
extends WizardDialog {
    public static final int EDIT_DRIVER_BUTTON_ID = 2000;
    public static final int MAX_WIDTH = 800;
    private boolean doDownload = false;

    DriverDownloadDialog(@NotNull Shell shell, @NotNull DBPDriver driver, @NotNull DBPDriverDependencies dependencies, boolean updateVersion, boolean forceDownload, boolean isShowExpanded) {
        super(shell, (IWizard)new DriverDownloadWizard(driver, dependencies, updateVersion, forceDownload, isShowExpanded));
        this.getWizard().init(UIUtils.getActiveWorkbenchWindow().getWorkbench(), null);
        this.addPageChangedListener(event -> UIUtils.asyncExec(() -> this.getWizard().pageActivated(event.getSelectedPage())));
    }

    DBPDriver getDriver() {
        return this.getWizard().getDriver();
    }

    public DriverDownloadWizard getWizard() {
        return (DriverDownloadWizard)super.getWizard();
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        if (this.getWizard().isForceDownload()) {
            UIUtils.asyncExec(() -> this.buttonPressed(16));
        }
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        DriverDownloadWizard wizard = this.getWizard();
        if (!wizard.isForceDownload() && DriverEditDialog.getDialogCount() == 0) {
            this.createButton(parent, 2000, wizard.isAutoDownloadWizard() ? UIConnectionMessages.dialog_driver_download_button_edit_dirver : UIConnectionMessages.dialog_driver_download_button_add_jars, false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 16) {
            Button button = super.createButton(parent, id, this.getWizard().getFinishText(), true);
            button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.BROWSER));
            this.setButtonLayoutData(button);
            button.setFocus();
            return button;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.cancelPressed();
            DriverEditDialog dialog = new DriverEditDialog(null, this.getDriver());
            dialog.open(!this.getWizard().isAutoDownloadWizard());
        }
        super.buttonPressed(buttonId);
    }

    protected void finishPressed() {
        this.doDownload = true;
        super.finishPressed();
    }

    void closeWizard() {
        UIUtils.asyncExec(() -> this.buttonPressed(1));
    }

    public static boolean downloadDriverFiles(@Nullable Shell shell, @NotNull DBPDriver driver, @NotNull DBPDriverDependencies dependencies, boolean isShowExpanded) {
        return DriverDownloadDialog.downloadDriverFiles(shell, driver, dependencies, false, isShowExpanded);
    }

    public static boolean downloadDriverFiles(@Nullable Shell shell, @NotNull DBPDriver driver, @NotNull DBPDriverDependencies dependencies, boolean forceDownload, boolean isShowExpanded) {
        if (DBWorkbench.getPlatform().isShuttingDown()) {
            return false;
        }
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        DriverDownloadDialog dialog = new DriverDownloadDialog(shell, driver, dependencies, false, forceDownload, isShowExpanded);
        dialog.setMinimumPageSize(0, 0);
        dialog.open();
        return dialog.doDownload;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(-1, -1, true);
    }
}

