// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Layer, Marker, Viewport};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateMarkerLayer")]
    pub struct MarkerLayer(Object<ffi::ShumateMarkerLayer, ffi::ShumateMarkerLayerClass>) @extends Layer, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_marker_layer_get_type(),
    }
}

impl MarkerLayer {
    #[doc(alias = "shumate_marker_layer_new")]
    pub fn new(viewport: &Viewport) -> MarkerLayer {
        skip_assert_initialized!();
        unsafe { from_glib_none(ffi::shumate_marker_layer_new(viewport.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_marker_layer_new_full")]
    pub fn new_full(viewport: &Viewport, mode: gtk::SelectionMode) -> MarkerLayer {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::shumate_marker_layer_new_full(
                viewport.to_glib_none().0,
                mode.into_glib(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`MarkerLayer`] objects.
    ///
    /// This method returns an instance of [`MarkerLayerBuilder`](crate::builders::MarkerLayerBuilder) which can be used to create [`MarkerLayer`] objects.
    pub fn builder() -> MarkerLayerBuilder {
        MarkerLayerBuilder::new()
    }

    #[doc(alias = "shumate_marker_layer_add_marker")]
    pub fn add_marker(&self, marker: &impl IsA<Marker>) {
        unsafe {
            ffi::shumate_marker_layer_add_marker(
                self.to_glib_none().0,
                marker.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_marker_layer_get_markers")]
    #[doc(alias = "get_markers")]
    pub fn markers(&self) -> Vec<Marker> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::shumate_marker_layer_get_markers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_marker_layer_get_selected")]
    #[doc(alias = "get_selected")]
    pub fn selected(&self) -> Vec<Marker> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::shumate_marker_layer_get_selected(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_marker_layer_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn selection_mode(&self) -> gtk::SelectionMode {
        unsafe {
            from_glib(ffi::shumate_marker_layer_get_selection_mode(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_marker_layer_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::shumate_marker_layer_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_marker_layer_remove_marker")]
    pub fn remove_marker(&self, marker: &impl IsA<Marker>) {
        unsafe {
            ffi::shumate_marker_layer_remove_marker(
                self.to_glib_none().0,
                marker.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_marker_layer_select_all_markers")]
    pub fn select_all_markers(&self) {
        unsafe {
            ffi::shumate_marker_layer_select_all_markers(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_marker_layer_select_marker")]
    pub fn select_marker(&self, marker: &impl IsA<Marker>) -> bool {
        unsafe {
            from_glib(ffi::shumate_marker_layer_select_marker(
                self.to_glib_none().0,
                marker.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_marker_layer_set_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn set_selection_mode(&self, mode: gtk::SelectionMode) {
        unsafe {
            ffi::shumate_marker_layer_set_selection_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "shumate_marker_layer_unselect_all_markers")]
    pub fn unselect_all_markers(&self) {
        unsafe {
            ffi::shumate_marker_layer_unselect_all_markers(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_marker_layer_unselect_marker")]
    pub fn unselect_marker(&self, marker: &impl IsA<Marker>) {
        unsafe {
            ffi::shumate_marker_layer_unselect_marker(
                self.to_glib_none().0,
                marker.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "marker-selected")]
    pub fn connect_marker_selected<F: Fn(&Self, &Marker) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn marker_selected_trampoline<F: Fn(&MarkerLayer, &Marker) + 'static>(
            this: *mut ffi::ShumateMarkerLayer,
            marker: *mut ffi::ShumateMarker,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(marker))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"marker-selected".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    marker_selected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "marker-unselected")]
    pub fn connect_marker_unselected<F: Fn(&Self, &Marker) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn marker_unselected_trampoline<
            F: Fn(&MarkerLayer, &Marker) + 'static,
        >(
            this: *mut ffi::ShumateMarkerLayer,
            marker: *mut ffi::ShumateMarker,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(marker))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"marker-unselected".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    marker_unselected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    pub fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<F: Fn(&MarkerLayer) + 'static>(
            this: *mut ffi::ShumateMarkerLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::selection-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for MarkerLayer {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`MarkerLayer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MarkerLayerBuilder {
    builder: glib::object::ObjectBuilder<'static, MarkerLayer>,
}

impl MarkerLayerBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn selection_mode(self, selection_mode: gtk::SelectionMode) -> Self {
        Self {
            builder: self.builder.property("selection-mode", selection_mode),
        }
    }

    pub fn viewport(self, viewport: &Viewport) -> Self {
        Self {
            builder: self.builder.property("viewport", viewport.clone()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`MarkerLayer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> MarkerLayer {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
