# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools dot-a toolchain-funcs

DESCRIPTION="Cuecue converts .cue + [.ogg|.flac|.wav|.mp3] to .cue + .bin"
HOMEPAGE="https://wiki.gentoo.org/wiki/No_homepage"
SRC_URI="mirror://gentoo/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
# Enable one use flag by default, bug #254745
IUSE="+flac mp3 +vorbis"
REQUIRED_USE="|| ( flac mp3 vorbis )"

DEPEND="
	flac? ( media-libs/flac:= )
	mp3? ( media-libs/libmad )
	vorbis? ( media-libs/libvorbis media-libs/libogg )
"
RDEPEND="
	${DEPEND}
"
# We always need flac for AM_PATH_LIBFLAC if autoreconfing, bug #882447
BDEPEND="media-libs/flac"

PATCHES=(
	"${FILESDIR}"/${P}-flac113.diff # bug 157706
	"${FILESDIR}"/${P}-namespace.patch
	"${FILESDIR}"/${P}-unused.patch
	"${FILESDIR}"/${P}-fno-common.patch
	"${FILESDIR}"/${P}-configure.patch
)

src_prepare() {
	default

	# Clang 16
	eautoreconf
}

src_configure() {
	lto-guarantee-fat
	econf \
		$(use_enable flac) \
		$(use_enable mp3) \
		$(use_enable vorbis ogg) \
		--disable-libFLACtest \
		--disable-oggtest \
		--disable-vorbistest
}

src_compile() {
	emake AR="$(tc-getAR)" CFLAGS="${CFLAGS}"
}

src_install() {
	default
	strip-lto-bytecode

	insinto /usr/include
	doins src/libcuecue/cuecue.h
}
