# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=poetry
PYTHON_COMPAT=( pypy3_11 python3_{11..14} )

inherit distutils-r1

DESCRIPTION="Fixtures as classes"
HOMEPAGE="
	https://github.com/zmievsa/pytest-fixture-classes/
	https://pypi.org/project/pytest-fixture-classes/
"
# No tests in 1.0.3
SRC_URI="
	https://github.com/zmievsa/pytest-fixture-classes/archive/${PV}.tar.gz
		-> ${P}.gh.tar.gz
"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~alpha amd64 ~arm arm64 ~mips ppc64 ~riscv ~s390 x86"

RDEPEND="
	dev-python/pytest[${PYTHON_USEDEP}]
	>=dev-python/typing-extensions-4.4.0[${PYTHON_USEDEP}]
"

EPYTEST_PLUGINS=()
distutils_enable_tests pytest
