# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="Pseudo-Random Number Generator library"
HOMEPAGE="http://statmath.wu.ac.at/prng/"
SRC_URI="http://statmath.wu.ac.at/prng/${P}.tar.gz"

LICENSE="GPL-2"
SLOT=0
KEYWORDS="amd64 ~x86"
IUSE="doc examples static-libs"

PATCHES=(
	"${FILESDIR}"/${PN}-3.0.2-shared.patch
	"${FILESDIR}"/${PN}-3.0.2-fix-all-c99-inline-semantics.patch
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	econf $(use_enable static-libs static)
}

src_install() {
	default
	use doc && dodoc doc/${PN}.pdf
	if use examples; then
		rm examples/Makefile* || die
		dodoc -r examples
		docompress -x /usr/share/doc/${PF}/examples
	fi
	if ! use static-libs; then
		find "${D}" -name '*.la' -delete || die
	fi
}
