# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

RUST_MIN_VER="1.71.1"

CRATES="
	adler2@2.0.1
	allocator-api2@0.2.21
	anstream@0.6.21
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.13
	anyhow@1.0.100
	arc-swap@1.7.1
	bitflags@2.10.0
	block-buffer@0.10.4
	block2@0.6.2
	bstr@1.12.1
	byteorder@1.5.0
	bzip2-rs@0.1.2
	cc@1.2.45
	cfg-if@1.0.4
	cfg_aliases@0.2.1
	clap@4.5.51
	clap_builder@4.5.51
	clap_lex@0.7.6
	clru@0.6.2
	colorchoice@1.0.4
	cpufeatures@0.2.17
	crc32fast@1.5.0
	crypto-common@0.1.6
	ctrlc@3.5.1
	curl-sys@0.4.84+curl-8.17.0
	curl@0.4.49
	digest@0.10.7
	dispatch2@0.3.0
	displaydoc@0.2.5
	dunce@1.0.5
	encoding_rs@0.8.35
	equivalent@1.0.2
	errno@0.3.14
	faster-hex@0.10.0
	fastrand@2.3.0
	filetime@0.2.26
	find-msvc-tools@0.1.4
	flate2@1.1.5
	fnv@1.0.7
	foldhash@0.2.0
	form_urlencoded@1.2.2
	generic-array@0.14.9
	getrandom@0.3.4
	gix-actor@0.35.6
	gix-bitmap@0.2.15
	gix-chunk@0.4.12
	gix-command@0.6.3
	gix-commitgraph@0.30.1
	gix-config-value@0.15.3
	gix-config@0.47.1
	gix-date@0.10.7
	gix-diff@0.54.1
	gix-discover@0.42.0
	gix-features@0.44.1
	gix-fs@0.17.0
	gix-glob@0.22.1
	gix-hash@0.20.1
	gix-hashtable@0.10.0
	gix-index@0.42.1
	gix-lock@19.0.0
	gix-object@0.51.1
	gix-odb@0.71.1
	gix-pack@0.61.1
	gix-packetline@0.19.3
	gix-path@0.10.21
	gix-protocol@0.52.1
	gix-quote@0.6.1
	gix-ref@0.54.1
	gix-refspec@0.32.0
	gix-revision@0.36.1
	gix-revwalk@0.22.0
	gix-sec@0.12.2
	gix-shallow@0.6.0
	gix-tempfile@19.0.1
	gix-trace@0.1.15
	gix-transport@0.49.1
	gix-traverse@0.48.0
	gix-url@0.33.1
	gix-utils@0.3.1
	gix-validate@0.10.1
	gix@0.74.1
	hash32@0.3.1
	hashbrown@0.16.0
	heapless@0.8.0
	hermit-abi@0.5.2
	home@0.5.12
	icu_collections@2.1.1
	icu_locale_core@2.1.1
	icu_normalizer@2.1.1
	icu_normalizer_data@2.1.1
	icu_properties@2.1.1
	icu_properties_data@2.1.1
	icu_provider@2.1.1
	idna@1.1.0
	idna_adapter@1.2.1
	indexmap@2.12.0
	is-terminal@0.4.17
	is_terminal_polyfill@1.70.2
	itoa@1.0.15
	jiff-static@0.2.16
	jiff-tzdb-platform@0.1.3
	jiff-tzdb@0.1.4
	jiff@0.2.16
	libc@0.2.177
	libredox@0.1.10
	libz-rs-sys@0.5.2
	libz-sys@1.1.22
	linux-raw-sys@0.11.0
	litemap@0.8.1
	lock_api@0.4.14
	log@0.4.28
	maybe-async@0.2.10
	memchr@2.7.6
	memmap2@0.9.9
	miniz_oxide@0.8.9
	nix@0.30.1
	objc2-encode@4.1.0
	objc2@0.6.3
	once_cell@1.21.3
	once_cell_polyfill@1.70.2
	openssl-probe@0.1.6
	openssl-sys@0.9.111
	parking_lot@0.12.5
	parking_lot_core@0.9.12
	percent-encoding@2.3.2
	pkg-config@0.3.32
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.4
	proc-macro2@1.0.103
	prodash@30.0.1
	quote@1.0.42
	r-efi@5.3.0
	redox_syscall@0.5.18
	regex-automata@0.4.13
	rustix@1.1.2
	ryu@1.0.20
	same-file@1.0.6
	schannel@0.1.28
	scopeguard@1.2.0
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.145
	sha1-checked@0.10.0
	sha1@0.10.6
	shell-words@1.1.0
	shlex@1.3.0
	simd-adler32@0.3.7
	smallvec@1.15.1
	socket2@0.6.1
	stable_deref_trait@1.2.1
	strsim@0.11.1
	syn@2.0.110
	synstructure@0.13.2
	tar@0.4.44
	tempfile@3.23.0
	termcolor@1.4.1
	terminal_size@0.4.3
	thiserror-impl@2.0.17
	thiserror@2.0.17
	tinystr@0.8.2
	tinyvec@1.10.0
	tinyvec_macros@0.1.1
	typenum@1.19.0
	unicode-bom@2.0.3
	unicode-ident@1.0.22
	unicode-normalization@0.1.25
	url@2.5.7
	utf8_iter@1.0.4
	utf8parse@0.2.2
	vcpkg@0.2.15
	version_check@0.9.5
	walkdir@2.5.0
	wasip2@1.0.1+wasi-0.2.4
	winapi-util@0.1.11
	windows-link@0.2.1
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-sys@0.61.2
	windows-targets@0.52.6
	windows-targets@0.53.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.1
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.1
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.1
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.1
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.1
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.1
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.1
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.1
	winnow@0.7.13
	wit-bindgen@0.46.0
	writeable@0.6.2
	xattr@1.6.1
	yoke-derive@0.8.1
	yoke@0.8.1
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.3
	zerovec-derive@0.11.2
	zerovec@0.11.5
	zlib-rs@0.5.2
"

inherit cargo flag-o-matic

DESCRIPTION="Stack-based patch management for Git"
HOMEPAGE="https://stacked-git.github.io/"
SRC_URI="${CARGO_CRATE_URIS}"
SRC_URI+=" https://github.com/stacked-git/stgit/releases/download/v${PV}/${P}.tar.gz"

LICENSE="GPL-2"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT Unicode-3.0 ZLIB"
SLOT="0/2"
KEYWORDS="~amd64 ~arm ~arm64 ~ppc ~ppc64 ~riscv ~x86"
IUSE="doc"

DEPEND="doc? ( app-text/asciidoc )"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/stg"

src_configure() {
	filter-lto #bug 897692
}

src_compile() {
	cargo_src_compile
	emake completion
	emake contrib
	use doc && emake doc
}

src_install() {
	cargo_src_install
	emake DESTDIR="${D}" prefix="/usr" install-completion
	emake DESTDIR="${D}" prefix="/usr" install-contrib
	if use doc; then
		emake DESTDIR="${D}" prefix="/usr" install-man
		emake DESTDIR="${D}" prefix="/usr" \
			htmldir="/usr/share/doc/${PF}"  \
			install-html
	fi
}
