	; For an STM8S005

	CLK_SWR               =: 0x50c4
	CLK_SWR_HSI           =: 0xE1 ; VALUE: HSI selected as master clock source (reset value)
	CLK_SWR_LSI           =: 0xD2 ; VALUE: LSI selected as master clock source

	CLK_SWCR              =: 0x50c5
	CLK_SWCR_SWEN         =: 1 ; Switch start/stop
	CLK_SWCR_SWBSY        =: 0 ; Switch busy

	CLK_CKDIVR            =: 0x50c6
	CLK_CKDIVR_HSIDIV     =: 3 ; Bits [4:3]: High speed internal clock prescaler
	CLK_CKDIVR_HSIDIV_1   =: (0b00 << CLK_CKDIVR_HSIDIV) ; f_HSI = f_HSI RC output
	CLK_CKDIVR_HSIDIV_2   =: (0b01 << CLK_CKDIVR_HSIDIV) ; f_HSI = f_HSI RC output / 2
	CLK_CKDIVR_HSIDIV_4   =: (0b10 << CLK_CKDIVR_HSIDIV) ; f_HSI = f_HSI RC output / 4
	CLK_CKDIVR_HSIDIV_8   =: (0b11 << CLK_CKDIVR_HSIDIV) ; f_HSI = f_HSI RC output / 8

        CLK_CKDIVR_CPUDIV     =: 0 ; Bits [2:0]: CPU clock prescaler
	CLK_CKDIVR_CPUDIV_1   =: (0b000 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output
	CLK_CKDIVR_CPUDIV_2   =: (0b001 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 2
	CLK_CKDIVR_CPUDIV_4   =: (0b010 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 4
	CLK_CKDIVR_CPUDIV_8   =: (0b011 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 8
	CLK_CKDIVR_CPUDIV_16  =: (0b100 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 16
	CLK_CKDIVR_CPUDIV_32  =: (0b101 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 32
	CLK_CKDIVR_CPUDIV_64  =: (0b110 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 64
	CLK_CKDIVR_CPUDIV_128 =: (0b111 << CLK_CKDIVR_CPUDIV) ; f_CPU = f_MASTER RC output / 128

	.area _DATA
loc1:	.ds 1
loc2:	.ds 1

	.area _CODE
	int reset

reset:
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_2 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_4 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_8 | CLK_CKDIVR_CPUDIV_1)

	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_2)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_4)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_8)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_16)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_32)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_64)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_128)

	; Now change to the LSI clock
	bset 0x4805, #3
	bres 0x4806, #3
	bset CLK_SWCR, #CLK_SWCR_SWEN
	mov  CLK_SWR, #CLK_SWR_LSI
wait:	btjt CLK_SWCR, #CLK_SWCR_SWBSY, wait

	; And do it all again
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_2 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_4 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_8 | CLK_CKDIVR_CPUDIV_1)

	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_1)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_2)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_4)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_8)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_16)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_32)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_64)
	mov CLK_CKDIVR, #(CLK_CKDIVR_HSIDIV_1 | CLK_CKDIVR_CPUDIV_128)
