/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridSynonym
extends GenericSynonym {
    private String owner;
    private String targetName;
    private String targetOwner;
    private String description;

    public CubridSynonym(@NotNull GenericStructContainer container, @NotNull String name, @Nullable String description, @NotNull JDBCResultSet dbResult) {
        super(container, name, description);
        this.description = description;
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"synonym_owner_name");
        this.targetName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_name");
        this.targetOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_owner_name");
    }

    public CubridSynonym(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name, null);
        this.owner = container.getName();
    }

    @Property(viewable=true, order=2)
    @NotNull
    public CubridUser getOwner() {
        return new CubridUser(this.getDataSource(), this.owner, null);
    }

    public DBSObject getTargetObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().findTable(monitor, null, this.targetOwner, this.targetName);
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    public String getTargetObject() {
        return this.targetName;
    }

    public void setTargetObject(String targetObject) {
        this.targetName = targetObject;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

