/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.text.CaseUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CaseUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new CaseUtils());
        Constructor<?>[] cons = CaseUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(CaseUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(CaseUtils.class.getModifiers()));
    }

    @Test
    public void testToCamelCase() {
        Assertions.assertNull((Object)CaseUtils.toCamelCase(null, (boolean)false, null));
        Assertions.assertEquals((Object)"", (Object)CaseUtils.toCamelCase((String)"", (boolean)true, null));
        Assertions.assertEquals((Object)"", (Object)CaseUtils.toCamelCase((String)"  ", (boolean)false, null));
        Assertions.assertEquals((Object)"aBC@def", (Object)CaseUtils.toCamelCase((String)"a  b  c  @def", (boolean)false, null));
        Assertions.assertEquals((Object)"ABC@def", (Object)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[0]));
        Assertions.assertEquals((Object)"ABC@def", (Object)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[]{'-'}));
        Assertions.assertEquals((Object)"ABC@def", (Object)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[]{'-'}));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertEquals((Object)"", (Object)CaseUtils.toCamelCase((String)"-+@ ", (boolean)true, (char[])chars));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)"   to-CAMEL-cASE", (boolean)false, (char[])chars));
        Assertions.assertEquals((Object)"ToCamelCase", (Object)CaseUtils.toCamelCase((String)"@@@@   to+CAMEL@cASE ", (boolean)true, (char[])chars));
        Assertions.assertEquals((Object)"ToCaMeLCase", (Object)CaseUtils.toCamelCase((String)"To+CA+ME L@cASE", (boolean)true, (char[])chars));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)"To.Camel.Case", (boolean)false, (char[])new char[]{'.'}));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)"To.Camel-Case", (boolean)false, (char[])new char[]{'-', '.'}));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)" to @ Camel case", (boolean)false, (char[])new char[]{'-', '@'}));
        Assertions.assertEquals((Object)"ToCamelCase", (Object)CaseUtils.toCamelCase((String)" @to @ Camel case", (boolean)true, (char[])new char[]{'-', '@'}));
        Assertions.assertEquals((Object)"ToCamelCase", (Object)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)true, null));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)false, null));
        Assertions.assertEquals((Object)"toCamelCase", (Object)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)false, null));
        Assertions.assertEquals((Object)"tocamelcase", (Object)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)false, null));
        Assertions.assertEquals((Object)"Tocamelcase", (Object)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)true, null));
        Assertions.assertEquals((Object)"tocamelcase", (Object)CaseUtils.toCamelCase((String)"Tocamelcase", (boolean)false, null));
        Assertions.assertEquals((Object)"Tocamelcase", (Object)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)true, (char[])new char[0]));
        Assertions.assertEquals((Object)"tocamelcase", (Object)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)false, (char[])new char[0]));
        Assertions.assertEquals((Object)"\ud800\udf00\ud800\udf02", (Object)CaseUtils.toCamelCase((String)"\ud800\udf00 \ud800\udf02", (boolean)true, (char[])new char[0]));
        Assertions.assertEquals((Object)"\ud800\udf00\ud800\udf01\ud800\udf02\ud800\udf03", (Object)CaseUtils.toCamelCase((String)"\ud800\udf00\ud800\udf01\ud800\udf14\ud800\udf02\ud800\udf03", (boolean)true, (char[])new char[]{'\ud800', '\udf14'}));
    }
}

