/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.EditDistanceFrom;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringMetricFromTest {
    @Test
    public void testEquivalence() {
        LevenshteinDistance metric = LevenshteinDistance.getDefaultInstance();
        String left = "Apache";
        String right = "a patchy";
        Integer distance = 4;
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        Assertions.assertEquals((Integer)distance, (Integer)((Integer)metricFrom.apply((CharSequence)"a patchy")));
        Assertions.assertEquals((Integer)((Integer)metric.apply((CharSequence)"Apache", (CharSequence)"a patchy")), (Integer)((Integer)metricFrom.apply((CharSequence)"a patchy")));
    }

    @Test
    public void testJavadocExample() {
        LevenshteinDistance metric = LevenshteinDistance.getDefaultInstance();
        String target = "Apache";
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        String mostSimilar = null;
        Integer shortestDistance = null;
        for (String test : new String[]{"Appaloosa", "a patchy", "apple"}) {
            Integer distance = (Integer)metricFrom.apply((CharSequence)test);
            if (shortestDistance != null && distance >= shortestDistance) continue;
            shortestDistance = distance;
            mostSimilar = test;
        }
        Assertions.assertEquals((Object)"a patchy", mostSimilar);
        Assertions.assertEquals((int)4, shortestDistance);
    }

    @Test
    public void testMissingMetric() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EditDistanceFrom(null, (CharSequence)"no go"));
    }
}

