// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A uniquely identified group of data records in a Kinesis data stream.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Shard {
    /// <p>The unique identifier of the shard within the stream.</p>
    pub shard_id: ::std::string::String,
    /// <p>The shard ID of the shard's parent.</p>
    pub parent_shard_id: ::std::option::Option<::std::string::String>,
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub adjacent_parent_shard_id: ::std::option::Option<::std::string::String>,
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub hash_key_range: ::std::option::Option<crate::types::HashKeyRange>,
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub sequence_number_range: ::std::option::Option<crate::types::SequenceNumberRange>,
}
impl Shard {
    /// <p>The unique identifier of the shard within the stream.</p>
    pub fn shard_id(&self) -> &str {
        use std::ops::Deref;
        self.shard_id.deref()
    }
    /// <p>The shard ID of the shard's parent.</p>
    pub fn parent_shard_id(&self) -> ::std::option::Option<&str> {
        self.parent_shard_id.as_deref()
    }
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub fn adjacent_parent_shard_id(&self) -> ::std::option::Option<&str> {
        self.adjacent_parent_shard_id.as_deref()
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn hash_key_range(&self) -> ::std::option::Option<&crate::types::HashKeyRange> {
        self.hash_key_range.as_ref()
    }
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub fn sequence_number_range(&self) -> ::std::option::Option<&crate::types::SequenceNumberRange> {
        self.sequence_number_range.as_ref()
    }
}
impl Shard {
    /// Creates a new builder-style object to manufacture [`Shard`](crate::types::Shard).
    pub fn builder() -> crate::types::builders::ShardBuilder {
        crate::types::builders::ShardBuilder::default()
    }
}

/// A builder for [`Shard`](crate::types::Shard).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ShardBuilder {
    pub(crate) shard_id: ::std::option::Option<::std::string::String>,
    pub(crate) parent_shard_id: ::std::option::Option<::std::string::String>,
    pub(crate) adjacent_parent_shard_id: ::std::option::Option<::std::string::String>,
    pub(crate) hash_key_range: ::std::option::Option<crate::types::HashKeyRange>,
    pub(crate) sequence_number_range: ::std::option::Option<crate::types::SequenceNumberRange>,
}
impl ShardBuilder {
    /// <p>The unique identifier of the shard within the stream.</p>
    /// This field is required.
    pub fn shard_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.shard_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier of the shard within the stream.</p>
    pub fn set_shard_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.shard_id = input;
        self
    }
    /// <p>The unique identifier of the shard within the stream.</p>
    pub fn get_shard_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.shard_id
    }
    /// <p>The shard ID of the shard's parent.</p>
    pub fn parent_shard_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.parent_shard_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The shard ID of the shard's parent.</p>
    pub fn set_parent_shard_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.parent_shard_id = input;
        self
    }
    /// <p>The shard ID of the shard's parent.</p>
    pub fn get_parent_shard_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.parent_shard_id
    }
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub fn adjacent_parent_shard_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.adjacent_parent_shard_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub fn set_adjacent_parent_shard_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.adjacent_parent_shard_id = input;
        self
    }
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub fn get_adjacent_parent_shard_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.adjacent_parent_shard_id
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    /// This field is required.
    pub fn hash_key_range(mut self, input: crate::types::HashKeyRange) -> Self {
        self.hash_key_range = ::std::option::Option::Some(input);
        self
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn set_hash_key_range(mut self, input: ::std::option::Option<crate::types::HashKeyRange>) -> Self {
        self.hash_key_range = input;
        self
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn get_hash_key_range(&self) -> &::std::option::Option<crate::types::HashKeyRange> {
        &self.hash_key_range
    }
    /// <p>The range of possible sequence numbers for the shard.</p>
    /// This field is required.
    pub fn sequence_number_range(mut self, input: crate::types::SequenceNumberRange) -> Self {
        self.sequence_number_range = ::std::option::Option::Some(input);
        self
    }
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub fn set_sequence_number_range(mut self, input: ::std::option::Option<crate::types::SequenceNumberRange>) -> Self {
        self.sequence_number_range = input;
        self
    }
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub fn get_sequence_number_range(&self) -> &::std::option::Option<crate::types::SequenceNumberRange> {
        &self.sequence_number_range
    }
    /// Consumes the builder and constructs a [`Shard`](crate::types::Shard).
    /// This method will fail if any of the following fields are not set:
    /// - [`shard_id`](crate::types::builders::ShardBuilder::shard_id)
    pub fn build(self) -> ::std::result::Result<crate::types::Shard, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Shard {
            shard_id: self.shard_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "shard_id",
                    "shard_id was not specified but it is required when building Shard",
                )
            })?,
            parent_shard_id: self.parent_shard_id,
            adjacent_parent_shard_id: self.adjacent_parent_shard_id,
            hash_key_range: self.hash_key_range,
            sequence_number_range: self.sequence_number_range,
        })
    }
}
