/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComputedAttribute
extends AttributeCreator {
    private Expression attributeName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private boolean allowNameAsQName;

    public ComputedAttribute(Expression attributeName, Expression namespace, NamespaceResolver nsContext, int validationAction, SimpleType schemaType, boolean allowNameAsQName) {
        this.attributeName = attributeName;
        this.namespace = namespace;
        this.nsContext = nsContext;
        this.setSchemaType(schemaType);
        this.setValidationAction(validationAction);
        this.setOptions(0);
        this.allowNameAsQName = allowNameAsQName;
        this.adoptChildExpression(attributeName);
        this.adoptChildExpression(namespace);
    }

    @Override
    public void setRejectDuplicates() {
        this.setOptions(this.getOptions() | 0x20);
    }

    @Override
    public int getInstructionNameCode() {
        return 135;
    }

    public Expression getNameExpression() {
        return this.attributeName;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    @Override
    public int getCardinality() {
        return 24576;
    }

    public boolean isAllowNameAsQName() {
        return this.allowNameAsQName;
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        TypeHierarchy th;
        this.attributeName = visitor.typeCheck(this.attributeName, contextItemType);
        this.adoptChildExpression(this.attributeName);
        RoleLocator role = new RoleLocator(4, "attribute/name", 0);
        if (this.allowNameAsQName) {
            boolean maybeQName;
            ItemType nameItemType;
            this.attributeName = TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_ATOMIC, false, role, visitor);
            th = visitor.getConfiguration().getTypeHierarchy();
            boolean maybeString = th.relationship(nameItemType = this.attributeName.getItemType(), BuiltInAtomicType.STRING) != 4 || th.relationship(nameItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
            boolean bl = maybeQName = th.relationship(nameItemType, BuiltInAtomicType.QNAME) != 4;
            if (!maybeString && !maybeQName) {
                XPathException err = new XPathException("The attribute name must be either an xs:string, an xs:QName, or untyped atomic");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        } else {
            th = visitor.getConfiguration().getTypeHierarchy();
            if (!th.isSubType(this.attributeName.getItemType(), BuiltInAtomicType.STRING)) {
                this.attributeName = SystemFunctionCall.makeSystemFunction("string", new Expression[]{this.attributeName});
            }
        }
        if (this.namespace != null) {
            visitor.typeCheck(this.namespace, contextItemType);
            this.adoptChildExpression(this.namespace);
        }
        if (Literal.isAtomic(this.attributeName)) {
            try {
                AtomicValue val = (AtomicValue)((Literal)this.attributeName).getValue();
                if (val instanceof StringValue) {
                    String[] parts = NameChecker.checkQNameParts(val.getStringValueCS());
                    if (this.namespace == null) {
                        String uri = this.getNamespaceResolver().getURIForPrefix(parts[0], true);
                        if (uri == null) {
                            XPathException se = new XPathException("Prefix " + parts[0] + " has not been declared");
                            if (this.isXSLT()) {
                                se.setErrorCode("XTDE0860");
                                se.setIsStaticError(true);
                                throw se;
                            }
                            se.setErrorCode("XQDY0074");
                            se.setIsStaticError(false);
                            throw se;
                        }
                        this.namespace = new StringLiteral(uri, this.getContainer());
                    }
                }
            }
            catch (XPathException e) {
                if (e.getErrorCodeQName() == null || e.getErrorCodeLocalPart().equals("FORG0001")) {
                    e.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                }
                e.maybeSetLocation(this);
                e.setIsStaticError(true);
                throw e;
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.attributeName = visitor.optimize(this.attributeName, contextItemType);
        this.namespace = visitor.optimize(this.namespace, contextItemType);
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp != this) {
            return exp;
        }
        if (this.attributeName instanceof Literal && (this.namespace == null || this.namespace instanceof Literal)) {
            XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
            NodeName nc = this.evaluateNodeName(context);
            FixedAttribute fa = new FixedAttribute(nc, this.getValidationAction(), this.getSchemaType());
            fa.setSelect(this.getContentExpression(), visitor.getConfiguration());
            return fa;
        }
        return this;
    }

    @Override
    public Expression copy() {
        ComputedAttribute exp = new ComputedAttribute(this.attributeName == null ? null : this.attributeName.copy(), this.namespace == null ? null : this.namespace.copy(), this.nsContext, this.getValidationAction(), this.getSchemaType(), this.allowNameAsQName);
        exp.setSelect(this.select.copy(), this.getConfiguration());
        return exp;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(4);
        list.add(new Operand(this.select, OperandRole.SINGLE_ATOMIC));
        list.add(new Operand(this.attributeName, OperandRole.SINGLE_ATOMIC));
        if (this.namespace != null) {
            list.add(new Operand(this.namespace, OperandRole.SINGLE_ATOMIC));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.attributeName == original) {
            this.attributeName = replacement;
            found = true;
        }
        if (this.namespace == original) {
            this.namespace = replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.attributeName = this.doPromotion(this.attributeName, offer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, offer);
        }
        super.promoteInst(offer);
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (parentType instanceof SimpleType) {
            String msg = "Attributes are not permitted here: ";
            msg = parentType.isAnonymousType() ? msg + "the containing element is defined to have a simple type" : msg + "the containing element is of simple type " + parentType.getDescription();
            XPathException err = new XPathException(msg);
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
    }

    @Override
    public NodeName evaluateNodeName(XPathContext context) throws XPathException {
        XPathException err;
        String localName;
        String prefix;
        NamePool pool = context.getNamePool();
        Item nameValue = this.attributeName.evaluateItem(context);
        String uri = null;
        if (nameValue instanceof StringValue) {
            XPathException err2;
            CharSequence rawName = nameValue.getStringValueCS();
            rawName = Whitespace.trimWhitespace(rawName);
            try {
                String[] parts = NameChecker.getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err3) {
                XPathException err1 = new XPathException("Invalid attribute name: " + rawName, this);
                err1.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                err1.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err1, context);
            }
            if (rawName.toString().equals("xmlns") && this.namespace == null) {
                err2 = new XPathException("Invalid attribute name: " + rawName, this);
                err2.setErrorCode(this.isXSLT() ? "XTDE0855" : "XQDY0044");
                err2.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err2, context);
            }
            if (prefix.equals("xmlns")) {
                if (this.namespace == null) {
                    err2 = new XPathException("Invalid attribute name: " + rawName, this);
                    err2.setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0044");
                    err2.setXPathContext(context);
                    throw ComputedAttribute.dynamicError(this, err2, context);
                }
                prefix = "";
            }
        } else if (nameValue instanceof QNameValue && this.allowNameAsQName) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            if (localName.equals("xmlns") && uri.length() == 0) {
                XPathException err4 = new XPathException("Invalid attribute name: xmlns", this);
                err4.setErrorCode("XQDY0044");
                err4.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err4, context);
            }
            if (uri.length() == 0) {
                prefix = "";
            } else {
                prefix = ((QNameValue)nameValue).getPrefix();
                if (prefix.length() == 0 && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                    prefix = "ns0";
                }
                if (uri.equals("http://www.w3.org/XML/1998/namespace") != "xml".equals(prefix)) {
                    String message = "xml".equals(prefix) ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
                    XPathException err5 = new XPathException(message, this);
                    err5.setErrorCode(this.isXSLT() ? "XTDE0835" : "XQDY0044");
                    err5.setXPathContext(context);
                    throw ComputedAttribute.dynamicError(this, err5, context);
                }
            }
            if ("xmlns".equals(prefix)) {
                XPathException err6 = new XPathException("Invalid attribute namespace: http://www.w3.org/2000/xmlns/", this);
                err6.setErrorCode("XQDY0044");
                err6.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err6, context);
            }
        } else {
            XPathException err7 = new XPathException("Attribute name must be either a string or a QName", this);
            err7.setErrorCode("XPTY0004");
            err7.setIsTypeError(true);
            err7.setXPathContext(context);
            throw ComputedAttribute.dynamicError(this, err7, context);
        }
        if (this.namespace == null && uri == null) {
            if (prefix.length() == 0) {
                uri = "";
            } else {
                uri = this.nsContext.getURIForPrefix(prefix, false);
                if (uri == null) {
                    err = new XPathException("Undeclared prefix in attribute name: " + prefix, this);
                    err.setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0074");
                    err.setXPathContext(context);
                    throw ComputedAttribute.dynamicError(this, err, context);
                }
            }
        } else {
            if (uri == null) {
                if (this.namespace instanceof StringLiteral) {
                    uri = ((StringLiteral)this.namespace).getStringValue();
                } else {
                    uri = this.namespace.evaluateAsString(context).toString();
                    if (!StandardURIChecker.getInstance().isValidURI(uri)) {
                        XPathException de = new XPathException("The value of the namespace attribute must be a valid URI");
                        de.setErrorCode("XTDE0865");
                        de.setXPathContext(context);
                        de.setLocator(this);
                        throw de;
                    }
                }
            }
            if (uri.length() == 0) {
                prefix = "";
            } else if (prefix.length() == 0 && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                prefix = "ns0";
            }
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            err = new XPathException("Cannot create attribute in namespace " + uri, this);
            err.setErrorCode(this.isXSLT() ? "XTDE0865" : "XQDY0044");
            err.setXPathContext(context);
            throw ComputedAttribute.dynamicError(this, err, context);
        }
        return new FingerprintedQName(prefix, uri, localName);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item node = super.evaluateItem(context);
        this.validateOrphanAttribute((Orphan)node, context);
        return node;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("computedAttribute");
        out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        SimpleType type = this.getSchemaType();
        if (type != null) {
            out.emitAttribute("type", type.getDescription());
        }
        out.startSubsidiaryElement("name");
        this.attributeName.explain(out);
        out.endSubsidiaryElement();
        if (this.namespace != null) {
            out.startSubsidiaryElement("namespace");
            this.namespace.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("select");
        this.getContentExpression().explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

