/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;

public class EFSNIOFileInfo
extends FileInfo {
    private final Path path;

    public EFSNIOFileInfo(Path path) {
        super(EFSNIOResource.getPathFileNameOrHost(path));
        this.path = path;
    }

    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getLength() {
        try {
            return Files.size(this.path);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public boolean exists() {
        return true;
    }
}

