/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class TaskFolderRenameHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(TaskFolderRenameHandler.class);

    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        if (!(selectedObject instanceof DBTTaskFolder)) {
            return null;
        }
        DBTTaskFolder taskFolder = (DBTTaskFolder)selectedObject;
        String newFolderName = EnterNameDialog.chooseName((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)TaskUIViewMessages.task_handler_folder_rename_property_label, (String)taskFolder.getName());
        if (CommonUtils.isEmpty((String)newFolderName)) {
            return null;
        }
        DBTTaskManager taskManager = taskFolder.getProject().getTaskManager();
        Object[] tasksFolders = taskManager.getTasksFolders();
        if (!ArrayUtils.isEmpty((Object[])tasksFolders) && Arrays.stream(tasksFolders).anyMatch(e -> e.getName().equalsIgnoreCase(newFolderName))) {
            DBWorkbench.getPlatformUI().showError(TaskUIViewMessages.task_handler_folder_rename_error_title, NLS.bind((String)TaskUIViewMessages.task_handler_folder_rename_error_message, (Object)taskFolder.getName(), (Object)newFolderName));
            log.error((Object)("Can't rename task folder " + taskFolder.getName()));
            return null;
        }
        taskFolder.setName(newFolderName);
        taskManager.updateConfiguration();
        TaskRegistry.getInstance().notifyTaskFoldersListeners(new DBTTaskFolderEvent(taskFolder, DBTTaskFolderEvent.Action.TASK_FOLDER_UPDATE));
        return null;
    }
}

