// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Error thrown when an internal server error occurs HTTP Status Code: 500 Internal Server Error Used for unexpected server-side errors that prevent request processing.
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InternalServerException {
    /// OAuth 2.0 error code indicating server error Will be SERVER_ERROR for internal server errors
    pub error: crate::types::OAuth2ErrorCode,
    /// Detailed message explaining the server error May include error details for debugging purposes
    pub message: ::std::string::String,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl InternalServerException {
    /// OAuth 2.0 error code indicating server error Will be SERVER_ERROR for internal server errors
    pub fn error(&self) -> &crate::types::OAuth2ErrorCode {
        &self.error
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> &str {
        &self.message
    }
}
impl ::std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "InternalServerException")?;
        {
            ::std::write!(f, ": {}", &self.message)?;
        }
        Ok(())
    }
}
impl ::std::error::Error for InternalServerException {}
impl ::aws_types::request_id::RequestId for crate::types::error::InternalServerException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for InternalServerException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::types::error::InternalServerException).
    pub fn builder() -> crate::types::error::builders::InternalServerExceptionBuilder {
        crate::types::error::builders::InternalServerExceptionBuilder::default()
    }
}

/// A builder for [`InternalServerException`](crate::types::error::InternalServerException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InternalServerExceptionBuilder {
    pub(crate) error: ::std::option::Option<crate::types::OAuth2ErrorCode>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl InternalServerExceptionBuilder {
    /// OAuth 2.0 error code indicating server error Will be SERVER_ERROR for internal server errors
    /// This field is required.
    pub fn error(mut self, input: crate::types::OAuth2ErrorCode) -> Self {
        self.error = ::std::option::Option::Some(input);
        self
    }
    /// OAuth 2.0 error code indicating server error Will be SERVER_ERROR for internal server errors
    pub fn set_error(mut self, input: ::std::option::Option<crate::types::OAuth2ErrorCode>) -> Self {
        self.error = input;
        self
    }
    /// OAuth 2.0 error code indicating server error Will be SERVER_ERROR for internal server errors
    pub fn get_error(&self) -> &::std::option::Option<crate::types::OAuth2ErrorCode> {
        &self.error
    }
    /// Detailed message explaining the server error May include error details for debugging purposes
    /// This field is required.
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// Detailed message explaining the server error May include error details for debugging purposes
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// Detailed message explaining the server error May include error details for debugging purposes
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`InternalServerException`](crate::types::error::InternalServerException).
    /// This method will fail if any of the following fields are not set:
    /// - [`error`](crate::types::error::builders::InternalServerExceptionBuilder::error)
    /// - [`message`](crate::types::error::builders::InternalServerExceptionBuilder::message)
    pub fn build(self) -> ::std::result::Result<crate::types::error::InternalServerException, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::error::InternalServerException {
            error: self.error.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "error",
                    "error was not specified but it is required when building InternalServerException",
                )
            })?,
            message: self.message.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "message",
                    "message was not specified but it is required when building InternalServerException",
                )
            })?,
            meta: self.meta.unwrap_or_default(),
        })
    }
}
