//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagehintkey?language=objc)
// NS_TYPED_ENUM
pub type NSImageHintKey = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagerepmatchesdevice?language=objc)
pub const NSImageRepMatchesDevice: c_uint = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagelayoutdirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageLayoutDirection(pub NSInteger);
impl NSImageLayoutDirection {
    #[doc(alias = "NSImageLayoutDirectionUnspecified")]
    pub const Unspecified: Self = Self(-1);
    #[doc(alias = "NSImageLayoutDirectionLeftToRight")]
    pub const LeftToRight: Self = Self(2);
    #[doc(alias = "NSImageLayoutDirectionRightToLeft")]
    pub const RightToLeft: Self = Self(3);
}

unsafe impl Encode for NSImageLayoutDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSImageLayoutDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagerep?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSImageRep;
);

extern_conformance!(
    unsafe impl NSCoding for NSImageRep {}
);

extern_conformance!(
    unsafe impl NSCopying for NSImageRep {}
);

unsafe impl CopyingHelper for NSImageRep {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSImageRep {}
);

impl NSImageRep {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(draw))]
        #[unsafe(method_family = none)]
        pub fn draw(&self) -> bool;

        #[unsafe(method(drawAtPoint:))]
        #[unsafe(method_family = none)]
        pub fn drawAtPoint(&self, point: NSPoint) -> bool;

        #[unsafe(method(drawInRect:))]
        #[unsafe(method_family = none)]
        pub fn drawInRect(&self, rect: NSRect) -> bool;

        #[cfg(all(feature = "NSGraphics", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// `hints` generic should be of the correct type.
        #[unsafe(method(drawInRect:fromRect:operation:fraction:respectFlipped:hints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInRect_fromRect_operation_fraction_respectFlipped_hints(
            &self,
            dst_space_portion_rect: NSRect,
            src_space_portion_rect: NSRect,
            op: NSCompositingOperation,
            requested_alpha: CGFloat,
            respect_context_is_flipped: bool,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        ) -> bool;

        #[unsafe(method(size))]
        #[unsafe(method_family = none)]
        pub fn size(&self) -> NSSize;

        /// Setter for [`size`][Self::size].
        #[unsafe(method(setSize:))]
        #[unsafe(method_family = none)]
        pub fn setSize(&self, size: NSSize);

        #[unsafe(method(hasAlpha))]
        #[unsafe(method_family = none)]
        pub fn hasAlpha(&self) -> bool;

        /// Setter for [`hasAlpha`][Self::hasAlpha].
        #[unsafe(method(setAlpha:))]
        #[unsafe(method_family = none)]
        pub fn setAlpha(&self, alpha: bool);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub fn isOpaque(&self) -> bool;

        /// Setter for [`isOpaque`][Self::isOpaque].
        #[unsafe(method(setOpaque:))]
        #[unsafe(method_family = none)]
        pub fn setOpaque(&self, opaque: bool);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(colorSpaceName))]
        #[unsafe(method_family = none)]
        pub fn colorSpaceName(&self) -> Retained<NSColorSpaceName>;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`colorSpaceName`][Self::colorSpaceName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setColorSpaceName:))]
        #[unsafe(method_family = none)]
        pub fn setColorSpaceName(&self, color_space_name: &NSColorSpaceName);

        #[unsafe(method(bitsPerSample))]
        #[unsafe(method_family = none)]
        pub fn bitsPerSample(&self) -> NSInteger;

        /// Setter for [`bitsPerSample`][Self::bitsPerSample].
        #[unsafe(method(setBitsPerSample:))]
        #[unsafe(method_family = none)]
        pub fn setBitsPerSample(&self, bits_per_sample: NSInteger);

        #[unsafe(method(pixelsWide))]
        #[unsafe(method_family = none)]
        pub fn pixelsWide(&self) -> NSInteger;

        /// Setter for [`pixelsWide`][Self::pixelsWide].
        #[unsafe(method(setPixelsWide:))]
        #[unsafe(method_family = none)]
        pub fn setPixelsWide(&self, pixels_wide: NSInteger);

        #[unsafe(method(pixelsHigh))]
        #[unsafe(method_family = none)]
        pub fn pixelsHigh(&self) -> NSInteger;

        /// Setter for [`pixelsHigh`][Self::pixelsHigh].
        #[unsafe(method(setPixelsHigh:))]
        #[unsafe(method_family = none)]
        pub fn setPixelsHigh(&self, pixels_high: NSInteger);

        #[unsafe(method(layoutDirection))]
        #[unsafe(method_family = none)]
        pub fn layoutDirection(&self) -> NSImageLayoutDirection;

        /// Setter for [`layoutDirection`][Self::layoutDirection].
        #[unsafe(method(setLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub fn setLayoutDirection(&self, layout_direction: NSImageLayoutDirection);

        /// # Safety
        ///
        /// `image_rep_class` probably has further requirements.
        #[unsafe(method(registerImageRepClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerImageRepClass(image_rep_class: &AnyClass);

        /// # Safety
        ///
        /// `image_rep_class` probably has further requirements.
        #[unsafe(method(unregisterImageRepClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unregisterImageRepClass(image_rep_class: &AnyClass);

        #[unsafe(method(registeredImageRepClasses))]
        #[unsafe(method_family = none)]
        pub fn registeredImageRepClasses() -> Retained<NSArray<AnyClass>>;

        #[deprecated = "Use +imageRepClassForType: instead"]
        #[unsafe(method(imageRepClassForFileType:))]
        #[unsafe(method_family = none)]
        pub fn imageRepClassForFileType(r#type: &NSString) -> Option<&'static AnyClass>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageRepClassForType: instead"]
        #[unsafe(method(imageRepClassForPasteboardType:))]
        #[unsafe(method_family = none)]
        pub fn imageRepClassForPasteboardType(
            r#type: &NSPasteboardType,
        ) -> Option<&'static AnyClass>;

        #[unsafe(method(imageRepClassForType:))]
        #[unsafe(method_family = none)]
        pub fn imageRepClassForType(r#type: &NSString) -> Option<&'static AnyClass>;

        #[unsafe(method(imageRepClassForData:))]
        #[unsafe(method_family = none)]
        pub fn imageRepClassForData(data: &NSData) -> Option<&'static AnyClass>;

        #[unsafe(method(canInitWithData:))]
        #[unsafe(method_family = none)]
        pub fn canInitWithData(data: &NSData) -> bool;

        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[unsafe(method(imageUnfilteredFileTypes))]
        #[unsafe(method_family = none)]
        pub fn imageUnfilteredFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[unsafe(method(imageUnfilteredPasteboardTypes))]
        #[unsafe(method_family = none)]
        pub fn imageUnfilteredPasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[deprecated = "Use +imageTypes instead"]
        #[unsafe(method(imageFileTypes))]
        #[unsafe(method_family = none)]
        pub fn imageFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageTypes instead"]
        #[unsafe(method(imagePasteboardTypes))]
        #[unsafe(method_family = none)]
        pub fn imagePasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[unsafe(method(imageUnfilteredTypes))]
        #[unsafe(method_family = none)]
        pub fn imageUnfilteredTypes() -> Retained<NSArray<NSString>>;

        #[unsafe(method(imageTypes))]
        #[unsafe(method_family = none)]
        pub fn imageTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(canInitWithPasteboard:))]
        #[unsafe(method_family = none)]
        pub fn canInitWithPasteboard(pasteboard: &NSPasteboard) -> bool;

        #[unsafe(method(imageRepsWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub fn imageRepsWithContentsOfFile(
            filename: &NSString,
        ) -> Option<Retained<NSArray<NSImageRep>>>;

        #[unsafe(method(imageRepWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub fn imageRepWithContentsOfFile(filename: &NSString) -> Option<Retained<NSImageRep>>;

        #[unsafe(method(imageRepsWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub fn imageRepsWithContentsOfURL(url: &NSURL) -> Option<Retained<NSArray<NSImageRep>>>;

        #[unsafe(method(imageRepWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub fn imageRepWithContentsOfURL(url: &NSURL) -> Option<Retained<NSImageRep>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(imageRepsWithPasteboard:))]
        #[unsafe(method_family = none)]
        pub fn imageRepsWithPasteboard(
            pasteboard: &NSPasteboard,
        ) -> Option<Retained<NSArray<NSImageRep>>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(imageRepWithPasteboard:))]
        #[unsafe(method_family = none)]
        pub fn imageRepWithPasteboard(pasteboard: &NSPasteboard) -> Option<Retained<NSImageRep>>;

        #[cfg(all(feature = "NSGraphicsContext", feature = "objc2-core-graphics"))]
        #[cfg(target_vendor = "apple")]
        /// # Safety
        ///
        /// - `proposed_dest_rect` must be a valid pointer or null.
        /// - `hints` generic should be of the correct type.
        #[unsafe(method(CGImageForProposedRect:context:hints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGImageForProposedRect_context_hints(
            &self,
            proposed_dest_rect: *mut NSRect,
            context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        ) -> Option<Retained<CGImage>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSImageRep {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSImageRep {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagerepregistrydidchangenotification?language=objc)
    pub static NSImageRepRegistryDidChangeNotification: &'static NSNotificationName;
}
