//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiocomponentconfigurationinfo_validationresult?language=objc)
pub const kAudioComponentConfigurationInfo_ValidationResult: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"ValidationResult\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiocomponentvalidationparameter_timeout?language=objc)
pub const kAudioComponentValidationParameter_TimeOut: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"TimeOut\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiocomponentvalidationparameter_forcevalidation?language=objc)
pub const kAudioComponentValidationParameter_ForceValidation: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"ForceValidation\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiocomponentvalidationparameter_loadoutofprocess?language=objc)
pub const kAudioComponentValidationParameter_LoadOutOfProcess: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"LoadOutOfProcess\0") };
/// Flags found in AudioComponentDescription.componentFlags.
///
///
/// When this bit in AudioComponentDescription's componentFlags is set, AudioComponentFindNext
/// will only return this component when performing a specific, non-wildcard search for the
/// component, i.e. with non-zero values of componentType, componentSubType, and
/// componentManufacturer. This can be useful when privately registering a component.
///
///
/// An AudioComponent sets this bit in its componentFlags to indicate to the system that the
/// AudioComponent is safe to open in a sandboxed process.
///
///
/// The system sets this flag automatically when registering components which implement a version 3
/// Audio Unit.
///
///
/// The system sets this flag automatically when registering components which require asynchronous
/// instantiation via AudioComponentInstantiate (v3 audio units with views).
///
///
/// The system sets this flag automatically when registering components which can be loaded into
/// the current process. This is always true for V2 audio units; it depends on the packaging
/// in the case of a V3 audio unit.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioComponentFlags(pub u32);
bitflags::bitflags! {
    impl AudioComponentFlags: u32 {
        #[doc(alias = "kAudioComponentFlag_Unsearchable")]
        const Unsearchable = 1;
        #[doc(alias = "kAudioComponentFlag_SandboxSafe")]
        const SandboxSafe = 2;
        #[doc(alias = "kAudioComponentFlag_IsV3AudioUnit")]
        const IsV3AudioUnit = 4;
        #[doc(alias = "kAudioComponentFlag_RequiresAsyncInstantiation")]
        const RequiresAsyncInstantiation = 8;
        #[doc(alias = "kAudioComponentFlag_CanLoadInProcess")]
        const CanLoadInProcess = 0x10;
    }
}

unsafe impl Encode for AudioComponentFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioComponentFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Options controlling component instantiation.
///
/// Most component instances are loaded into the calling process.
///
/// A version 3 audio unit, however, can be loaded into a separate extension service process,
/// and this is the default behavior for these components. To be able to load one in-process
/// requires that the developer package the audio unit in a bundle separate from the application
/// extension, since an extension's main binary cannot be dynamically loaded into another
/// process.
///
/// A macOS host may request in-process loading of such audio units using
/// kAudioComponentInstantiation_LoadInProcess.
///
/// kAudioComponentFlag_IsV3AudioUnit specifies whether an audio unit is implemented using API
/// version 3.
///
/// These options are just requests to the implementation. It may fail and fall back to the
/// default.
///
/// Attempt to load the component into a separate extension process.
///
/// Attempt to load the component into the current process. Only available on macOS.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentinstantiationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioComponentInstantiationOptions(pub u32);
bitflags::bitflags! {
    impl AudioComponentInstantiationOptions: u32 {
        #[doc(alias = "kAudioComponentInstantiation_LoadOutOfProcess")]
        const LoadOutOfProcess = 1;
        #[doc(alias = "kAudioComponentInstantiation_LoadInProcess")]
        const LoadInProcess = 2;
        #[doc(alias = "kAudioComponentInstantiation_LoadedRemotely")]
        const LoadedRemotely = 1<<31;
    }
}

unsafe impl Encode for AudioComponentInstantiationOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioComponentInstantiationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentdescription?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioComponentDescription {
    pub componentType: OSType,
    pub componentSubType: OSType,
    pub componentManufacturer: OSType,
    pub componentFlags: u32,
    pub componentFlagsMask: u32,
}

unsafe impl Encode for AudioComponentDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioComponentDescription",
        &[
            <OSType>::ENCODING,
            <OSType>::ENCODING,
            <OSType>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioComponentDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudiocomponent?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioComponent {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioComponent {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueAudioComponent", &[]));
}

/// The type used to represent a class of particular audio components
///
/// An audio component is usually found through a search and is then uniquely
/// identified by the triple of an audio component's type, subtype and
/// manufacturer.
///
/// It can have properties associated with it (such as a name, a version).
///
/// It is then used as a factory (like a class in an object-oriented programming
/// language) from which to create instances. The instances are used to do the
/// actual work.
///
/// For example: the AudioComponentDescription 'aufx'/'dely'/'appl' describes the
/// delay audio unit effect from Apple, Inc. You can find this component by
/// searching explicitly for the audio component that matches this pattern (this is
/// an unique identifier - there is only one match to this triple ID). Then once
/// found, instances of the Apple delay effect audio unit can be created from its
/// audio component and used to apply that effect to an audio signal. A single
/// component can create any number of component instances.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponent?language=objc)
pub type AudioComponent = *mut OpaqueAudioComponent;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudiocomponentinstance?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioComponentInstance {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioComponentInstance {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueAudioComponentInstance", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentinstance?language=objc)
pub type AudioComponentInstance = *mut OpaqueAudioComponentInstance;

/// Generic prototype for an audio plugin method.
///
/// Every audio plugin will implement a collection of methods that match a particular
/// selector. For example, the AudioUnitInitialize API call is implemented by a
/// plugin implementing the kAudioUnitInitializeSelect selector. Any function implementing
/// an audio plugin selector conforms to the basic pattern where the first argument
/// is a pointer to the plugin instance structure, has 0 or more specific arguments,
/// and returns an OSStatus.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentmethod?language=objc)
pub type AudioComponentMethod =
    Option<unsafe extern "C-unwind" fn(NonNull<c_void>, ...) -> OSStatus>;

/// A structure used to represent an audio plugin's routines
///
/// the function used to open (or create) an audio plugin instance
///
/// the function used to close (or dispose) an audio plugin instance
///
/// this is used to return a function pointer for a given selector,
/// or NULL if that selector is not implemented
///
/// must be NULL
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentplugininterface?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioComponentPlugInInterface {
    pub Open: unsafe extern "C-unwind" fn(NonNull<c_void>, AudioComponentInstance) -> OSStatus,
    pub Close: unsafe extern "C-unwind" fn(NonNull<c_void>) -> OSStatus,
    pub Lookup: unsafe extern "C-unwind" fn(i16) -> AudioComponentMethod,
    pub reserved: *mut c_void,
}

unsafe impl Encode for AudioComponentPlugInInterface {
    const ENCODING: Encoding = Encoding::Struct("AudioComponentPlugInInterface", &[
        <unsafe extern "C-unwind" fn(NonNull<c_void>,AudioComponentInstance,) -> OSStatus>::ENCODING,
        <unsafe extern "C-unwind" fn(NonNull<c_void>,) -> OSStatus>::ENCODING,
        <unsafe extern "C-unwind" fn(i16,) -> AudioComponentMethod>::ENCODING,
        <*mut c_void>::ENCODING,
    ]);
}

unsafe impl RefEncode for AudioComponentPlugInInterface {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A function that creates AudioComponentInstances.
///
/// Authors of AudioComponents may register them from bundles as described
/// above in the discussion of this header file, or dynamically within a single
/// process, using AudioComponentRegister.
///
///
/// Parameter `inDesc`: The AudioComponentDescription specifying the component to be instantiated.
///
/// Returns: A pointer to a AudioComponentPlugInInterface structure.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentfactoryfunction?language=objc)
pub type AudioComponentFactoryFunction = Option<
    unsafe extern "C-unwind" fn(
        NonNull<AudioComponentDescription>,
    ) -> *mut AudioComponentPlugInInterface,
>;

extern "C-unwind" {
    /// Finds an audio component.
    ///
    /// This function is used to find an audio component that is the closest match
    /// to the provided values. Note that the list of available components may change
    /// dynamically in situations involving inter-app audio on iOS, or version 3
    /// audio unit extensions. See kAudioComponentRegistrationsChangedNotification.
    ///
    ///
    /// Parameter `inComponent`: If NULL, then the search starts from the beginning until an audio
    /// component is found that matches the description provided by inDesc.
    /// If non-NULL, then the search starts (continues) from the previously
    /// found audio component specified by inComponent, and will return the next
    /// found audio component.
    ///
    /// Parameter `inDesc`: The type, subtype and manufacturer fields are used to specify the audio
    /// component to search for. A value of 0 (zero) for any of these fields is
    /// a wildcard, so the first match found is returned.
    ///
    /// Returns: An audio component that matches the search parameters, or NULL if none found.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer or null.
    /// - `in_desc` must be a valid pointer.
    pub fn AudioComponentFindNext(
        in_component: AudioComponent,
        in_desc: NonNull<AudioComponentDescription>,
    ) -> AudioComponent;
}

extern "C-unwind" {
    /// Counts audio components.
    ///
    /// Returns the number of AudioComponents that match the specified
    /// AudioComponentDescription.
    ///
    /// Parameter `inDesc`: The type, subtype and manufacturer fields are used to specify the audio
    /// components to count A value of 0 (zero) for any of these fields is a
    /// wildcard, so will match any value for this field
    ///
    /// Returns: a UInt32. 0 (zero) means no audio components were found that matched the
    /// search parameters.
    ///
    /// # Safety
    ///
    /// `in_desc` must be a valid pointer.
    pub fn AudioComponentCount(in_desc: NonNull<AudioComponentDescription>) -> u32;
}

extern "C-unwind" {
    /// Retrieves the name of an audio component.
    ///
    /// the name of an audio component
    ///
    /// Parameter `inComponent`: the audio component (must not be NULL)
    ///
    /// Parameter `outName`: a CFString that is the name of the audio component. This string should
    /// be released by the caller.
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `out_name` must be a valid pointer.
    #[cfg(feature = "objc2-core-foundation")]
    pub fn AudioComponentCopyName(
        in_component: AudioComponent,
        out_name: NonNull<*const CFString>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve an audio component's description.
    ///
    /// This will return the fully specified audio component description for the
    /// provided audio component.
    ///
    /// Parameter `inComponent`: the audio component (must not be NULL)
    ///
    /// Parameter `outDesc`: the audio component description for the specified audio component
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `out_desc` must be a valid pointer.
    pub fn AudioComponentGetDescription(
        in_component: AudioComponent,
        out_desc: NonNull<AudioComponentDescription>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve an audio component's version.
    ///
    /// Parameter `inComponent`: the audio component (must not be NULL)
    ///
    /// Parameter `outVersion`: the audio component's version in the form of 0xMMMMmmDD (Major, Minor, Dot)
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `out_version` must be a valid pointer.
    pub fn AudioComponentGetVersion(
        in_component: AudioComponent,
        out_version: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates an audio component instance.
    ///
    /// This function creates an instance of a given audio component. The audio
    /// component instance is the object that does all of the work, whereas the
    /// audio component is the way an application finds and then creates this object
    /// to do this work. For example, an audio unit is a type of audio component
    /// instance, so to use an audio unit, one finds its audio component, and then
    /// creates a new instance of that component. This instance is then used to
    /// perform the audio tasks for which it was designed (process, mix, synthesise,
    /// etc.).
    ///
    /// Parameter `inComponent`: the audio component (must not be NULL)
    ///
    /// Parameter `outInstance`: the audio component instance
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `out_instance` must be a valid pointer.
    pub fn AudioComponentInstanceNew(
        in_component: AudioComponent,
        out_instance: NonNull<AudioComponentInstance>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates an audio component instance, asynchronously.
    ///
    /// This is an asynchronous version of AudioComponentInstanceNew(). It must be
    /// used to instantiate any component with kAudioComponentFlag_RequiresAsyncInstantiation
    /// set in its component flags. It may be used for other components as well.
    ///
    /// Note: Do not block the main thread while waiting for the completion handler
    /// to be called; this can deadlock.
    ///
    /// Parameter `inComponent`: the audio component
    ///
    /// Parameter `inOptions`: see AudioComponentInstantiationOptions
    ///
    /// Parameter `inCompletionHandler`: called in an arbitrary thread context when instantiation is complete.
    ///
    /// # Safety
    ///
    /// `in_component` must be a valid pointer.
    #[cfg(feature = "block2")]
    pub fn AudioComponentInstantiate(
        in_component: AudioComponent,
        in_options: AudioComponentInstantiationOptions,
        in_completion_handler: &block2::DynBlock<dyn Fn(AudioComponentInstance, OSStatus)>,
    );
}

extern "C-unwind" {
    /// Disposes of an audio component instance.
    ///
    /// This function will dispose the audio component instance that was created
    /// with the New call. It will deallocate any resources that the instance was using.
    ///
    /// Parameter `inInstance`: the audio component instance to dispose (must not be NULL)
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// `in_instance` must be a valid pointer.
    pub fn AudioComponentInstanceDispose(in_instance: AudioComponentInstance) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve the audio component from its instance
    ///
    /// Allows the application at any time to retrieve the audio component that is
    /// the factory object of a given instance (i.e., the audio component that was
    /// used to create the instance in the first place). This allows the application
    /// to retrieve general information about a particular audio component (its
    /// name, version, etc) when one just has an audio component instance to work
    /// with
    ///
    /// Parameter `inInstance`: the audio component instance (must not be NULL, and instance must be valid - that is, not disposed)
    ///
    /// Returns: a valid audio component or NULL if no component was found.
    ///
    /// # Safety
    ///
    /// `in_instance` must be a valid pointer.
    pub fn AudioComponentInstanceGetComponent(
        in_instance: AudioComponentInstance,
    ) -> AudioComponent;
}

/// Determines if an audio component instance implements a particular component
/// API call as signified by the specified selector identifier token.
///
/// Parameter `inInstance`: the audio component instance
///
/// Parameter `inSelectorID`: a number to signify the audio component API (component selector) as appropriate for the instance's component type.
///
/// Returns: a boolean
///
/// # Safety
///
/// `in_instance` must be a valid pointer.
#[inline]
pub unsafe extern "C-unwind" fn AudioComponentInstanceCanDo(
    in_instance: AudioComponentInstance,
    in_selector_id: i16,
) -> bool {
    extern "C-unwind" {
        fn AudioComponentInstanceCanDo(
            in_instance: AudioComponentInstance,
            in_selector_id: i16,
        ) -> Boolean;
    }
    let ret = unsafe { AudioComponentInstanceCanDo(in_instance, in_selector_id) };
    ret != 0
}

extern "C-unwind" {
    /// Dynamically registers an AudioComponent within the current process
    ///
    /// AudioComponents are registered either when found in appropriate bundles in the filesystem,
    /// or via this call. AudioComponents registered via this call are available only within
    /// the current process.
    ///
    ///
    /// Parameter `inDesc`: The AudioComponentDescription that describes the AudioComponent. Note that
    /// the registrar needs to be sure to set the flag kAudioComponentFlag_SandboxSafe
    /// in the componentFlags field of the AudioComponentDescription to indicate that
    /// the AudioComponent can be loaded directly into a sandboxed process.
    ///
    /// Parameter `inName`: the AudioComponent's name
    ///
    /// Parameter `inVersion`: the AudioComponent's version
    ///
    /// Parameter `inFactory`: an AudioComponentFactoryFunction which will create instances of your
    /// AudioComponent
    ///
    /// Returns: an AudioComponent object
    ///
    /// # Safety
    ///
    /// - `in_desc` must be a valid pointer.
    /// - `in_factory` must be implemented correctly.
    #[cfg(feature = "objc2-core-foundation")]
    pub fn AudioComponentRegister(
        in_desc: NonNull<AudioComponentDescription>,
        in_name: &CFString,
        in_version: u32,
        in_factory: AudioComponentFactoryFunction,
    ) -> AudioComponent;
}

extern "C-unwind" {
    /// Fetches the basic configuration info about a given AudioComponent
    ///
    /// Currently, only AudioUnits can supply this information.
    ///
    /// Parameter `inComponent`: The AudioComponent whose info is being fetched.
    ///
    /// Parameter `outConfigurationInfo`: On exit, this is CFDictionaryRef that contains information describing the
    /// capabilities of the AudioComponent. The specific information depends on the
    /// type of AudioComponent. The keys for the dictionary are defined in
    /// AudioUnitProperties.h (or other headers as appropriate for the component type).
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `out_configuration_info` must be a valid pointer.
    #[cfg(feature = "objc2-core-foundation")]
    pub fn AudioComponentCopyConfigurationInfo(
        in_component: AudioComponent,
        out_configuration_info: NonNull<*const CFDictionary>,
    ) -> OSStatus;
}

/// Constants for describing the result of validating an AudioComponent
///
/// The AudioComponent passed validation.
///
/// The AudioComponent failed validation.
///
/// The validation operation timed out before completing.
///
/// The AudioComponent failed validation during open operation as it is not authorized.
///
/// The AudioComponent failed validation during initialization as it is not authorized.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiocomponentvalidationresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioComponentValidationResult(pub u32);
impl AudioComponentValidationResult {
    #[doc(alias = "kAudioComponentValidationResult_Unknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kAudioComponentValidationResult_Passed")]
    pub const Passed: Self = Self(1);
    #[doc(alias = "kAudioComponentValidationResult_Failed")]
    pub const Failed: Self = Self(2);
    #[doc(alias = "kAudioComponentValidationResult_TimedOut")]
    pub const TimedOut: Self = Self(3);
    #[doc(alias = "kAudioComponentValidationResult_UnauthorizedError_Open")]
    pub const UnauthorizedError_Open: Self = Self(4);
    #[doc(alias = "kAudioComponentValidationResult_UnauthorizedError_Init")]
    pub const UnauthorizedError_Init: Self = Self(5);
}

unsafe impl Encode for AudioComponentValidationResult {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioComponentValidationResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `in_validation_parameters` generics must be of the correct type.
    /// - `out_validation_result` must be a valid pointer.
    #[cfg(feature = "objc2-core-foundation")]
    pub fn AudioComponentValidate(
        in_component: AudioComponent,
        in_validation_parameters: Option<&CFDictionary>,
        out_validation_result: NonNull<AudioComponentValidationResult>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Tests a specified AudioComponent for API and behavioral conformance
    /// asynchronously, returning detailed validation results.
    ///
    /// Currently, only AudioUnits can can be validated. The `inCompletionHandler` callback
    /// has two parameters, an `AudioComponentValidationResult` with result of the validation,
    /// and a `CFDictionaryRef` which contains the details of this result.
    /// This dictionary may contain the following entries:
    /// "Output"
    /// An array of strings, with the same content as if the AU was validated on auval.
    /// "Result"
    /// An `AudioComponentValidationResult` with the result of the validation
    /// process. The same as what's in the `AudioComponentValidationResult`
    /// in the `inCompletionHandler` and what `AudioComponentValidate`
    /// currently returns.
    /// "Tests"
    /// An array in which each value is a dictionary and may contain:
    /// "Name"
    /// A descriptive name of the test.
    /// "Result"
    /// An `AudioComponentValidationResult` with the result of the
    /// specific test.
    /// "Output"
    /// An array of strings with output generated by the test.
    /// "WasCached"
    /// `YES` if the returned result was cached from previous runs.
    ///
    /// Parameter `inComponent`: The AudioComponent to validate.
    ///
    /// Parameter `inValidationParameters`: A CFDictionaryRef that contains parameters for the validation operation.
    /// Passing NULL for this argument tells the system to use the default
    /// parameters.
    ///
    /// Parameter `inCompletionHandler`: Completion callback. See discussion section.
    ///
    /// Returns: an OSStatus result code.
    ///
    /// # Safety
    ///
    /// - `in_component` must be a valid pointer.
    /// - `in_validation_parameters` generics must be of the correct type.
    #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
    pub fn AudioComponentValidateWithResults(
        in_component: AudioComponent,
        in_validation_parameters: Option<&CFDictionary>,
        in_completion_handler: &block2::DynBlock<
            dyn Fn(AudioComponentValidationResult, NonNull<CFDictionary>),
        >,
    ) -> OSStatus;
}
