/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import java.io.IOException;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedRequestException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.ServerRejectedException;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.api.websocket.WebSocketUnavailableException;
import org.whispersystems.signalservice.internal.push.GroupMismatchedDevices;
import org.whispersystems.signalservice.internal.push.GroupStaleDevices;
import org.whispersystems.signalservice.internal.push.MismatchedDevices;
import org.whispersystems.signalservice.internal.push.ProofRequiredResponse;
import org.whispersystems.signalservice.internal.push.SendGroupMessageResponse;
import org.whispersystems.signalservice.internal.push.SendMessageResponse;
import org.whispersystems.signalservice.internal.push.StaleDevices;
import org.whispersystems.signalservice.internal.push.exceptions.GroupMismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupStaleDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.InAppPaymentProcessorError;
import org.whispersystems.signalservice.internal.push.exceptions.InAppPaymentReceiptCredentialError;
import org.whispersystems.signalservice.internal.push.exceptions.InvalidUnidentifiedAccessHeaderException;
import org.whispersystems.signalservice.internal.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.PaymentsRegionException;
import org.whispersystems.signalservice.internal.push.exceptions.StaleDevicesException;
import org.whispersystems.signalservice.internal.util.JsonUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\t\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u0007J!\u0010\u0010\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007H\u0007J!\u0010\u0012\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResultUtil;", "", "<init>", "()V", "successOrThrow", "T", "result", "Lorg/whispersystems/signalservice/api/NetworkResult;", "(Lorg/whispersystems/signalservice/api/NetworkResult;)Ljava/lang/Object;", "toBasicLegacy", "toMessageSendLegacy", "Lorg/whispersystems/signalservice/internal/push/SendMessageResponse;", "destination", "", "toGroupMessageSendLegacy", "Lorg/whispersystems/signalservice/internal/push/SendGroupMessageResponse;", "toPreKeysLegacy", "toSetProfileLegacy", "toIAPBasicLegacy", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nNetworkResultUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkResultUtil.kt\norg/whispersystems/signalservice/api/NetworkResultUtil\n+ 2 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult$StatusCodeError\n*L\n1#1,235:1\n208#2,10:236\n208#2,10:246\n208#2,10:256\n208#2,10:266\n208#2,10:276\n208#2,10:286\n208#2,10:296\n*S KotlinDebug\n*F\n+ 1 NetworkResultUtil.kt\norg/whispersystems/signalservice/api/NetworkResultUtil\n*L\n109#1:236,10\n110#1:246,10\n112#1:256,10\n148#1:266,10\n149#1:276,10\n227#1:286,10\n228#1:296,10\n*E\n"})
public final class NetworkResultUtil {
    @NotNull
    public static final NetworkResultUtil INSTANCE = new NetworkResultUtil();

    private NetworkResultUtil() {
    }

    @JvmStatic
    public static final <T> T successOrThrow(@NotNull NetworkResult<T> result2) throws IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<T> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw ((NetworkResult.StatusCodeError)result2).getException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    public static final <T> T toBasicLegacy(@NotNull NetworkResult<T> result2) throws IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<T> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 401: 
                    case 403: {
                        throw new AuthorizationFailedException(((NetworkResult.StatusCodeError)result2).getCode(), "Authorization failed!");
                    }
                    case 413: 
                    case 429: {
                        Long l;
                        String string = ((NetworkResult.StatusCodeError)result2).header("retry-after");
                        throw new RateLimitException(((NetworkResult.StatusCodeError)result2).getCode(), "Rate Limited", Optional.ofNullable(string != null && (l = StringsKt.toLongOrNull((String)string)) != null ? Long.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)l, (DurationUnit)DurationUnit.SECONDS))) : null));
                    }
                }
                throw ((NetworkResult.StatusCodeError)result2).getException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    @NotNull
    public static final SendMessageResponse toMessageSendLegacy(@NotNull String destination, @NotNull NetworkResult<SendMessageResponse> result2) throws AuthorizationFailedException, UnregisteredUserException, MismatchedDevicesException, StaleDevicesException, ProofRequiredException, WebSocketUnavailableException, ServerRejectedException, IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<SendMessageResponse> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 401 -> new AuthorizationFailedException(((NetworkResult.StatusCodeError)result2).getCode(), "Authorization failed!");
                    case 404 -> new UnregisteredUserException(destination, ((NetworkResult.StatusCodeError)result2).getException());
                    case 409 -> {
                        MismatchedDevices var6_12;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var6_12 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), MismatchedDevices.class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), MismatchedDevices.class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var6_12 = null;
                        }
                        MismatchedDevices var8_18 = var6_12;
                        yield new MismatchedDevicesException(var8_18);
                    }
                    case 410 -> {
                        StaleDevices var6_13;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var6_13 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), StaleDevices.class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), StaleDevices.class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var6_13 = null;
                        }
                        StaleDevices var9_19 = var6_13;
                        yield new StaleDevicesException(var9_19);
                    }
                    case 413, 429 -> {
                        Long $i$f$parseJsonBody;
                        String this_$iv = ((NetworkResult.StatusCodeError)result2).header("retry-after");
                        yield new RateLimitException(((NetworkResult.StatusCodeError)result2).getCode(), "Rate Limited", Optional.ofNullable(this_$iv != null && ($i$f$parseJsonBody = StringsKt.toLongOrNull((String)this_$iv)) != null ? Long.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)$i$f$parseJsonBody, (DurationUnit)DurationUnit.SECONDS))) : null));
                    }
                    case 428 -> {
                        Object v1;
                        ProofRequiredResponse var6_14;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var6_14 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), ProofRequiredResponse.class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), ProofRequiredResponse.class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var6_14 = null;
                        }
                        long var10_20 = (v1 = ((NetworkResult.StatusCodeError)result2).header("retry-after")) != null && (v1 = StringsKt.toLongOrNull((String)v1)) != null ? (Long)v1 : -1L;
                        ProofRequiredResponse var12_21 = var6_14;
                        yield new ProofRequiredException(var12_21, var10_20);
                    }
                    case 508 -> new ServerRejectedException();
                    default -> ((NetworkResult.StatusCodeError)result2).getException();
                };
            }
            throw new NoWhenBranchMatchedException();
        }
        return (SendMessageResponse)((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    @NotNull
    public static final SendGroupMessageResponse toGroupMessageSendLegacy(@NotNull NetworkResult<SendGroupMessageResponse> result2) throws InvalidUnidentifiedAccessHeaderException, NotFoundException, GroupMismatchedDevicesException, GroupStaleDevicesException, RateLimitException, ServerRejectedException, WebSocketUnavailableException, IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<SendGroupMessageResponse> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 401 -> new InvalidUnidentifiedAccessHeaderException();
                    case 404 -> new NotFoundException("At least one unregistered user is message send.");
                    case 409 -> {
                        GroupMismatchedDevices[] var5_9;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var5_9 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), GroupMismatchedDevices[].class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), GroupMismatchedDevices[].class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var5_9 = null;
                        }
                        GroupMismatchedDevices[] var7_13 = var5_9;
                        yield new GroupMismatchedDevicesException(var7_13);
                    }
                    case 410 -> {
                        GroupStaleDevices[] var5_10;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var5_10 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), GroupStaleDevices[].class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), GroupStaleDevices[].class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var5_10 = null;
                        }
                        GroupStaleDevices[] var8_14 = var5_10;
                        yield new GroupStaleDevicesException(var8_14);
                    }
                    case 413, 429 -> {
                        Long var4_8;
                        String var3_5 = ((NetworkResult.StatusCodeError)result2).header("retry-after");
                        throw new RateLimitException(((NetworkResult.StatusCodeError)result2).getCode(), "Rate Limited", Optional.ofNullable(var3_5 != null && (var4_8 = StringsKt.toLongOrNull((String)var3_5)) != null ? Long.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)var4_8, (DurationUnit)DurationUnit.SECONDS))) : null));
                    }
                    case 508 -> new ServerRejectedException();
                    default -> ((NetworkResult.StatusCodeError)result2).getException();
                };
            }
            throw new NoWhenBranchMatchedException();
        }
        return (SendGroupMessageResponse)((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    public static final <T> T toPreKeysLegacy(@NotNull NetworkResult<T> result2) throws IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<T> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 400, 401 -> new AuthorizationFailedException(((NetworkResult.StatusCodeError)result2).getCode(), "Authorization failed!");
                    case 404 -> new NotFoundException("Not found");
                    case 429 -> new RateLimitException(((NetworkResult.StatusCodeError)result2).getCode(), "Rate limit exceeded: " + ((NetworkResult.StatusCodeError)result2).getCode(), Optional.empty());
                    case 508 -> new ServerRejectedException();
                    default -> ((NetworkResult.StatusCodeError)result2).getException();
                };
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    @Nullable
    public static final String toSetProfileLegacy(@NotNull NetworkResult<String> result2) throws AuthorizationFailedException, PaymentsRegionException, RateLimitException, IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<String> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 401 -> new AuthorizationFailedException(((NetworkResult.StatusCodeError)result2).getCode(), "Authorization failed!");
                    case 403 -> new PaymentsRegionException(((NetworkResult.StatusCodeError)result2).getCode());
                    case 413, 429 -> {
                        String v1 = ((NetworkResult.StatusCodeError)result2).header("retry-after");
                        yield new RateLimitException(((NetworkResult.StatusCodeError)result2).getCode(), "Rate Limited", Optional.ofNullable(v1 != null ? StringsKt.toLongOrNull((String)v1) : null));
                    }
                    default -> ((NetworkResult.StatusCodeError)result2).getException();
                };
            }
            throw new NoWhenBranchMatchedException();
        }
        return (String)((NetworkResult.Success)result2).getResult();
    }

    @JvmStatic
    public static final <T> T toIAPBasicLegacy(@NotNull NetworkResult<T> result2) throws IOException {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult<T> networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                Throwable error = ((NetworkResult.ApplicationError)result2).getThrowable();
                throw error instanceof IOException || error instanceof RuntimeException ? error : (Throwable)new RuntimeException(error);
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                throw ((NetworkResult.NetworkError)result2).getException();
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                throw switch (((NetworkResult.StatusCodeError)result2).getCode()) {
                    case 402 -> {
                        InAppPaymentReceiptCredentialError var5_7;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var5_7 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), InAppPaymentReceiptCredentialError.class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), InAppPaymentReceiptCredentialError.class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var5_7 = null;
                        }
                        InAppPaymentReceiptCredentialError v0 = var5_7;
                        yield v0 != null ? (NonSuccessfulResponseCodeException)v0 : ((NetworkResult.StatusCodeError)result2).getException();
                    }
                    case 440 -> {
                        InAppPaymentProcessorError var5_8;
                        NetworkResult.StatusCodeError this_$iv = (NetworkResult.StatusCodeError)result2;
                        boolean $i$f$parseJsonBody = false;
                        try {
                            var5_8 = this_$iv.getStringBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getStringBody(), InAppPaymentProcessorError.class) : (this_$iv.getBinaryBody() != null ? JsonUtil.fromJsonResponse(this_$iv.getBinaryBody(), InAppPaymentProcessorError.class) : null);
                        }
                        catch (MalformedRequestException <unused var>$iv) {
                            var5_8 = null;
                        }
                        InAppPaymentProcessorError v2 = var5_8;
                        yield v2 != null ? (NonSuccessfulResponseCodeException)v2 : ((NetworkResult.StatusCodeError)result2).getException();
                    }
                    default -> ((NetworkResult.StatusCodeError)result2).getException();
                };
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((NetworkResult.Success)result2).getResult();
    }
}

