/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asamk.signal.commands.Commands;
import org.asamk.signal.http.ServerSentEventSender;
import org.asamk.signal.json.JsonReceiveMessageHandler;
import org.asamk.signal.jsonrpc.JsonRpcReader;
import org.asamk.signal.jsonrpc.JsonRpcResponse;
import org.asamk.signal.jsonrpc.JsonRpcSender;
import org.asamk.signal.jsonrpc.SignalJsonRpcCommandHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerHandler
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private final ObjectMapper objectMapper = Util.createJsonObjectMapper();
    private final InetSocketAddress address;
    private final SignalJsonRpcCommandHandler commandHandler;
    private final MultiAccountManager c;
    private final Manager m;
    private HttpServer server;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public HttpServerHandler(InetSocketAddress address, Manager m) {
        this.address = address;
        this.commandHandler = new SignalJsonRpcCommandHandler(m, Commands::getCommand);
        this.c = null;
        this.m = m;
    }

    public HttpServerHandler(InetSocketAddress address, MultiAccountManager c) {
        this.address = address;
        this.commandHandler = new SignalJsonRpcCommandHandler(c, Commands::getCommand);
        this.c = c;
        this.m = null;
    }

    public void init() throws IOException {
        if (this.server != null) {
            throw new AssertionError((Object)"HttpServerHandler already initialized");
        }
        logger.debug("Starting HTTP server on {}", (Object)this.address);
        this.server = HttpServer.create(this.address, 0);
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.createContext("/api/v1/rpc", this::handleRpcEndpoint);
        this.server.createContext("/api/v1/events", this::handleEventsEndpoint);
        this.server.createContext("/api/v1/check", this::handleCheckEndpoint);
        this.server.start();
        logger.info("Started HTTP server on {}", (Object)this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.server != null) {
            this.shutdown.set(true);
            HttpServerHandler httpServerHandler = this;
            synchronized (httpServerHandler) {
                this.notifyAll();
            }
            this.server.stop(2);
            this.server = null;
            this.shutdown.set(false);
        }
    }

    private void sendResponse(int status, Object response, HttpExchange httpExchange) throws IOException {
        if (response != null) {
            byte[] byteResponse = this.objectMapper.writeValueAsBytes(response);
            httpExchange.getResponseHeaders().add("Content-Type", "application/json");
            httpExchange.sendResponseHeaders(status, byteResponse.length);
            httpExchange.getResponseBody().write(byteResponse);
        } else {
            httpExchange.sendResponseHeaders(status, -1L);
        }
        httpExchange.getResponseBody().close();
    }

    private void handleRpcEndpoint(HttpExchange httpExchange) throws IOException {
        if (!"/api/v1/rpc".equals(httpExchange.getRequestURI().getPath())) {
            this.sendResponse(404, null, httpExchange);
            return;
        }
        if (!"POST".equals(httpExchange.getRequestMethod())) {
            this.sendResponse(405, null, httpExchange);
            return;
        }
        String contentType = httpExchange.getRequestHeaders().getFirst("Content-Type");
        if (contentType == null || !contentType.startsWith("application/json")) {
            this.sendResponse(415, null, httpExchange);
            return;
        }
        try {
            Object[] result = new Object[]{null};
            JsonRpcSender jsonRpcSender = new JsonRpcSender(s -> {
                if (result[0] != null) {
                    throw new AssertionError((Object)"There should only be a single JSON-RPC response");
                }
                result[0] = s;
            });
            JsonRpcReader jsonRpcReader = new JsonRpcReader(jsonRpcSender, httpExchange.getRequestBody());
            jsonRpcReader.readMessages((method, params) -> this.commandHandler.handleRequest(this.objectMapper, method, params), response -> logger.debug("Received unexpected response for id {}", (Object)response.getId()));
            if (result[0] != null) {
                this.sendResponse(200, result[0], httpExchange);
            } else {
                this.sendResponse(201, null, httpExchange);
            }
        }
        catch (Throwable aEx) {
            logger.error("Failed to process request.", aEx);
            this.sendResponse(200, JsonRpcResponse.forError(new JsonRpcResponse.Error(-32603, "An internal server error has occurred.", null), null), httpExchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleEventsEndpoint(HttpExchange httpExchange) throws IOException {
        List<Pair<Manager, Manager.ReceiveMessageHandler>> handlers;
        AtomicBoolean shouldStop;
        ServerSentEventSender sender;
        block18: {
            if (!"/api/v1/events".equals(httpExchange.getRequestURI().getPath())) {
                this.sendResponse(404, null, httpExchange);
                return;
            }
            if (!"GET".equals(httpExchange.getRequestMethod())) {
                this.sendResponse(405, null, httpExchange);
                return;
            }
            try {
                String queryString = httpExchange.getRequestURI().getRawQuery();
                Map<String, String> query = queryString == null ? Map.of() : Util.getQueryMap(queryString);
                List<Manager> managers = this.getManagerFromQuery(query);
                if (managers == null) {
                    this.sendResponse(400, null, httpExchange);
                    return;
                }
                httpExchange.getResponseHeaders().add("Content-Type", "text/event-stream");
                httpExchange.sendResponseHeaders(200, 0L);
                sender = new ServerSentEventSender(httpExchange.getResponseBody());
                shouldStop = new AtomicBoolean(false);
                handlers = this.subscribeReceiveHandlers(managers, sender, () -> {
                    shouldStop.set(true);
                    HttpServerHandler httpServerHandler = this;
                    synchronized (httpServerHandler) {
                        this.notifyAll();
                    }
                });
                try {}
                catch (Throwable throwable) {
                    for (Pair<Manager, Manager.ReceiveMessageHandler> pair : handlers) {
                        this.unsubscribeReceiveHandler(pair);
                    }
                    try {
                        httpExchange.getResponseBody().close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                break block18;
            }
            catch (Throwable aEx) {
                logger.error("Failed to process request.", aEx);
                this.sendResponse(500, null, httpExchange);
            }
            return;
        }
        while (true) {
            HttpServerHandler httpServerHandler = this;
            synchronized (httpServerHandler) {
                this.wait(15000L);
                if (shouldStop.get() || this.shutdown.get()) break;
            }
            try {
                sender.sendKeepAlive();
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        for (Pair pair : handlers) {
            this.unsubscribeReceiveHandler((Pair<Manager, Manager.ReceiveMessageHandler>)pair);
        }
        try {
            httpExchange.getResponseBody().close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void handleCheckEndpoint(HttpExchange httpExchange) throws IOException {
        if (!"/api/v1/check".equals(httpExchange.getRequestURI().getPath())) {
            this.sendResponse(404, null, httpExchange);
            return;
        }
        if (!"GET".equals(httpExchange.getRequestMethod())) {
            this.sendResponse(405, null, httpExchange);
            return;
        }
        this.sendResponse(200, null, httpExchange);
    }

    private List<Manager> getManagerFromQuery(Map<String, String> query) {
        if (this.m != null) {
            return List.of(this.m);
        }
        if (this.c != null) {
            String account = query.get("account");
            if (account == null || account.isEmpty()) {
                return this.c.getManagers();
            }
            Manager manager = this.c.getManager(account);
            if (manager == null) {
                return null;
            }
            return List.of(manager);
        }
        throw new AssertionError((Object)"Unreachable state");
    }

    private List<Pair<Manager, Manager.ReceiveMessageHandler>> subscribeReceiveHandlers(List<Manager> managers, ServerSentEventSender sender, Callable unsubscribe) {
        return managers.stream().map(m1 -> {
            JsonReceiveMessageHandler receiveMessageHandler = new JsonReceiveMessageHandler((Manager)m1, s -> {
                try {
                    sender.sendEvent(null, "receive", List.of(this.objectMapper.writeValueAsString(s)));
                }
                catch (IOException e) {
                    unsubscribe.call();
                }
            });
            m1.addReceiveHandler((Manager.ReceiveMessageHandler)receiveMessageHandler);
            return new Pair(m1, (Object)receiveMessageHandler);
        }).toList();
    }

    private void unsubscribeReceiveHandler(Pair<Manager, Manager.ReceiveMessageHandler> pair) {
        Manager m = (Manager)pair.first();
        Manager.ReceiveMessageHandler handler = (Manager.ReceiveMessageHandler)pair.second();
        m.removeReceiveHandler(handler);
    }

    private static interface Callable {
        public void call();
    }
}

