/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.main.lock.GenericDataSource;
import org.apache.karaf.main.lock.GenericStatements;
import org.apache.karaf.main.lock.Lock;
import org.apache.karaf.main.util.BootstrapLogManager;

public class GenericJDBCLock
implements Lock {
    final Logger LOG = Logger.getLogger(this.getClass().getName());
    public static final String PROPERTY_LOCK_URL = "karaf.lock.jdbc.url";
    public static final String PROPERTY_LOCK_JDBC_DRIVER = "karaf.lock.jdbc.driver";
    public static final String PROPERTY_LOCK_JDBC_USER = "karaf.lock.jdbc.user";
    public static final String PROPERTY_LOCK_JDBC_PASSWORD = "karaf.lock.jdbc.password";
    public static final String PROPERTY_LOCK_JDBC_TABLE = "karaf.lock.jdbc.table";
    public static final String PROPERTY_LOCK_JDBC_TABLE_ID = "karaf.lock.jdbc.table_id";
    public static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "karaf.lock.jdbc.clustername";
    public static final String PROPERTY_LOCK_JDBC_CACHE = "karaf.lock.jdbc.cache";
    public static final String PROPERTY_LOCK_JDBC_VALID_TIMEOUT = "karaf.lock.jdbc.valid_timeout";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_TABLE = "KARAF_LOCK";
    public static final String DEFAULT_TABLE_ID = "KARAF_NODE_ID";
    public static final String DEFAULT_CLUSTERNAME = "karaf";
    public static final String DEFAULT_CACHE = "true";
    public static final String DEFAULT_VALID_TIMEOUT = "0";
    final GenericStatements statements;
    DataSource dataSource;
    String url;
    String driver;
    String table;
    String clusterName;
    String table_id;
    int lock_delay;
    private int uniqueId = 0;
    private int state = 0;
    private int currentId = 0;
    private int currentState = 0;
    private long currentStateTime;
    private int currentLockDelay;

    public GenericJDBCLock(Properties props) {
        BootstrapLogManager.configureLogger(this.LOG);
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE, DEFAULT_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME, DEFAULT_CLUSTERNAME);
        this.table_id = props.getProperty(PROPERTY_LOCK_JDBC_TABLE_ID, DEFAULT_TABLE_ID);
        this.lock_delay = Integer.parseInt(props.getProperty("karaf.lock.delay", "1000"));
        this.statements = this.createStatements();
        String url = this.url;
        if (url.toLowerCase().startsWith("jdbc:derby")) {
            url = url.toLowerCase().contains("create=true") ? url : url + ";create=true";
        }
        boolean cacheEnabled = Boolean.parseBoolean(props.getProperty(PROPERTY_LOCK_JDBC_CACHE, DEFAULT_CACHE));
        int validTimeout = Integer.parseInt(props.getProperty(PROPERTY_LOCK_JDBC_VALID_TIMEOUT, DEFAULT_VALID_TIMEOUT));
        String user = props.getProperty(PROPERTY_LOCK_JDBC_USER, "");
        String password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD, "");
        this.dataSource = new GenericDataSource(this.driver, url, user, password, cacheEnabled, validTimeout);
        this.init();
    }

    GenericStatements createStatements() {
        return new GenericStatements(this.table, this.table_id, this.clusterName);
    }

    void init() {
        try {
            this.createDatabase();
            try (Connection connection = this.getConnection();){
                this.createSchema(connection);
                this.generateUniqueId(connection);
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error occured while attempting to obtain connection", e);
        }
    }

    void createDatabase() {
    }

    void createSchema(Connection connection) {
        try {
            if (this.schemaExists(connection)) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                String[] createStatements;
                connection.setAutoCommit(false);
                for (String stmt : createStatements = this.statements.getLockCreateSchemaStatements(System.currentTimeMillis())) {
                    this.LOG.info("Executing statement: " + stmt);
                    statement.execute(stmt);
                }
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Could not create schema", e);
        }
    }

    boolean schemaExists(Connection connection) {
        return this.schemaExist(connection, this.statements.getLockTableName()) && this.schemaExist(connection, this.statements.getLockIdTableName());
    }

    private boolean schemaExist(Connection connection, String tableName) {
        boolean schemaExists = false;
        try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});){
            schemaExists = rs.next();
        }
        catch (Exception ignore) {
            this.LOG.log(Level.SEVERE, "Error testing for db table", ignore);
        }
        return schemaExists;
    }

    void generateUniqueId(Connection connection) {
        String selectString = this.statements.getLockIdSelectStatement();
        try (PreparedStatement selectStatement = connection.prepareStatement(selectString);){
            boolean uniqueIdSet = false;
            while (!uniqueIdSet) {
                try {
                    ResultSet rs = selectStatement.executeQuery();
                    try {
                        if (rs.next()) {
                            int currentId = this.statements.getIdFromLockIdSelectStatement(rs);
                            String updateString = this.statements.getLockIdUpdateIdStatement(currentId + 1, currentId);
                            PreparedStatement updateStatement = connection.prepareStatement(updateString);
                            try {
                                int count = updateStatement.executeUpdate();
                                uniqueIdSet = count > 0;
                                int n = this.uniqueId = uniqueIdSet ? currentId + 1 : 0;
                                if (count <= 1) continue;
                                this.LOG.severe("OOPS there are more than one row within the table ids...");
                                continue;
                            }
                            finally {
                                if (updateStatement != null) {
                                    updateStatement.close();
                                }
                                continue;
                            }
                        }
                        this.LOG.severe("No rows were found....");
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    this.LOG.log(Level.SEVERE, "Received an SQL exception while processing result set", e);
                }
            }
        }
        catch (SQLException e) {
            this.LOG.log(Level.SEVERE, "Received an SQL exception while generating a prepate statement", e);
        }
        this.LOG.info("INSTANCE unique id: " + this.uniqueId);
    }

    protected Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }

    @Override
    public boolean lock() throws Exception {
        boolean bl;
        block30: {
            Connection connection = this.getConnection();
            try {
                boolean lockAcquired = this.acquireLock(connection, this.statements.getLockUpdateIdStatement(this.uniqueId, ++this.state, this.lock_delay, this.uniqueId));
                if (!lockAcquired) {
                    String lockSelectStatement = this.statements.getLockSelectStatement();
                    try (PreparedStatement statement = connection.prepareStatement(lockSelectStatement);
                         ResultSet rs = statement.executeQuery();){
                        if (rs.next()) {
                            int currentId = this.statements.getIdFromLockSelectStatement(rs);
                            int currentState = this.statements.getStateFromLockSelectStatement(rs);
                            if (this.currentId == currentId) {
                                if (this.currentState == currentState) {
                                    if (this.currentStateTime + (long)this.currentLockDelay + (long)this.currentLockDelay < System.currentTimeMillis()) {
                                        lockAcquired = this.acquireLock(connection, this.statements.getLockUpdateIdStatementToStealLock(this.uniqueId, this.state, this.lock_delay, currentId, currentState));
                                    }
                                } else {
                                    this.currentStateTime = System.currentTimeMillis();
                                    this.currentState = currentState;
                                }
                            } else {
                                this.currentId = currentId;
                                this.currentState = currentState;
                                this.currentStateTime = System.currentTimeMillis();
                                this.currentLockDelay = this.statements.getLockDelayFromLockSelectStatement(rs);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.LOG.log(Level.SEVERE, "Unable to determine if the lock was obtain", e);
                    }
                }
                bl = lockAcquired;
                if (connection == null) break block30;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.LOG.log(Level.SEVERE, "Error while trying to obtain the lock", e);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    private boolean acquireLock(Connection connection, String lockUpdateIdStatement) {
        boolean bl;
        block8: {
            PreparedStatement preparedStatement = connection.prepareStatement(lockUpdateIdStatement);
            try {
                boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.LOG.log(Level.WARNING, "Failed to acquire database lock", e);
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    @Override
    public void release() throws Exception {
        try (Connection connection = this.getConnection();){
            String lockResetIdStatement = this.statements.getLockResetIdStatement(this.uniqueId);
            try (PreparedStatement preparedStatement = connection.prepareStatement(lockResetIdStatement);){
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.LOG.log(Level.SEVERE, "Exception while releasing lock", e);
        }
    }

    @Override
    public boolean isAlive() throws Exception {
        return this.lock();
    }
}

