/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.Objects;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;

public class EventListenerKey
implements Comparable<EventListenerKey> {
    private final int serviceRank;
    private final long serviceId;
    private final int ranklessPosition;
    private final int hashCode;

    private EventListenerKey(int serviceRank, long serviceId, int ranklessPosition, int hashCode) {
        this.serviceRank = serviceRank;
        this.serviceId = serviceId;
        this.ranklessPosition = ranklessPosition;
        this.hashCode = hashCode;
    }

    public static EventListenerKey ofModel(EventListenerModel model) {
        return new EventListenerKey(model.getServiceRank(), model.getServiceId(), -1, System.identityHashCode(model));
    }

    public static EventListenerKey ofPosition(int position) {
        return new EventListenerKey(0, 0L, position, 0);
    }

    public int getServiceRank() {
        return this.serviceRank;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public int getRanklessPosition() {
        return this.ranklessPosition;
    }

    @Override
    public int compareTo(EventListenerKey o) {
        int c1 = Integer.compare(this.serviceRank, o.serviceRank);
        if (c1 != 0) {
            return -c1;
        }
        int c2 = Long.compare(this.serviceId, o.serviceId);
        if (c2 != 0) {
            return c2;
        }
        if (this.ranklessPosition >= 0 && o.ranklessPosition >= 0) {
            return Integer.compare(this.ranklessPosition, o.ranklessPosition);
        }
        if (this.ranklessPosition >= 0) {
            return 1;
        }
        if (o.ranklessPosition >= 0) {
            return -1;
        }
        return Integer.compare(this.hashCode, o.hashCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventListenerKey that = (EventListenerKey)o;
        if (this.ranklessPosition > 0) {
            return this.ranklessPosition == that.ranklessPosition;
        }
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return Objects.hash(this.ranklessPosition, this.hashCode);
    }
}

