/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationDefaultAttribute;
import aQute.bnd.classfile.BootstrapMethodsAttribute;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ConstantValueAttribute;
import aQute.bnd.classfile.DeprecatedAttribute;
import aQute.bnd.classfile.EnclosingMethodAttribute;
import aQute.bnd.classfile.ExceptionsAttribute;
import aQute.bnd.classfile.InnerClassesAttribute;
import aQute.bnd.classfile.LineNumberTableAttribute;
import aQute.bnd.classfile.LocalVariableTableAttribute;
import aQute.bnd.classfile.LocalVariableTypeTableAttribute;
import aQute.bnd.classfile.MethodParametersAttribute;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.classfile.ModuleMainClassAttribute;
import aQute.bnd.classfile.ModulePackagesAttribute;
import aQute.bnd.classfile.NestHostAttribute;
import aQute.bnd.classfile.NestMembersAttribute;
import aQute.bnd.classfile.PermittedSubclassesAttribute;
import aQute.bnd.classfile.RecordAttribute;
import aQute.bnd.classfile.RuntimeInvisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.bnd.classfile.SourceDebugExtensionAttribute;
import aQute.bnd.classfile.SourceFileAttribute;
import aQute.bnd.classfile.StackMapTableAttribute;
import aQute.bnd.classfile.SyntheticAttribute;
import aQute.bnd.classfile.UnrecognizedAttribute;
import aQute.lib.io.LimitedDataInput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Attribute {
    public String name();

    public void write(DataOutput var1, ConstantPool var2) throws IOException;

    public int attribute_length();

    public static Attribute[] readAttributes(DataInput in, ConstantPool constant_pool) throws IOException {
        int attributes_count = in.readUnsignedShort();
        Attribute[] attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            attributes[i] = Attribute.readAttribute(in, constant_pool);
        }
        return attributes;
    }

    public static Attribute readAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        int attribute_length = in.readInt();
        String attribute_name = constant_pool.utf8(attribute_name_index);
        in = LimitedDataInput.wrap(in, attribute_length);
        switch (attribute_name) {
            case "AnnotationDefault": {
                return AnnotationDefaultAttribute.read(in, constant_pool);
            }
            case "BootstrapMethods": {
                return BootstrapMethodsAttribute.read(in, constant_pool);
            }
            case "Code": {
                return CodeAttribute.read(in, constant_pool);
            }
            case "ConstantValue": {
                return ConstantValueAttribute.read(in, constant_pool);
            }
            case "Deprecated": {
                return DeprecatedAttribute.read(in, constant_pool);
            }
            case "EnclosingMethod": {
                return EnclosingMethodAttribute.read(in, constant_pool);
            }
            case "Exceptions": {
                return ExceptionsAttribute.read(in, constant_pool);
            }
            case "InnerClasses": {
                return InnerClassesAttribute.read(in, constant_pool);
            }
            case "LineNumberTable": {
                return LineNumberTableAttribute.read(in, constant_pool);
            }
            case "LocalVariableTable": {
                return LocalVariableTableAttribute.read(in, constant_pool);
            }
            case "LocalVariableTypeTable": {
                return LocalVariableTypeTableAttribute.read(in, constant_pool);
            }
            case "MethodParameters": {
                return MethodParametersAttribute.read(in, constant_pool);
            }
            case "Module": {
                return ModuleAttribute.read(in, constant_pool);
            }
            case "ModuleMainClass": {
                return ModuleMainClassAttribute.read(in, constant_pool);
            }
            case "ModulePackages": {
                return ModulePackagesAttribute.read(in, constant_pool);
            }
            case "NestHost": {
                return NestHostAttribute.read(in, constant_pool);
            }
            case "NestMembers": {
                return NestMembersAttribute.read(in, constant_pool);
            }
            case "RuntimeInvisibleAnnotations": {
                return RuntimeInvisibleAnnotationsAttribute.read(in, constant_pool);
            }
            case "RuntimeInvisibleParameterAnnotations": {
                return RuntimeInvisibleParameterAnnotationsAttribute.read(in, constant_pool);
            }
            case "RuntimeInvisibleTypeAnnotations": {
                return RuntimeInvisibleTypeAnnotationsAttribute.read(in, constant_pool);
            }
            case "RuntimeVisibleAnnotations": {
                return RuntimeVisibleAnnotationsAttribute.read(in, constant_pool);
            }
            case "RuntimeVisibleParameterAnnotations": {
                return RuntimeVisibleParameterAnnotationsAttribute.read(in, constant_pool);
            }
            case "RuntimeVisibleTypeAnnotations": {
                return RuntimeVisibleTypeAnnotationsAttribute.read(in, constant_pool);
            }
            case "Signature": {
                return SignatureAttribute.read(in, constant_pool);
            }
            case "SourceDebugExtension": {
                return SourceDebugExtensionAttribute.read(in, attribute_length);
            }
            case "SourceFile": {
                return SourceFileAttribute.read(in, constant_pool);
            }
            case "StackMapTable": {
                return StackMapTableAttribute.read(in, constant_pool);
            }
            case "Synthetic": {
                return SyntheticAttribute.read(in, constant_pool);
            }
            case "Record": {
                return RecordAttribute.read(in, constant_pool);
            }
            case "PermittedSubclasses": {
                return PermittedSubclassesAttribute.read(in, constant_pool);
            }
        }
        return UnrecognizedAttribute.read(in, attribute_name, attribute_length);
    }

    public static void writeAttributes(DataOutput out, ConstantPool constant_pool, Attribute[] attributes) throws IOException {
        out.writeShort(attributes.length);
        for (Attribute attribute : attributes) {
            attribute.write(out, constant_pool);
        }
    }

    public static int attributes_length(Attribute[] attributes) {
        int attribute_length = 2;
        for (Attribute attribute : attributes) {
            attribute_length += 6 + attribute.attribute_length();
        }
        return attribute_length;
    }
}

