#!/usr/bin/env bash

cd "$(dirname $(realpath $0))"

ASSERTIONS=($(
  go tool nm "$(go list -export -f '{{.Export}}' github.com/smarty/assertions)" |\
    awk '/ T github\.com\/smarty\/assertions\.Should/{split($3, a, "."); print a[3]}' |\
    sort | uniq))

(
  echo "package convey"
  echo
  echo "// DO NOT EDIT: generated by update_assertions.sh"
  echo
  echo "//go:generate ./update_assertions.sh"
  echo
  echo "import \"github.com/smarty/assertions\""
  echo
  echo "// These assertions are forwarded from github.com/smarty/assertions"
  echo "// in order to make convey self-contained."
  echo "var ("

  for assertion in "${ASSERTIONS[@]}"
  do
    echo "  $assertion = assertions.$assertion"
  done

  echo ")"
) > ./assertions.go

go fmt ./assertions.go
