/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultilineRecursiveToStringStyleTest
extends AbstractLangTest {
    private static final String LS = System.lineSeparator();
    private static final String BASE_WITH_ARRAYS_TO_STRING = "[" + LS + "  boolArray=#BOOLEAN#," + LS + "  byteArray=#BYTE#," + LS + "  charArray=#CHAR#," + LS + "  doubleArray=#DOUBLE#," + LS + "  floatArray=#FLOAT#," + LS + "  intArray=#INT#," + LS + "  longArray=#LONG#," + LS + "  shortArray=#SHORT#," + LS + "  stringArray=#STRING#" + LS + "]";

    @Test
    public void boolArray() {
        WithArrays wa = new WithArrays();
        wa.boolArray = new boolean[]{true, false, true};
        String exp = this.getExpectedToString(wa, WithArraysTestType.BOOLEAN, "{" + LS + "    true," + LS + "    false," + LS + "    true" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void byteArray() {
        WithArrays wa = new WithArrays();
        wa.byteArray = new byte[]{1, 2};
        String exp = this.getExpectedToString(wa, WithArraysTestType.BYTE, "{" + LS + "    1," + LS + "    2" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void charArray() {
        WithArrays wa = new WithArrays();
        wa.charArray = new char[]{'a', 'A'};
        String exp = this.getExpectedToString(wa, WithArraysTestType.CHAR, "{" + LS + "    a," + LS + "    A" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void doubleArray() {
        WithArrays wa = new WithArrays();
        wa.doubleArray = new double[]{1.0, 2.0};
        String exp = this.getExpectedToString(wa, WithArraysTestType.DOUBLE, "{" + LS + "    1.0," + LS + "    2.0" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void floatArray() {
        WithArrays wa = new WithArrays();
        wa.floatArray = new float[]{1.0f, 2.0f};
        String exp = this.getExpectedToString(wa, WithArraysTestType.FLOAT, "{" + LS + "    1.0," + LS + "    2.0" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    private String getClassPrefix(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private String getExpectedToString(WithArrays wa, WithArraysTestType arrayType, String expectedArrayValue) {
        return this.getClassPrefix(wa) + BASE_WITH_ARRAYS_TO_STRING.replace("#" + (Object)((Object)arrayType) + "#", expectedArrayValue).replaceAll("#[A-Z]+#", "<null>");
    }

    @Test
    public void intArray() {
        WithArrays wa = new WithArrays();
        wa.intArray = new int[]{1, 2};
        String exp = this.getExpectedToString(wa, WithArraysTestType.INT, "{" + LS + "    1," + LS + "    2" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void longArray() {
        WithArrays wa = new WithArrays();
        wa.longArray = new long[]{1L, 2L};
        String exp = this.getExpectedToString(wa, WithArraysTestType.LONG, "{" + LS + "    1," + LS + "    2" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void nestedAndArray() {
        Account acc = new Account();
        Transaction tx1 = new Transaction("2014.10.14", 100.0);
        Transaction tx2 = new Transaction("2014.10.15", 50.0);
        acc.transactions.add(tx1);
        acc.transactions.add(tx2);
        String expected = this.getClassPrefix(acc) + "[" + LS + "  owner=<null>," + LS + "  transactions=" + this.getClassPrefix(acc.transactions) + "{" + LS + "    " + this.getClassPrefix(tx1) + "[" + LS + "      amount=100.0," + LS + "      date=2014.10.14" + LS + "    ]," + LS + "    " + this.getClassPrefix(tx2) + "[" + LS + "      amount=50.0," + LS + "      date=2014.10.15" + LS + "    ]" + LS + "  }" + LS + "]";
        Assertions.assertEquals((Object)expected, (Object)this.toString(acc));
    }

    @Test
    public void nestedElements() {
        Bank bank;
        Customer customer = new Customer("Douglas Adams");
        customer.bank = bank = new Bank("ASF Bank");
        String exp = this.getClassPrefix(customer) + "[" + LS + "  accounts=<null>," + LS + "  bank=" + this.getClassPrefix(bank) + "[" + LS + "    name=ASF Bank" + LS + "  ]," + LS + "  name=Douglas Adams" + LS + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(customer));
    }

    @Test
    public void noArray() {
        WithArrays wa = new WithArrays();
        String exp = this.getExpectedToString(wa, WithArraysTestType.NONE, "");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void shortArray() {
        WithArrays wa = new WithArrays();
        wa.shortArray = new short[]{1, 2};
        String exp = this.getExpectedToString(wa, WithArraysTestType.SHORT, "{" + LS + "    1," + LS + "    2" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void simpleObject() {
        Transaction tx = new Transaction("2014.10.15", 100.0);
        String expected = this.getClassPrefix(tx) + "[" + LS + "  amount=100.0," + LS + "  date=2014.10.15" + LS + "]";
        Assertions.assertEquals((Object)expected, (Object)this.toString(tx));
    }

    @Test
    public void stringArray() {
        WithArrays wa = new WithArrays();
        wa.stringArray = new String[]{"a", "A"};
        String exp = this.getExpectedToString(wa, WithArraysTestType.STRING, "{" + LS + "    a," + LS + "    A" + LS + "  }");
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void testLANG1319() {
        String[] stringArray = new String[]{"1", "2"};
        String exp = this.getClassPrefix(stringArray) + "[" + LS + "  {" + LS + "    1," + LS + "    2" + LS + "  }" + LS + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(stringArray));
    }

    private String toString(Object object) {
        return new ReflectionToStringBuilder(object, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    static class WithArrays {
        boolean[] boolArray;
        byte[] byteArray;
        char[] charArray;
        double[] doubleArray;
        float[] floatArray;
        int[] intArray;
        long[] longArray;
        short[] shortArray;
        String[] stringArray;

        WithArrays() {
        }
    }

    private static enum WithArraysTestType {
        NONE,
        BOOLEAN,
        BYTE,
        CHAR,
        DOUBLE,
        FLOAT,
        INT,
        LONG,
        SHORT,
        STRING;

    }

    static class Account {
        Customer owner;
        List<Transaction> transactions = new ArrayList<Transaction>();

        Account() {
        }

        public double getBalance() {
            double balance = 0.0;
            for (Transaction tx : this.transactions) {
                balance += tx.amount;
            }
            return balance;
        }
    }

    static class Transaction {
        double amount;
        String date;

        Transaction(String datum, double betrag) {
            this.date = datum;
            this.amount = betrag;
        }
    }

    static class Customer {
        String name;
        Bank bank;
        List<Account> accounts;

        Customer(String name) {
            this.name = name;
        }
    }

    static class Bank {
        String name;

        Bank(String name) {
            this.name = name;
        }
    }
}

