/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;

public class CombiningTagger
implements WordTagger {
    private final WordTagger tagger1;
    private final WordTagger tagger2;
    private final WordTagger removalTagger;
    private final boolean overwriteWithSecondTagger;

    public CombiningTagger(WordTagger tagger1, WordTagger tagger2, boolean overwriteWithSecondTagger) {
        this(tagger1, tagger2, null, overwriteWithSecondTagger);
    }

    public CombiningTagger(WordTagger tagger1, WordTagger tagger2, WordTagger removalTagger, boolean overwriteWithSecondTagger) {
        this.tagger1 = tagger1;
        this.tagger2 = tagger2;
        this.removalTagger = removalTagger;
        this.overwriteWithSecondTagger = overwriteWithSecondTagger;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        ArrayList<TaggedWord> result2 = new ArrayList<TaggedWord>();
        result2.addAll(this.tagger2.tag(word));
        if (!this.overwriteWithSecondTagger || result2.size() <= 0) {
            result2.addAll(this.tagger1.tag(word));
        }
        if (this.removalTagger != null) {
            List<TaggedWord> removalTags = this.removalTagger.tag(word);
            result2.removeAll(removalTags);
        }
        return result2;
    }

    @Nullable
    public WordTagger getRemovalTagger() {
        return this.removalTagger;
    }
}

