/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceChangeCache {
    private final PerforceRunner myRunner;
    private final PerforceManager myPerforceManager;
    private final Map<Pair<Long, ConnectionKey>, List<PerforceChange>> myCache = new ConcurrentHashMap<Pair<Long, ConnectionKey>, List<PerforceChange>>();

    public PerforceChangeCache(Project project) {
        this.myRunner = PerforceRunner.getInstance(project);
        this.myPerforceManager = PerforceManager.getInstance(project);
    }

    public @Unmodifiable List<PerforceChange> getChanges(P4Connection connection, long changeListNumber, @Nullable VirtualFile vcsRoot) {
        List<PerforceChange> all = this.myCache.get(PerforceChangeCache.createKey(connection, changeListNumber));
        if (all == null) {
            try {
                all = this.myRunner.getChanges(connection, changeListNumber);
            }
            catch (VcsException e) {
                all = Collections.emptyList();
            }
            this.setChanges(connection, changeListNumber, all);
        }
        if (vcsRoot == null) {
            return all;
        }
        String rootPath = FileUtil.toSystemDependentName((String)this.myPerforceManager.convertP4ParsedPath(null, vcsRoot.getPath()));
        return ContainerUtil.findAll(all, change -> {
            File file = change.getFile();
            return file != null && FileUtil.startsWith((String)file.getAbsolutePath(), (String)rootPath);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void setChanges(P4Connection connection, long changeListNumber, @NotNull List<PerforceChange> list) {
        void changes;
        if (list == null) {
            PerforceChangeCache.$$$reportNull$$$0(0);
        }
        this.myCache.put(PerforceChangeCache.createKey(connection, changeListNumber), (List<PerforceChange>)changes);
    }

    private static Pair<Long, ConnectionKey> createKey(P4Connection connection, long changeListNumber) {
        return new Pair((Object)changeListNumber, (Object)connection.getConnectionKey());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/perforce/perforce/PerforceChangeCache", "setChanges"));
    }
}

