/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Time;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.idea.perforce.util.tracer.LongCallsStatistics;
import org.jetbrains.idea.perforce.util.tracer.StatisticsPresentation;
import org.jetbrains.idea.perforce.util.tracer.Timed;

class LongCallsPresentation<Kind extends Enum>
implements StatisticsPresentation<LongCallsStatistics<Kind>> {
    LongCallsPresentation() {
    }

    @Override
    public void putSelf(StringBuilder sb, LongCallsStatistics<Kind> statistics) {
        LongCallsStatistics.AverageData averageData = (LongCallsStatistics.AverageData)statistics.getAverage();
        SortedMap averageMap = averageData.getMap();
        sb.append("Long calls\n").append("Average:\n");
        this.putMap(sb, averageMap);
        sb.append("Recent calls:\n");
        List list = statistics.receiveRecentComplete();
        for (Timed timed : list) {
            sb.append("Statistics at ").append(new Time(timed.getTime()));
            this.putMap(sb, ((LongCallsStatistics.IntervalData)timed.getT()).getMap());
        }
    }

    private void putMap(StringBuilder sb, SortedMap<Long, LongCallsStatistics.Data<Kind>> map) {
        for (Map.Entry<Long, LongCallsStatistics.Data<Kind>> entry : map.entrySet()) {
            LongCallsStatistics.Data<Kind> data = entry.getValue();
            sb.append("execution time ").append(entry.getKey()).append(" ms\nfor: '").append(data.getPresentation()).append("'\nat: ");
            Throwable throwable = data.getStackTraceHolder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(baos);
            throwable.printStackTrace(stream);
            sb.append(baos).append('\n');
        }
    }
}

