/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUniqueNameGenerator;", "", "prefix", "", "getNameOrNull", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "regexVariableName", "Lkotlin/text/Regex;", "findNonExistentNumber", "", "names", "", "makeUniqueName", "existingNames", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputUniqueNameGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputUniqueNameGenerator.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUniqueNameGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,39:1\n1611#2,9:40\n1863#2:49\n1864#2:51\n1620#2:52\n1#3:50\n621#4,6:53\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputUniqueNameGenerator.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUniqueNameGenerator\n*L\n35#1:40,9\n35#1:49\n35#1:51\n35#1:52\n35#1:50\n17#1:53,6\n*E\n"})
public final class JupyterDataInputUniqueNameGenerator {
    @NotNull
    private final String prefix;
    @NotNull
    private final Function1<JupyterCell, String> getNameOrNull;
    @NotNull
    private final Regex regexVariableName;

    public JupyterDataInputUniqueNameGenerator(@NotNull String prefix, @NotNull Function1<? super JupyterCell, String> getNameOrNull) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(getNameOrNull, (String)"getNameOrNull");
        this.prefix = prefix;
        this.getNameOrNull = getNameOrNull;
        this.regexVariableName = new Regex(this.prefix + "[0-9]+");
    }

    private final int findNonExistentNumber(Iterable<String> names) {
        int i = 1;
        HashSet numbers = SequencesKt.toHashSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(names), arg_0 -> JupyterDataInputUniqueNameGenerator.findNonExistentNumber$lambda$0(this, arg_0)), JupyterDataInputUniqueNameGenerator::findNonExistentNumber$lambda$2));
        int n = numbers.size();
        if (i <= n) {
            while (true) {
                if (!numbers.contains(i)) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return numbers.size() + 1;
    }

    @NotNull
    public final String makeUniqueName(@NotNull Iterable<String> existingNames) {
        Intrinsics.checkNotNullParameter(existingNames, (String)"existingNames");
        int number = this.findNonExistentNumber(existingNames);
        return this.prefix + number;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeUniqueName(@NotNull JupyterNotebook notebook) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Iterable $this$mapNotNull$iv = notebook.computeCells();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl2 = false;
            if ((String)this.getNameOrNull.invoke((Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List names = (List)destination$iv$iv;
        return this.makeUniqueName(names);
    }

    private static final boolean findNonExistentNumber$lambda$0(JupyterDataInputUniqueNameGenerator this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.regexVariableName.matches((CharSequence)it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Integer findNonExistentNumber$lambda$2(String it) {
        String string;
        block1: {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String $this$takeLastWhile$iv = it;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it2 = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it2)) continue;
                String string2 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return StringsKt.toIntOrNull((String)string);
    }
}

