/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.dialects.cassandra.generator.producers.CassElementOption;
import com.intellij.database.dialects.cassandra.generator.producers.CassKeyProducersKt;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010\u001a\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0018\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0019H\u0002J \u0010,\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010(\u001a\u00020)H\u0014\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeCassMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "describeCassTable", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "describeLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "describeCassSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "describeCassRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "describeCassAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "describeCassFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "describeCassTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "describeCassKey", "key", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "describeCassKeyImpl", "describeCassIndex", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "describeIndexingItems", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeIndex", "Lcom/intellij/database/model/DasIndex;", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassDescriptionService.kt\ncom/intellij/database/dialects/cassandra/model/CassDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class CassDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof CassKey ? this.describeCassKey((CassKey)e, context) : (basicElement instanceof CassTableColumn ? this.describeCassTableColumn((CassTableColumn)e, context) : (basicElement instanceof CassIndex ? this.describeCassIndex((CassIndex)e, context) : (basicElement instanceof CassFunction ? this.describeCassFunction((CassFunction)e, context) : (basicElement instanceof CassAggregate ? this.describeCassAggregate((CassAggregate)e, context) : (basicElement instanceof CassRole ? this.describeCassRole((CassRole)e, context) : (basicElement instanceof CassSchema ? this.describeCassSchema((CassSchema)e, context) : (basicElement instanceof CassTable ? this.describeCassTable((CassTable)e, context) : (basicElement instanceof CassMatView ? this.describeCassMatView((CassMatView)e, context) : super.content(e, context)))))))));
    }

    private final String describeCassMatView(CassMatView e, DescriptionService.Context context) {
        String desc = super.describeView(e, context);
        String likeTableDesc = this.describeLikeTable(e, context);
        if (((CharSequence)desc).length() > 0 && ((CharSequence)likeTableDesc).length() > 0) {
            return desc + " " + likeTableDesc;
        }
        return desc + likeTableDesc;
    }

    private final String describeCassTable(CassTable e, DescriptionService.Context context) {
        String desc = super.describeTable(e, context);
        String likeTableDesc = this.describeLikeTable(e, context);
        if (((CharSequence)desc).length() > 0 && ((CharSequence)likeTableDesc).length() > 0) {
            return desc + " " + likeTableDesc;
        }
        return desc + likeTableDesc;
    }

    private final String describeLikeTable(CassLikeTable e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassLikeTable.COMMENT);
        ((Collection)context.getDescribed()).add(CassLikeTable.PROPERTIES);
        Object desc = "";
        for (CassElementOption option : CassTableProducersKt.getTableOptions()) {
            Object version;
            if (Intrinsics.areEqual((Object)option.getName(), (Object)"comment")) continue;
            String realValue = (String)option.getValueGetter().invoke((Object)e);
            BasicIntrospectableArea basicIntrospectableArea = (BasicIntrospectableArea)e.getParent();
            BasicIntrospectableArea basicIntrospectableArea2 = basicIntrospectableArea != null ? basicIntrospectableArea.getParent() : null;
            Object object = basicIntrospectableArea2 instanceof BasicRoot ? (BasicRoot)basicIntrospectableArea2 : null;
            if (object == null || (object = object.getServerVersion()) == null) {
                object = version = Version.ZERO;
            }
            if (realValue == null) continue;
            Function1<Version, String> function1 = option.getDefaultValue();
            Intrinsics.checkNotNull((Object)version);
            if (Intrinsics.areEqual((Object)realValue, (Object)function1.invoke(version))) continue;
            desc = (String)desc + " " + option.getName() + " = " + CassElementOption.getLiteral$default(option, e, (Version)version, false, 4, null);
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)desc))).toString();
    }

    private final String describeCassSchema(CassSchema e, DescriptionService.Context context) {
        Object desc;
        block1: {
            String it;
            ((Collection)context.getDescribed()).add(CassSchema.PROPERTIES);
            desc = null;
            desc = super.describeBasicElement(e);
            String string = e.getProperties().get((Object)CassSchemaPropertyKind.DURABLE_WRITES);
            if (string != null) {
                it = string;
                boolean bl = false;
                desc = desc + " durable_writes: " + it;
            }
            String string2 = e.getProperties().get((Object)CassSchemaPropertyKind.REPLICATION);
            if (string2 == null) break block1;
            it = string2;
            boolean bl = false;
            desc = desc + " replication: " + it;
        }
        return desc;
    }

    private final String describeCassRole(CassRole e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassRole.SUPER_ROLE);
        ((Collection)context.getDescribed()).add(CassRole.CAN_LOGIN);
        Object desc = "";
        if (e.isSuperRole()) {
            desc = (String)desc + " superuser";
        }
        if (e.isCanLogin()) {
            desc = (String)desc + " login";
        }
        return desc;
    }

    private final String describeCassAggregate(CassAggregate e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassAggregate.STATE_STORED_TYPE);
        ((Collection)context.getDescribed()).add(CassAggregate.STATE_FUNC);
        ((Collection)context.getDescribed()).add(CassAggregate.FINAL_FUNC);
        ((Collection)context.getDescribed()).add(CassAggregate.INIT_COND);
        String description = super.describeRoutine(e, context) + " state_type: " + e.getStateType().toDataType();
        if (e.getStateFunc() != null) {
            description = description + " state_func: " + e.getStateFunc();
        }
        if (e.getFinalFunc() != null) {
            description = description + " final_func: " + e.getFinalFunc();
        }
        if (e.getInitCond() != null) {
            description = description + " init_cond: " + e.getInitCond();
        }
        return description;
    }

    private final String describeCassFunction(CassFunction e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassFunction.LANGUAGE);
        ((Collection)context.getDescribed()).add(CassFunction.CALLED_ON_NULL_INPUT);
        Object description = super.describeRoutine(e, context);
        if (e.getLanguage() != null) {
            description = (String)description + " language: " + e.getLanguage();
        }
        return (String)description + " called_on_null_input: " + e.isCalledOnNullInput();
    }

    private final String describeCassTableColumn(CassTableColumn e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassTableColumn.STATIC_COLUMN);
        String description = this.describeTableOrViewColumn(e, context);
        if (e.isStaticColumn()) {
            return description + " static";
        }
        return description;
    }

    private final String describeCassKey(CassKey key2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassKey.COLUMNS);
        return this.describeCassKeyImpl(key2);
    }

    @NlsSafe
    private final String describeCassKeyImpl(CassKey key2) {
        String res2 = "(" + CassKeyProducersKt.describeKey(key2, (Function1<? super String, String>)((Function1)CassDescriptionService::describeCassKeyImpl$lambda$2)) + ")";
        if (CassKeyProducersKt.isDefaultClusteringOrder(key2)) {
            return res2;
        }
        return res2 + " clustering order by (" + CassKeyProducersKt.getClusteringOrderBy(key2, (Function1<? super String, String>)((Function1)CassDescriptionService::describeCassKeyImpl$lambda$3)) + ")";
    }

    private final String describeCassIndex(CassIndex index, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassIndex.COLUMNS);
        ((Collection)context.getDescribed()).add(CassIndex.CUSTOM);
        String inner = this.describeIndexingItems(index);
        return (index.isCustom() ? "custom index" : "index") + " (" + inner + ")";
    }

    private final String describeIndexingItems(CassIndex index) {
        String string;
        if (index.getColumns().isEmpty()) {
            string = "???";
        } else {
            List<IndexColumn> list = index.getColumns();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColumns(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        }
        return string;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof CassKey) {
            this.describeCassKey(presentation, (CassKey)o);
        } else if (dasObject instanceof CassTableColumn) {
            this.describeCassTableColumn(presentation, (CassTableColumn)o);
        } else {
            super.updatePresentation(project, o, viewOptions, presentation);
        }
    }

    private final void describeCassKey(PresentationData presentation, CassKey key2) {
        presentation.addText(" " + this.describeCassKeyImpl(key2), DbPresentationCore.INFO_ATTRS);
    }

    private final void describeCassTableColumn(PresentationData presentation, CassTableColumn o) {
        super.describeColumn(presentation, o);
        if (o.isStaticColumn()) {
            String string = " static";
            presentation.addText(string, DbPresentationCore.INFO_ATTRS);
        }
    }

    @Override
    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex index, @NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        if (!(index instanceof CassIndex)) {
            return;
        }
        List<IndexColumn> list = ((CassIndex)index).getColumns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getColumns(...)");
        String columns = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        presentation.addText(" (" + columns + ")", DbPresentationCore.INFO_ATTRS);
    }

    private static final String describeCassKeyImpl$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String describeCassKeyImpl$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

