/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.CallParams;
import com.intellij.database.dialects.oracle.debugger.DebuggerUnableException;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a+\u0010\u0011\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\u001a?\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001d\u001a?\u0010\u001e\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001d\u001a_\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"0 \"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001c2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010%\u001aO\u0010\u001e\u001a\u0002H&\"\b\b\u0000\u0010'*\u00020(\"\u0004\b\u0001\u0010&*\u00020\u00062\u0006\u0010)\u001a\u0002H'2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u00162\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002H&0+\u00a2\u0006\u0002\u0010-\u001a+\u0010.\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\u001a\u0010\u0010/\u001a\b\u0012\u0004\u0012\u00020100*\u00020\u0006\u001a\u001b\u00102\u001a\u0002032\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u00104\u001a)\u00102\u001a\u0002032\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u00108\u001a\n\u0010>\u001a\u00020?*\u00020?\u001a\u0016\u0010@\u001a\u00020\u000e*\u00020?2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u000e\u001a\u001c\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020D2\n\u0010E\u001a\u00060Fj\u0002`GH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"'\u00109\u001a\b\u0012\u0004\u0012\u0002070:*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006H"}, d2={"ourOracleDebuggerLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getOurOracleDebuggerLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "obtainGuardedConnection", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "checkForProblems", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "callProcedure", "", "procedure", "parameters", "", "", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;[Ljava/lang/Object;)V", "callFunction", "V", "function", "resultParam", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "call", "statementText", "Lkotlin/Pair;", "V1", "V2", "outParam1", "outParam2", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Lkotlin/Pair;", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "handler", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "perform", "executor", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "decorateInParameters", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "([Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "skip", "", "", "(Ljava/util/Set;[Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "indices", "Ljava/util/SortedSet;", "", "getIndices", "(Ljava/util/List;)Ljava/util/SortedSet;", "unwrapException", "", "prepareGoodMessage", "prefix", "handleException", "statement", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraConnectionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraConnectionHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OraConnectionHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1628#2,3:264\n*S KotlinDebug\n*F\n+ 1 OraConnectionHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OraConnectionHelperKt\n*L\n221#1:264,3\n*E\n"})
public final class OraConnectionHelperKt {
    @NotNull
    private static final Logger ourOracleDebuggerLogger;

    @NotNull
    public static final Logger getOurOracleDebuggerLogger() {
        return ourOracleDebuggerLogger;
    }

    @NotNull
    public static final GuardedRef<DatabaseConnection> obtainGuardedConnection(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        LocalDataSource localDataSource = connectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        String problem = OraConnectionHelperKt.checkForProblems(localDataSource);
        if (problem != null) {
            throw new DebuggerUnableException(problem);
        }
        return DatabaseSessionManager.getFacade(project, connectionPoint, null, null, false, null, department).connect();
    }

    @Nullable
    public static final String checkForProblems(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (dataSource.isSingleConnection()) {
            return "Debugging in the single connection mode is not possible";
        }
        Version version = dataSource.getExactDriverVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getExactDriverVersion(...)");
        Version driverVersion = version;
        int driverMajor = driverVersion.get(0);
        int driverMinor = driverVersion.get(1);
        Version version2 = dataSource.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"getVersion(...)");
        Version serverVersion = version2;
        int serverMajor = serverVersion.get(0);
        int serverMinor = serverVersion.get(1);
        if (driverMajor < 12 || serverMajor < 10) {
            if (driverMajor != serverMajor) {
                return "Driver version must be the same as the server version.\n\tServer version: " + serverVersion + "\n\tDriver version: " + driverVersion + "\n";
            }
            if (driverMinor < serverMinor) {
                return "Driver is not up to date.\n\tServer version: " + serverVersion + "\n\tDriver version: " + driverVersion + "\n";
            }
        }
        return null;
    }

    public static final void callProcedure(@NotNull DatabaseConnection $this$callProcedure, @NotNull String procedure, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$callProcedure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)procedure, (String)"procedure");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String statementText = "{ call " + procedure + " }";
        OraConnectionHelperKt.perform($this$callProcedure, statementText, Arrays.copyOf(parameters, parameters.length));
    }

    public static final <V> V callFunction(@NotNull DatabaseConnection $this$callFunction, @NotNull String function, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$callFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String statementText = "{ ? = call " + function + " }";
        return OraConnectionHelperKt.call($this$callFunction, statementText, resultParam, Arrays.copyOf(parameters, parameters.length));
    }

    public static final <V> V call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), CollectionsKt.listOf(resultParam));
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(SetsKt.setOf((Object)resultParam.getIndex()), parameters);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return (V)executor.execute(csd, arg_0 -> OraConnectionHelperKt.call$lambda$0(resultParam, arg_0));
        }
        catch (Exception e) {
            OraConnectionHelperKt.handleException(statementText, e);
            throw e;
        }
    }

    @NotNull
    public static final <V1, V2> Pair<V1, V2> call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V1> outParam1, @NotNull IndexedOutParameter<V2> outParam2, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(outParam1, (String)"outParam1");
        Intrinsics.checkNotNullParameter(outParam2, (String)"outParam2");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        try {
            Object[] objectArray = new IndexedOutParameter[]{outParam1, outParam2};
            List outParameters = CollectionsKt.listOf((Object[])objectArray);
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), outParameters);
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(outParameters), parameters);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return (Pair)executor.execute(csd, arg_0 -> OraConnectionHelperKt.call$lambda$1(outParam1, outParam2, arg_0));
        }
        catch (Exception e) {
            OraConnectionHelperKt.handleException(statementText, e);
            throw e;
        }
    }

    public static final <D extends CallDefinition, R> R call(@NotNull DatabaseConnection $this$call, @NotNull D definition, @NotNull Object[] parameters, @NotNull Function1<? super ResultsProducer, ? extends R> handler2) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(definition.getText(), new BitSet(0), ((CallParams)definition).getOutParams());
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(((CallParams)definition).getOutParams()), parameters);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return executor.execute(csd, handler2);
        }
        catch (Exception e) {
            OraConnectionHelperKt.handleException(definition.getText(), e);
            throw e;
        }
    }

    public static final void perform(@NotNull DatabaseConnection $this$perform, @NotNull String statementText, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), CollectionsKt.emptyList());
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(parameters);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$perform);
            NoisyStatement.execute$default(executor, csd, null, 2, null);
        }
        catch (Exception e) {
            OraConnectionHelperKt.handleException(statementText, e);
            throw e;
        }
    }

    @NotNull
    public static final NoisyStatement<CallableStatementData> executor(@NotNull DatabaseConnection $this$executor) {
        Intrinsics.checkNotNullParameter((Object)$this$executor, (String)"<this>");
        return SmartStatements.Companion.poweredBy($this$executor).call(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).noisy();
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Object[] parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return OraConnectionHelperKt.decorateInParameters(SetsKt.emptySet(), parameters);
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Set<Integer> skip, @NotNull Object[] parameters) {
        Intrinsics.checkNotNullParameter(skip, (String)"skip");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        StatementParameters x = new StatementParameters();
        int k = 0;
        for (Object p2 : parameters) {
            ++k;
            while (skip.contains(k)) {
                ++k;
            }
            Object object = p2;
            StatementParameters statementParameters = object instanceof Boolean ? x.integer(k, (Boolean)p2 != false ? 1 : 0) : (object instanceof Byte ? x.byteValue(k, (Byte)p2) : (object instanceof Short ? x.shortValue(k, (Short)p2) : (object instanceof Integer ? x.integer(k, (Integer)p2) : (object instanceof String ? x.text(k, (String)p2) : x.obj(k, p2)))));
        }
        return x.asDecoration();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SortedSet<Integer> getIndices(@NotNull List<? extends IndexedOutParameter<?>> $this$indices) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$indices, (String)"<this>");
        Iterable iterable = $this$indices;
        Collection destination$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            IndexedOutParameter indexedOutParameter = (IndexedOutParameter)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(p0.getIndex());
        }
        return (SortedSet)var2_2;
    }

    @NotNull
    public static final Throwable unwrapException(@NotNull Throwable $this$unwrapException) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapException, (String)"<this>");
        Throwable e = $this$unwrapException;
        while (e instanceof RuntimeException && e.getCause() != null) {
            Intrinsics.checkNotNull((Object)e.getCause());
        }
        return e;
    }

    @NotNull
    public static final String prepareGoodMessage(@NotNull Throwable $this$prepareGoodMessage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareGoodMessage, (String)"<this>");
        StringBuilder b = new StringBuilder(256);
        if (prefix != null) {
            b.append(prefix).append(':').append(' ');
        }
        StringBuilder stringBuilder = $this$prepareGoodMessage instanceof SQLException ? b.append("Error ").append(((SQLException)$this$prepareGoodMessage).getErrorCode()).append(" SQL state ").append(((SQLException)$this$prepareGoodMessage).getSQLState()) : b.append("Exception ").append($this$prepareGoodMessage.getClass().getSimpleName());
        boolean wasMessage = false;
        for (Throwable e = $this$prepareGoodMessage; e != null; e = e.getCause()) {
            String m = e.getMessage();
            if (m == null || StringsKt.contains$default((CharSequence)b, (CharSequence)m, (boolean)false, (int)2, null)) continue;
            b.append(':').append(' ').append(m);
            wasMessage = true;
        }
        if (!wasMessage) {
            b.append(" (no message)");
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String prepareGoodMessage$default(Throwable throwable, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return OraConnectionHelperKt.prepareGoodMessage(throwable, string);
    }

    private static final void handleException(CharSequence statement2, Exception e) {
        if (ourOracleDebuggerLogger.isDebugEnabled()) {
            String exceptionDescription = e instanceof SQLException ? "SQL error " + ((SQLException)e).getErrorCode() + " [" + ((SQLException)e).getSQLState() + "]: " + e.getMessage() : e.getClass().getSimpleName() + ": " + e.getMessage();
            String message = "Error occurred during Oracle debugger session:\n" + exceptionDescription + "\nStatement:\n" + statement2;
            ourOracleDebuggerLogger.debug(message);
        }
    }

    private static final Object call$lambda$0(IndexedOutParameter $resultParam, ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParameterValue($resultParam);
    }

    private static final Pair call$lambda$1(IndexedOutParameter $outParam1, IndexedOutParameter $outParam2, ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object value1 = it.getParameterValue($outParam1);
        Object value2 = it.getParameterValue($outParam2);
        return new Pair(value1, value2);
    }

    static {
        Logger logger2 = Logger.getInstance((String)"com.intellij.database.oracle.Debugger");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        ourOracleDebuggerLogger = logger2;
    }
}

