/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector.jdbc;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.dialects.postgresbase.introspector.jdbc.PgDialectHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import java.lang.invoke.CallSite;
import org.jetbrains.annotations.NotNull;

public class PgBaseJdbcSourceLoader
extends JdbcSourceLoader {
    public PgBaseJdbcSourceLoader(@NotNull Dbms dbms) {
        if (dbms == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    protected boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (object == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(2);
        }
        if (!this.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        if (dbms.isPostgres() && object instanceof PgBaseRoutine) {
            PgBaseRoutine routine2 = (PgBaseRoutine)object;
            Version curVersion = connection2.getVersion();
            boolean hasUseful = curVersion.isOrGreater(8, 4);
            boolean isPre81 = !curVersion.isOrGreater(8, 1);
            int limit = Math.max(10, routine2.getArguments().size()) + 5;
            Boolean res2 = (Boolean)DbImplUtilCore.executeAndGetResult(connection2, "select " + (String)(hasUseful ? "       pg_catalog.pg_get_function_arguments(pg_proc.oid) as arguments_def,\n       pg_catalog.pg_get_function_result(pg_proc.oid) as result_def,\n" : "       " + PgDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ", " + PgDialectHelper.select(limit, isPre81) + "       pronargs,\n       proretset,\n") + "       prosrc,\n       lanname\nfrom pg_proc join pg_namespace nsp on nsp.oid = pronamespace left join pg_language l on l.oid = prolang\n" + (String)(hasUseful ? "" : PgDialectHelper.joinType("tr", "prorettype", isPre81) + " " + PgDialectHelper.join(limit, isPre81) + "\n") + "where proname = " + PgBaseJdbcSourceLoader.str(object.getName()) + " and nsp.nspname = " + PgBaseJdbcSourceLoader.str(DasUtil.getSchema(object)) + "\n", rs -> {
                if (!rs.next()) {
                    return false;
                }
                if (hasUseful) {
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)rs.getString("arguments_def")));
                    routine2.setResultsDefinition(StringUtil.nullize((String)rs.getString("result_def")));
                } else {
                    PgDialectHelper.SignatureBuilder sigBuilder = new PgDialectHelper.SignatureBuilder(isPre81, (RemoteResultSet)rs);
                    DdlBuilder builder = new DdlBuilder().withDialect(DbImplUtilCore.getDatabaseDialect(Dbms.POSTGRES));
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)sigBuilder.buildArguments(builder).getStatement()));
                    builder.clear();
                    routine2.setResultsDefinition(StringUtil.nullize((String)sigBuilder.buildReturn(builder).getStatement()));
                }
                String name2 = StringUtil.nullize((String)rs.getString("lanname"));
                routine2.setLanguageRef(name2 == null ? null : BasicNameReference.create(name2));
                if (dbms.isRedshift()) {
                    routine2.setVolatilityKind(PgVolatilityKind.VOLATILE);
                }
                routine2.setSourceText(new SimpleCompositeText((CharSequence)rs.getString("prosrc"), CompositeText.Kind.ORIGINAL_TEXT));
                return true;
            });
            return res2 == Boolean.TRUE;
        }
        return super.loadRoutine(object, connection2);
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(3);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema(element) + "' and table_name = '" + element.getName() + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    @Override
    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(4);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema(element) + "' and routine_name = '" + element.getName() + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnectionCore connection2) throws Exception {
        DdlBuilder builder;
        Version curVersion;
        block6: {
            String string;
            if (proc == null) {
                PgBaseJdbcSourceLoader.$$$reportNull$$$0(6);
            }
            if (connection2 == null) {
                PgBaseJdbcSourceLoader.$$$reportNull$$$0(7);
            }
            Dbms dbms = connection2.getDbms();
            DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
            curVersion = connection2.getVersion();
            builder = new DdlBuilder().withDialect(dialect).qualifyReferences(true);
            try {
                if (!curVersion.isOrGreater(8, 4)) break block6;
                string = DbImplUtilCore.concatStringResults(connection2, dbms, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PgBaseJdbcSourceLoader.str(proc.getName()) + " AND nspname = " + PgBaseJdbcSourceLoader.str(DasUtil.getSchema(proc)), 0, DbImplUtilCore.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                PgBaseJdbcSourceLoader.$$$reportNull$$$0(8);
            }
            return string;
        }
        boolean isPre81 = Version.of(8, 0).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size(proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PgDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PgDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PgDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PgDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PgBaseJdbcSourceLoader.str(proc.getName()) + " AND nsp.nspname = " + PgBaseJdbcSourceLoader.str(DasUtil.getSchema(proc)) + "\n";
        SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute((CallSite)((Object)s), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
            while (rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef(proc).symbol("(");
                PgDialectHelper.SignatureBuilder signatureBuilder = new PgDialectHelper.SignatureBuilder(isPre81, (RemoteResultSet)rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        })));
        String string = builder.getStatement();
        if (string == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseJdbcSourceLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseJdbcSourceLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRoutine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9 -> new IllegalStateException(string);
        };
    }
}

