/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbModelModifiedCache {
    private final Object2ObjectMap<DbEditorModel<?, ?>, State> myCache;
    private final DbEditorModelController myController;

    DbModelModifiedCache(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelModifiedCache.$$$reportNull$$$0(0);
        }
        this.myCache = new Object2ObjectOpenHashMap();
        this.myController = controller;
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbModelModifiedCache.this.prune(model);
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbModelModifiedCache.this.prune(model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelModifiedCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public Map<DbEditorModel<?, ?>, State> snapshot() {
        return new HashMap((Map<DbEditorModel<?, ?>, State>)this.myCache);
    }

    @Nullable
    public State getState(@NotNull DbEditorModel<?, ?> model) {
        State res2;
        if (model == null) {
            DbModelModifiedCache.$$$reportNull$$$0(1);
        }
        if ((res2 = (State)((Object)this.myCache.get(model))) != null) {
            return res2;
        }
        res2 = this.computeState(model);
        this.myCache.put(model, (Object)res2);
        return res2;
    }

    public boolean isModified(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbModelModifiedCache.$$$reportNull$$$0(2);
        }
        return this.getState(model) == State.MODIFIED;
    }

    public void prune(@NotNull DbEditorModel<?, ?> model) {
        DbEditorModel<?, DbObjectModelState<?>> om;
        if (model == null) {
            DbModelModifiedCache.$$$reportNull$$$0(3);
        }
        this.myCache.remove(model);
        BasicMetaId key2 = model.getModelInternalKey();
        if (key2 == DbObjectModelApplier.ID) {
            DbEditorModel<?, DbStructureObjectModelState<?>> sm = this.myController.getStructureNodeModel(model.getIdentity());
            if (sm != null) {
                this.prune(sm);
            }
        } else if (key2 != DbStructureObjectModelApplier.ID && (om = this.myController.getObjectModel(model.getIdentity())) != null) {
            this.prune(om);
        }
    }

    private <E extends BasicElement, S extends DbModelState> State computeState(@NotNull DbEditorModel<E, S> model) {
        Object orig;
        BasicMetaId key2;
        if (model == null) {
            DbModelModifiedCache.$$$reportNull$$$0(4);
        }
        if ((key2 = model.getModelInternalKey()) == DbObjectModelApplier.ID) {
            return this.computeObjectModelState(model);
        }
        if (key2 == DbStructureObjectModelApplier.ID) {
            return this.computeStructureModelState(model);
        }
        ElementIdentity<E> identity = model.getIdentity();
        if (identity instanceof MultiElementIdentity) {
            return State.NOT_MODIFIED;
        }
        DbObjectModelState<E> os = this.myController.getObjectModelState(model.getIdentity());
        if (os == null) {
            return State.NOT_MODIFIED;
        }
        ElementOwner oOwner = this.myController.getMatcher().getOriginalOwner();
        Object v0 = orig = oOwner != null ? oOwner.find(model.getIdentity()) : null;
        if (os.isDropped()) {
            return orig == null ? State.NOT_MODIFIED : State.DROPPED;
        }
        if (orig == null) {
            return State.NEW;
        }
        return model.getApplier().differsFrom(model, oOwner) ? State.MODIFIED : State.NOT_MODIFIED;
    }

    private State computeObjectModelState(@NotNull DbEditorModel<?, ?> objectModel) {
        if (objectModel == null) {
            DbModelModifiedCache.$$$reportNull$$$0(5);
        }
        ElementIdentity<?> identity = objectModel.getIdentity();
        boolean modified = false;
        boolean isNew = false;
        for (DbEditorModel<?, ?> model : this.myController.getAllModels()) {
            BasicMetaId key2;
            if (model.getIdentity() != identity || DbModelModifiedCache.isSkippedModel(key2 = model.getModelInternalKey())) continue;
            State state = this.getState(model);
            modified |= state == State.MODIFIED;
            isNew |= state == State.NEW;
        }
        Object s = objectModel.getState();
        return isNew ? State.NEW : (modified ? State.MODIFIED : State.NOT_MODIFIED);
    }

    private static boolean isSkippedModel(BasicMetaId key2) {
        return key2 == DbObjectModelApplier.ID || key2 == DbStructureObjectModelApplier.ID || key2 == BasicModArrangedElement.POSITION;
    }

    private State computeStructureModelState(@NotNull DbEditorModel<?, ?> model) {
        DbStructureObjectModelState ss;
        if (model == null) {
            DbModelModifiedCache.$$$reportNull$$$0(6);
        }
        return (ss = (DbStructureObjectModelState)ObjectUtils.tryCast(model.getState(), DbStructureObjectModelState.class)) != null ? this.getState(ss.getObjectRef().resolve(model.getController())) : State.NOT_MODIFIED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelModifiedCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prune";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeObjectModelState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "computeStructureModelState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum State {
        MODIFIED,
        NOT_MODIFIED,
        NEW,
        DROPPED;

    }
}

