/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.statistic.DatabaseUsagesCollectors;
import com.intellij.database.statistic.DbFusIntrospectionLogger;
import com.intellij.database.util.AsyncUtil;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.AnonymizedEventField;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.CollectionFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000201B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0018\u0010&\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u000bJ(\u0010(\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\"\u0010-\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010/R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/statistic/DbFusModelLoadingCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "activities", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/components/ComponentManager;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/database/statistic/DbFusModelLoadingCollector$LoadingActivity;", "dataSourceActivities", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "DATA_SOURCE_ID", "Lcom/intellij/internal/statistic/eventLog/events/AnonymizedEventField;", "DBMS", "Lcom/intellij/database/statistic/DatabaseUsagesCollectors$DbmsEventField;", "LOADING_RESULT", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/database/statistic/DbFusModelLoadingCollector$LoadingResult;", "WAS_MIGRATED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "TOTAL_SCHEMAS", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "VISIBLE_SCHEMAS", "TOTAL_OBJECTS", "LOADING_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "LOADING_DATA_SOURCE_ACTIVITY", "loading", "project", "Lcom/intellij/openapi/project/Project;", "finishedLoading", "", "logStarted", "dataSource", "logFinished", "model", "Lcom/intellij/database/model/DasModel;", "importer", "Lcom/intellij/database/model/serialization/ModelImporter;", "logFailed", "th", "", "LoadingActivity", "LoadingResult", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbFusModelLoadingLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbFusModelLoadingLogger.kt\ncom/intellij/database/statistic/DbFusModelLoadingCollector\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,155:1\n72#2,2:156\n1#3:158\n1#3:159\n249#4,3:160\n*S KotlinDebug\n*F\n+ 1 DbFusModelLoadingLogger.kt\ncom/intellij/database/statistic/DbFusModelLoadingCollector\n*L\n87#1:156,2\n87#1:158\n55#1:160,3\n*E\n"})
public final class DbFusModelLoadingCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DbFusModelLoadingCollector INSTANCE;
    @NotNull
    private static final ConcurrentMap<ComponentManager, LoadingActivity> activities;
    @NotNull
    private static final ConcurrentMap<LocalDataSource, StructuredIdeActivity> dataSourceActivities;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final AnonymizedEventField DATA_SOURCE_ID;
    @NotNull
    private static final DatabaseUsagesCollectors.DbmsEventField DBMS;
    @NotNull
    private static final EnumEventField<LoadingResult> LOADING_RESULT;
    @NotNull
    private static final BooleanEventField WAS_MIGRATED;
    @NotNull
    private static final PrimitiveEventField<Integer> TOTAL_SCHEMAS;
    @NotNull
    private static final PrimitiveEventField<Integer> VISIBLE_SCHEMAS;
    @NotNull
    private static final PrimitiveEventField<Integer> TOTAL_OBJECTS;
    @NotNull
    private static final IdeActivityDefinition LOADING_ACTIVITY;
    @NotNull
    private static final IdeActivityDefinition LOADING_DATA_SOURCE_ACTIVITY;

    private DbFusModelLoadingCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StructuredIdeActivity loading(@Nullable Project project) {
        void $this$getOrPut$iv;
        ConcurrentMap<Object, LoadingActivity> concurrentMap = activities;
        Project project2 = project;
        ComponentManager key$iv = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            LoadingActivity default$iv = new LoadingActivity(project);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        concurrentMap = object;
        LoadingActivity $this$loading_u24lambda_u241 = (LoadingActivity)((Object)concurrentMap);
        boolean bl = false;
        $this$loading_u24lambda_u241.ref();
        return ((LoadingActivity)((Object)concurrentMap)).getActivity();
    }

    public final void finishedLoading(@Nullable Project project) {
        block1: {
            LoadingActivity loadingActivity;
            Project project2 = project;
            ComponentManager key2 = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
            LoadingActivity loadingActivity2 = (LoadingActivity)activities.get(key2);
            if (loadingActivity2 == null) break block1;
            LoadingActivity $this$finishedLoading_u24lambda_u242 = loadingActivity = loadingActivity2;
            boolean bl = false;
            if ($this$finishedLoading_u24lambda_u242.deref()) {
                activities.remove(key2);
            }
        }
    }

    public final void logStarted(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        ((Map)dataSourceActivities).put(dataSource, IdeActivityDefinition.startedWithParent$default((IdeActivityDefinition)LOADING_DATA_SOURCE_ACTIVITY, (Project)project, (StructuredIdeActivity)this.loading(project), null, (int)4, null));
    }

    public final void logFinished(@Nullable Project project, @NotNull LocalDataSource dataSource, @NotNull DasModel model, @NotNull ModelImporter importer) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)importer, (String)"importer");
        StructuredIdeActivity structuredIdeActivity = (StructuredIdeActivity)dataSourceActivities.remove(dataSource);
        if (structuredIdeActivity != null) {
            structuredIdeActivity.finished(() -> DbFusModelLoadingCollector.logFinished$lambda$3(dataSource, model, importer));
        }
        this.finishedLoading(project);
    }

    public final void logFailed(@Nullable Project project, @NotNull LocalDataSource dataSource, @Nullable Throwable th) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        StructuredIdeActivity structuredIdeActivity = (StructuredIdeActivity)dataSourceActivities.remove(dataSource);
        if (structuredIdeActivity != null) {
            structuredIdeActivity.finished(() -> DbFusModelLoadingCollector.logFailed$lambda$4(dataSource, th));
        }
        this.finishedLoading(project);
    }

    private static final List logFinished$lambda$3(LocalDataSource $dataSource, DasModel $model, ModelImporter $importer) {
        DbFusIntrospectionLogger.ObjectCounts objects = DbFusIntrospectionLogger.ObjectCounts.Companion.countObjects($dataSource, $model);
        Object[] objectArray = new EventPair[]{DATA_SOURCE_ID.with((Object)$dataSource.getUniqueId()), DBMS.with($dataSource.getDbms()), EventFields.Version.with((Object)$dataSource.getVersion().toString()), LOADING_RESULT.with((Object)LoadingResult.FAST.from($importer.triedLoadFast, $importer.loadedFast)), WAS_MIGRATED.with((Object)$importer.wasMigrated), TOTAL_SCHEMAS.with((Object)objects.getSchemas()), VISIBLE_SCHEMAS.with((Object)objects.getVisibleSchemas()), TOTAL_OBJECTS.with((Object)objects.getTotal())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List logFailed$lambda$4(LocalDataSource $dataSource, Throwable $th) {
        Object[] objectArray = new EventPair[]{DATA_SOURCE_ID.with((Object)$dataSource.getUniqueId()), DBMS.with($dataSource.getDbms()), EventFields.Version.with((Object)$dataSource.getVersion().toString()), LOADING_RESULT.with((Object)(AsyncUtil.isCancellation($th) ? LoadingResult.CANCELLED : LoadingResult.FAILED))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new DbFusModelLoadingCollector();
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        activities = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakMap(...)");
        dataSourceActivities = concurrentMap2;
        GROUP = new EventLogGroup("db.model.loading", 7, null, 4, null);
        DATA_SOURCE_ID = new AnonymizedEventField("data_source_id", null, 2, null);
        DBMS = new DatabaseUsagesCollectors.DbmsEventField("dbms");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "loading_result";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        LOADING_RESULT = new EnumEventField(name$iv, LoadingResult.class, null, transform$iv);
        WAS_MIGRATED = EventFields.Boolean((String)"was_migrated");
        TOTAL_SCHEMAS = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"total_schemas", null, (int)2, null);
        VISIBLE_SCHEMAS = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"visible_schemas", null, (int)2, null);
        TOTAL_OBJECTS = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"total_objects", null, (int)2, null);
        LOADING_ACTIVITY = GROUP.registerIdeActivity("loading", new EventField[0], new EventField[0], null, false);
        eventFieldArray = new EventField[]{DATA_SOURCE_ID, DBMS, EventFields.Version, LOADING_RESULT, TOTAL_SCHEMAS, VISIBLE_SCHEMAS, TOTAL_OBJECTS, WAS_MIGRATED};
        LOADING_DATA_SOURCE_ACTIVITY = GROUP.registerIdeActivity("loading_data_source", new EventField[0], eventFieldArray, LOADING_ACTIVITY, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/statistic/DbFusModelLoadingCollector$LoadingActivity;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getActivity", "()Lcom/intellij/internal/statistic/StructuredIdeActivity;", "refCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "ref", "", "deref", "", "intellij.database.impl"})
    private static final class LoadingActivity {
        @NotNull
        private final StructuredIdeActivity activity;
        @NotNull
        private final AtomicInteger refCount;

        public LoadingActivity(@Nullable Project project) {
            this.activity = IdeActivityDefinition.started$default((IdeActivityDefinition)LOADING_ACTIVITY, (Project)project, null, (int)2, null);
            this.refCount = new AtomicInteger(0);
        }

        @NotNull
        public final StructuredIdeActivity getActivity() {
            return this.activity;
        }

        public final void ref() {
            this.refCount.incrementAndGet();
        }

        public final boolean deref() {
            if (this.refCount.decrementAndGet() == 0) {
                StructuredIdeActivity.finished$default((StructuredIdeActivity)this.activity, null, (int)1, null);
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\r"}, d2={"Lcom/intellij/database/statistic/DbFusModelLoadingCollector$LoadingResult;", "", "<init>", "(Ljava/lang/String;I)V", "FAST", "FAST_FAILED_TO_SLOW", "SLOW", "CANCELLED", "FAILED", "from", "triedFast", "", "loadedFast", "intellij.database.impl"})
    private static final class LoadingResult
    extends Enum<LoadingResult> {
        public static final /* enum */ LoadingResult FAST = new LoadingResult();
        public static final /* enum */ LoadingResult FAST_FAILED_TO_SLOW = new LoadingResult();
        public static final /* enum */ LoadingResult SLOW = new LoadingResult();
        public static final /* enum */ LoadingResult CANCELLED = new LoadingResult();
        public static final /* enum */ LoadingResult FAILED = new LoadingResult();
        private static final /* synthetic */ LoadingResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final LoadingResult from(boolean triedFast, boolean loadedFast) {
            return loadedFast ? FAST : (triedFast ? FAST_FAILED_TO_SLOW : SLOW);
        }

        public static LoadingResult[] values() {
            return (LoadingResult[])$VALUES.clone();
        }

        public static LoadingResult valueOf(String value) {
            return Enum.valueOf(LoadingResult.class, value);
        }

        @NotNull
        public static EnumEntries<LoadingResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loadingResultArray = new LoadingResult[]{LoadingResult.FAST, LoadingResult.FAST_FAILED_TO_SLOW, LoadingResult.SLOW, LoadingResult.CANCELLED, LoadingResult.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

