/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.sweepline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.index.sweepline.SweepLineEvent;
import org.locationtech.jts.index.sweepline.SweepLineInterval;
import org.locationtech.jts.index.sweepline.SweepLineOverlapAction;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    public void add(SweepLineInterval sweepInt) {
        SweepLineEvent insertEvent = new SweepLineEvent(sweepInt.getMin(), null, sweepInt);
        this.events.add(insertEvent);
        this.events.add(new SweepLineEvent(sweepInt.getMax(), insertEvent, sweepInt));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i2);
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction action) {
        this.nOverlaps = 0;
        this.buildIndex();
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i2, ev.getDeleteEventIndex(), ev.getInterval(), action);
        }
    }

    private void processOverlaps(int start2, int end, SweepLineInterval s0, SweepLineOverlapAction action) {
        for (int i2 = start2; i2 < end; ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isInsert()) continue;
            SweepLineInterval s1 = ev.getInterval();
            action.overlap(s0, s1);
            ++this.nOverlaps;
        }
    }
}

