/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.util.text.TableFullException;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u001d\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J3\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0018J%\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u001c\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001dJ\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010 \u001a\u00020\u0007J\u0015\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u001d\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002J\b\u00100\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/openapi/util/text/SimilarityIndex;", "", "<init>", "()V", "hashedCnt", "", "idSize", "", "idHashBits", "idHash", "", "idGrowAt", "hashLargeObject", "", "input", "Ljava/io/InputStream;", "size", "isText", "", "hash", "raw", "", "_ptr", "end", "hash$intellij_javascript_debugger", "in", "_remaining", "text", "sort", "sort$intellij_javascript_debugger", "score", "dst", "maxScore", "common", "common$intellij_javascript_debugger", "key", "idx", "key$intellij_javascript_debugger", "count", "count$intellij_javascript_debugger", "findIndex", "findIndex$intellij_javascript_debugger", "packedIndex", "add", "_key", "cnt", "add$intellij_javascript_debugger", "slot", "grow", "Companion", "intellij.javascript.debugger"})
public final class SimilarityIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long hashedCnt;
    private int idSize;
    private int idHashBits = 8;
    @NotNull
    private long[] idHash = new long[1 << this.idHashBits];
    private int idGrowAt = SimilarityIndexKt.access$growAt(this.idHashBits);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void hashLargeObject(InputStream input, long size, boolean isText) {
        try {
            this.hash$intellij_javascript_debugger(input, size, isText);
        }
        finally {
            input.close();
        }
    }

    static /* synthetic */ void hashLargeObject$default(SimilarityIndex similarityIndex, InputStream inputStream, long l, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        similarityIndex.hashLargeObject(inputStream, l, bl);
    }

    public final void hash$intellij_javascript_debugger(@NotNull byte[] raw, int _ptr, int end, boolean isText) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        int ptr = _ptr;
        this.hashedCnt = 0L;
        while (ptr < end) {
            int hash = 5381;
            int blockHashedCnt = 0;
            int start2 = ptr;
            do {
                int c = raw[ptr++] & 0xFF;
                if (isText && c == 13 && ptr < end && raw[ptr] == 10 || isText && c == 32 && blockHashedCnt == 0) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash += (hash << 5) + c;
            } while (ptr < end && ptr - start2 < 64);
            if (blockHashedCnt == 1) continue;
            this.hashedCnt += (long)blockHashedCnt;
            this.add$intellij_javascript_debugger(hash, blockHashedCnt);
        }
    }

    public static /* synthetic */ void hash$intellij_javascript_debugger$default(SimilarityIndex similarityIndex, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        similarityIndex.hash$intellij_javascript_debugger(byArray, n, n2, bl);
    }

    public final void hash$intellij_javascript_debugger(@NotNull InputStream in, long _remaining, boolean text) {
        int n;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        byte[] buf = new byte[4096];
        int ptr = 0;
        int cnt = 0;
        for (long remaining = _remaining; 0L < remaining; remaining -= (long)n) {
            int hash = 5381;
            int blockHashedCnt = 0;
            n = 0;
            do {
                if (ptr == cnt) {
                    ptr = 0;
                    cnt = in.read(buf, 0, buf.length);
                    if (cnt <= 0) {
                        throw new EOFException();
                    }
                }
                ++n;
                int c = buf[ptr++] & 0xFF;
                if (text && c == 13 && ptr < cnt && buf[ptr] == 10) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash += (hash << 5) + c;
            } while (n < 64 && (long)n < remaining);
            this.hashedCnt += (long)blockHashedCnt;
            this.add$intellij_javascript_debugger(hash, blockHashedCnt);
        }
    }

    public final void sort$intellij_javascript_debugger() {
        Arrays.sort(this.idHash);
    }

    public final int score(@NotNull SimilarityIndex dst, int maxScore) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        long max = Math.max(this.hashedCnt, dst.hashedCnt);
        if (max == 0L) {
            return maxScore;
        }
        return (int)(this.common$intellij_javascript_debugger(dst) * (long)maxScore / max);
    }

    public static /* synthetic */ int score$default(SimilarityIndex similarityIndex, SimilarityIndex similarityIndex2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        return similarityIndex.score(similarityIndex2, n);
    }

    public final long common$intellij_javascript_debugger(@NotNull SimilarityIndex dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return SimilarityIndex.Companion.common(this, dst);
    }

    @TestOnly
    public final int key$intellij_javascript_debugger(int idx) {
        return SimilarityIndexKt.access$keyOf(this.idHash[this.packedIndex(idx)]);
    }

    @TestOnly
    public final long count$intellij_javascript_debugger(int idx) {
        return SimilarityIndexKt.access$countOf(this.idHash[this.packedIndex(idx)]);
    }

    @TestOnly
    public final int findIndex$intellij_javascript_debugger(int key) {
        int i = 0;
        int n = this.idSize - 1;
        if (i <= n) {
            while (true) {
                if (this.key$intellij_javascript_debugger(i) == key) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return -1;
    }

    private final int packedIndex(int idx) {
        return this.idHash.length - this.idSize + idx;
    }

    public final void add$intellij_javascript_debugger(int _key, int cnt) {
        int key = _key;
        key = key * -1640562687 >>> 1;
        int j = this.slot(key);
        while (true) {
            long v;
            if ((v = this.idHash[j]) == 0L) {
                if (this.idGrowAt <= this.idSize) {
                    this.grow();
                    j = this.slot(key);
                    continue;
                }
                this.idHash[j] = SimilarityIndexKt.access$pair(key, cnt);
                int n = this.idSize;
                this.idSize = n + 1;
                return;
            }
            if (SimilarityIndexKt.access$keyOf(v) == key) {
                this.idHash[j] = SimilarityIndexKt.access$pair(key, SimilarityIndexKt.access$countOf(v) + (long)cnt);
                return;
            }
            if (++j < this.idHash.length) continue;
            j = 0;
        }
    }

    private final int slot(int key) {
        return key >>> 31 - this.idHashBits;
    }

    private final void grow() {
        if (this.idHashBits == 30) {
            throw new TableFullException(null, 1, null);
        }
        long[] oldHash = this.idHash;
        int oldSize = this.idHash.length;
        int n = this.idHashBits;
        this.idHashBits = n + 1;
        this.idGrowAt = SimilarityIndexKt.access$growAt(this.idHashBits);
        try {
            this.idHash = new long[1 << this.idHashBits];
        }
        catch (OutOfMemoryError e) {
            throw new TableFullException(e);
        }
        int i = 0;
        int n2 = oldSize - 1;
        if (i <= n2) {
            while (true) {
                long v;
                if ((v = oldHash[i]) != 0L) {
                    int j = this.slot(SimilarityIndexKt.access$keyOf(v));
                    while (this.idHash[j] != 0L) {
                        if (++j < this.idHash.length) continue;
                        j = 0;
                    }
                    this.idHash[j] = v;
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/util/text/SimilarityIndex$Companion;", "", "<init>", "()V", "common", "", "src", "Lcom/intellij/openapi/util/text/SimilarityIndex;", "dst", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        private final long common(SimilarityIndex src, SimilarityIndex dst) {
            int srcIdx = src.packedIndex(0);
            int dstIdx = dst.packedIndex(0);
            long[] srcHash = src.idHash;
            long[] dstHash = dst.idHash;
            return SimilarityIndexKt.access$common(srcHash, srcIdx, dstHash, dstIdx);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

