/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.terminal.pipe;

import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.terminal.pipe.DockerMessagesPrinter;
import com.intellij.docker.agent.terminal.pipe.SimpleTerminalPipe;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\"\u0010\u0018\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u001aH\u0087@\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "Lcom/intellij/docker/agent/terminal/pipe/SimpleTerminalPipe;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "value", "", "terminalColumns", "getTerminalColumns", "()I", "terminalRows", "getTerminalRows", "myTtyResizeChanel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$TerminalSize;", "ttyResizeHandler", "Lcom/intellij/remoteServer/agent/util/log/TerminalListener$TtyResizeHandler;", "getTtyResizeHandler", "()Lcom/intellij/remoteServer/agent/util/log/TerminalListener$TtyResizeHandler;", "onTerminalResized", "", "width", "height", "listenTerminalResizing", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "Log", "TerminalSize", "WithTty", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerTerminalPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerTerminalPipe.kt\ncom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe\n+ 2 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,170:1\n8#2:171\n*S KotlinDebug\n*F\n+ 1 DockerTerminalPipe.kt\ncom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe\n*L\n66#1:171\n*E\n"})
public class DockerTerminalPipe
extends SimpleTerminalPipe {
    @NotNull
    public static final Log Log = new Log(null);
    private int terminalColumns;
    private int terminalRows;
    @NotNull
    private final Channel<TerminalSize> myTtyResizeChanel;
    @NotNull
    private final TerminalListener.TtyResizeHandler ttyResizeHandler;
    @NotNull
    private static final Logger logger;

    public DockerTerminalPipe(@NotNull CoroutineScope parentCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        super(parentCoroutineScope);
        this.myTtyResizeChanel = ChannelKt.Channel$default((int)-2, null, null, (int)6, null);
        this.ttyResizeHandler = (arg_0, arg_1) -> DockerTerminalPipe.ttyResizeHandler$lambda$0(this, arg_0, arg_1);
    }

    public final int getTerminalColumns() {
        return this.terminalColumns;
    }

    public final int getTerminalRows() {
        return this.terminalRows;
    }

    @NotNull
    public final TerminalListener.TtyResizeHandler getTtyResizeHandler() {
        return this.ttyResizeHandler;
    }

    protected void onTerminalResized(int width, int height) {
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public final Object listenTerminalResizing(@NotNull Function1<? super TerminalSize, Unit> block, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.myTtyResizeChanel)).collect(new FlowCollector(block){
            final /* synthetic */ Function1<TerminalSize, Unit> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Object emit(TerminalSize p0, Continuation<? super Unit> $completion) {
                Object object = DockerTerminalPipe.access$listenTerminalResizing$suspendConversion0(this.$tmp0, p0, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, this.$tmp0, Intrinsics.Kotlin.class, "suspendConversion0", "listenTerminalResizing$suspendConversion0(Lkotlin/jvm/functions/Function1;Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$TerminalSize;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof FlowCollector ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.myTtyResizeChanel), null, (int)1, null);
        super.close();
    }

    private static final void ttyResizeHandler$lambda$0(DockerTerminalPipe this$0, int w, int h) {
        this$0.terminalColumns = w;
        this$0.terminalRows = h;
        this$0.myTtyResizeChanel.trySend-JP2dKIU((Object)new TerminalSize(w, h));
        this$0.onTerminalResized(w, h);
    }

    private static final /* synthetic */ Object listenTerminalResizing$suspendConversion0(Function1 $this$listenTerminalResizing_u24suspendConversion0, TerminalSize p0, Continuation $completion) {
        $this$listenTerminalResizing_u24suspendConversion0.invoke((Object)p0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$listenTerminalResizing$suspendConversion0(Function1 $receiver, TerminalSize p0, Continuation $completion) {
        return DockerTerminalPipe.listenTerminalResizing$suspendConversion0($receiver, p0, $completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DockerTerminalPipe.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DockerTerminalPipe.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$Log;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "intellij.clouds.docker.agent"})
    public static final class Log {
        private Log() {
        }

        public /* synthetic */ Log(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$TerminalSize;", "", "columns", "", "row", "<init>", "(II)V", "getColumns", "()I", "getRow", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.clouds.docker.agent"})
    public static final class TerminalSize {
        private final int columns;
        private final int row;

        public TerminalSize(int columns, int row) {
            this.columns = columns;
            this.row = row;
        }

        public final int getColumns() {
            return this.columns;
        }

        public final int getRow() {
            return this.row;
        }

        public final int component1() {
            return this.columns;
        }

        public final int component2() {
            return this.row;
        }

        @NotNull
        public final TerminalSize copy(int columns, int row) {
            return new TerminalSize(columns, row);
        }

        public static /* synthetic */ TerminalSize copy$default(TerminalSize terminalSize, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = terminalSize.columns;
            }
            if ((n3 & 2) != 0) {
                n2 = terminalSize.row;
            }
            return terminalSize.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "TerminalSize(columns=" + this.columns + ", row=" + this.row + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.columns);
            result2 = result2 * 31 + Integer.hashCode(this.row);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalSize)) {
                return false;
            }
            TerminalSize terminalSize = (TerminalSize)other;
            if (this.columns != terminalSize.columns) {
                return false;
            }
            return this.row == terminalSize.row;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\bJ\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u00020\u000b2\b\b\u0001\u0010\u0013\u001a\u00020\rH\u0016J\u0012\u0010\u0014\u001a\u00020\u000b2\b\b\u0003\u0010\u0015\u001a\u00020\rH\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "Lcom/intellij/docker/agent/terminal/pipe/DockerMessagesPrinter;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "asTtySink", "printSuccess", "", "success", "", "printWarning", "warning", "printInfo", "info", "printError", "error", "println", "text", "print", "setShowCursor", "show", "", "clearScreen", "Companion", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerTerminalPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerTerminalPipe.kt\ncom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
    public static class WithTty
    extends DockerTerminalPipe
    implements DockerMessagesPrinter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final TtySink ttySink;

        public WithTty(@NotNull CoroutineScope parentCoroutineScope) {
            Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
            super(parentCoroutineScope);
            this.ttySink = TtySink.Companion.wrap(arg_0 -> WithTty.ttySink$lambda$0(this, arg_0));
        }

        @NotNull
        public final TtySink asTtySink() {
            return this.ttySink;
        }

        @Override
        public void printSuccess(@Nls @NotNull String success) {
            Intrinsics.checkNotNullParameter((Object)success, (String)"success");
            this.ttySink.coloredTtyPrintln(success, TtySink.Colors.GREEN);
        }

        @Override
        public void printWarning(@Nls @NotNull String warning) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            this.ttySink.coloredTtyPrintln(warning, TtySink.Colors.ORANGE);
        }

        @Override
        public void printInfo(@Nls @NotNull String info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.ttySink.coloredTtyPrintln(info, TtySink.Colors.BLUE);
        }

        @Override
        public void printError(@Nls @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.ttySink.coloredTtyPrintln(error, TtySink.Colors.RED);
        }

        @JvmOverloads
        public final void println(@Nls @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.ttySink.ttyPrintln(text);
        }

        public static /* synthetic */ void println$default(WithTty withTty, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: println");
            }
            if ((n & 1) != 0) {
                string = "";
            }
            withTty.println(string);
        }

        public final synchronized void print(@Nls @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Logger it = logger;
            boolean bl = false;
            if (it.isTraceEnabled()) {
                String safeText = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (char)'\u001b', (char)'^', (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
                it.trace(safeText);
            }
            SendChannel sendChannel = (SendChannel)this.getOutToTerminalChannel();
            String string = text;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ChannelsKt.trySendBlocking((SendChannel)sendChannel, (Object)byArray);
        }

        @NotNull
        public final WithTty setShowCursor(boolean show) {
            WithTty withTty;
            WithTty $this$setShowCursor_u24lambda_u242 = withTty = this;
            boolean bl = false;
            $this$setShowCursor_u24lambda_u242.ttySink.ttyCursorShow(show);
            return withTty;
        }

        public final void clearScreen() {
            this.ttySink.ttyClearScreen();
        }

        @Nullable
        public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
            return DockerMessagesPrinter.DefaultImpls.get(this, key);
        }

        public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
            return DockerMessagesPrinter.DefaultImpls.fold(this, initial, operation);
        }

        @NotNull
        public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
            return DockerMessagesPrinter.DefaultImpls.minusKey(this, key);
        }

        @NotNull
        public CoroutineContext plus(@NotNull CoroutineContext context) {
            return DockerMessagesPrinter.DefaultImpls.plus(this, context);
        }

        @JvmOverloads
        public final void println() {
            WithTty.println$default(this, null, 1, null);
        }

        private static final void ttySink$lambda$0(WithTty this$0, String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this$0.print(text);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty$Companion;", "", "<init>", "()V", "asPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "Lcom/intellij/docker/agent/terminal/pipe/DockerMessagesPrinter;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final WithTty asPipe(@NotNull DockerMessagesPrinter $this$asPipe) {
                Intrinsics.checkNotNullParameter((Object)$this$asPipe, (String)"<this>");
                return $this$asPipe instanceof WithTty ? (WithTty)$this$asPipe : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

