/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlScript;
import com.intellij.database.remote.jdba.sql.SqlStatement;
import com.intellij.database.remote.jdba.sql.TextPointer;
import com.intellij.database.remote.jdba.sql.TextWalker;
import com.intellij.database.remote.jdba.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SqlScriptBuilder {
    private final ArrayList<SqlStatement> myStatements = new ArrayList();
    private static final Pattern SQL_END_MARKER = Pattern.compile("(;|\\n\\s*/)(\\s|\\n|--[^\\n]*?\\n|/\\*.*?\\*/)*?(\\n|$)|$", 32);
    private static final Pattern PL_ESSENTIAL_WORDS_PATTERN = Pattern.compile("^(declare|begin|(create (or replace )?(type|package|procedure|function|trigger|alias))).*");

    public void add(String ... commands) {
        if (commands == null) {
            SqlScriptBuilder.$$$reportNull$$$0(0);
        }
        for (String command : commands) {
            SqlCommand cmd = new SqlCommand(command);
            this.myStatements.add(cmd);
        }
    }

    public void add(SqlCommand ... commands) {
        if (commands == null) {
            SqlScriptBuilder.$$$reportNull$$$0(1);
        }
        Collections.addAll(this.myStatements, commands);
    }

    public void add(SqlScript ... scripts) {
        if (scripts == null) {
            SqlScriptBuilder.$$$reportNull$$$0(2);
        }
        for (SqlScript script : scripts) {
            if (!script.hasStatements()) continue;
            this.myStatements.addAll(script.getStatements());
        }
    }

    public void parse(@NotNull String text) {
        if (text == null) {
            SqlScriptBuilder.$$$reportNull$$$0(3);
        }
        TextWalker walker = new TextWalker(text);
        while (!walker.isEOT()) {
            this.skipEmptySpace(walker);
            if (walker.isEOT()) break;
            String essentialWords = SqlScriptBuilder.extractEssentialWords(walker, 6);
            boolean pl = this.determinePL(essentialWords);
            if (pl) {
                this.extractPLBlock(walker);
                continue;
            }
            this.extractSQLCommand(walker);
        }
    }

    static String extractEssentialWords(@NotNull TextWalker walker, int limitWords) {
        if (walker == null) {
            SqlScriptBuilder.$$$reportNull$$$0(4);
        }
        TextWalker w = walker.clone();
        StringBuilder b = new StringBuilder(40);
        int wordsCnt = 0;
        boolean inWord = false;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        while (!w.isEOT()) {
            char c = w.getChar();
            char c2 = w.getNextChar();
            boolean isWordChar = Character.isJavaIdentifierPart(c);
            if (inSingleLineComment) {
                if (c == '\n') {
                    inSingleLineComment = false;
                }
            } else if (inMultiLineComment) {
                if (c == '*' && c2 == '/') {
                    w.next();
                    inMultiLineComment = false;
                }
            } else if (inWord && !isWordChar) {
                if (++wordsCnt >= limitWords) break;
                b.append(' ');
                inWord = false;
            } else if (isWordChar) {
                b.append(Character.toLowerCase(c));
                inWord = true;
            } else {
                if (c == '-' && c2 == '-') {
                    inSingleLineComment = true;
                    w.next();
                }
                if (c == '/' && c2 == '*') {
                    inMultiLineComment = true;
                    w.next();
                }
            }
            w.next();
        }
        return b.toString().trim();
    }

    private void extractPLBlock(@NotNull TextWalker walker) {
        int position;
        String row;
        if (walker == null) {
            SqlScriptBuilder.$$$reportNull$$$0(5);
        }
        TextPointer begin = walker.getPointer();
        do {
            position = walker.getOffset();
        } while (!walker.isEOT() && !(row = walker.popRow().trim()).equals("/"));
        String plText = Strings.rtrim(walker.getText().substring(begin.offset, position));
        SqlCommand command = new SqlCommand(plText, begin.row, null);
        this.myStatements.add(command);
    }

    private void extractSQLCommand(@NotNull TextWalker walker) {
        if (walker == null) {
            SqlScriptBuilder.$$$reportNull$$$0(6);
        }
        this.skipEmptySpace(walker);
        TextPointer begin = walker.getPointer();
        Matcher matcher = walker.skipToPattern(SQL_END_MARKER);
        String sqlText = Strings.rtrim(walker.getText().substring(begin.offset, walker.getOffset()));
        SqlCommand command = new SqlCommand(sqlText, begin.row, null);
        this.myStatements.add(command);
        if (matcher != null) {
            walker.skipToOffset(matcher.end());
        }
    }

    boolean determinePL(@NotNull String essentialWords) {
        if (essentialWords == null) {
            SqlScriptBuilder.$$$reportNull$$$0(7);
        }
        return PL_ESSENTIAL_WORDS_PATTERN.matcher(essentialWords).matches();
    }

    protected void skipEmptySpace(@NotNull TextWalker walker) {
        if (walker == null) {
            SqlScriptBuilder.$$$reportNull$$$0(8);
        }
        block0: while (!walker.isEOT()) {
            char c1 = walker.getChar();
            if (Character.isWhitespace(c1)) {
                walker.next();
                continue;
            }
            char c2 = walker.getNextChar();
            if (c1 == '-' && c2 == '-') {
                while (!walker.isEOT()) {
                    walker.next();
                    if (walker.getChar() != '\n') continue;
                    walker.next();
                    break;
                }
            }
            if (c1 != '/' || c2 != '*') break;
            walker.next();
            walker.next();
            while (!walker.isEOT()) {
                if (walker.getChar() == '*' && walker.getNextChar() == '/') {
                    walker.next();
                    walker.next();
                    break block0;
                }
                walker.next();
            }
            break block0;
        }
    }

    @NotNull
    public SqlScript build() {
        return new SqlScript(this.myStatements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scripts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "essentialWords";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/sql/SqlScriptBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractEssentialWords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPLBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extractSQLCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "determinePL";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "skipEmptySpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

