/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow.packages.table;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SideBorder;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.NamedColorUtil;
import com.jetbrains.python.packaging.toolwindow.PyPackagingTablesView;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowPanel;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowService;
import com.jetbrains.python.packaging.toolwindow.model.DisplayablePackage;
import com.jetbrains.python.packaging.toolwindow.model.ExpandResultNode;
import com.jetbrains.python.packaging.toolwindow.model.PyPackagesViewData;
import com.jetbrains.python.packaging.toolwindow.packages.PyPaginationAwareRenderer;
import com.jetbrains.python.packaging.toolwindow.packages.table.PyPackageTableMouseAdapter;
import com.jetbrains.python.packaging.toolwindow.packages.table.PyPackagesHoverListener;
import com.jetbrains.python.packaging.toolwindow.ui.PyPackagesTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u0004\u0018\u00010\u0016J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0016J\u0018\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00063"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/packages/table/PyPackagesTable;", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "tablesView", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingTablesView;", "controller", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/packaging/toolwindow/PyPackagingTablesView;Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowPanel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getController", "()Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowPanel;", "hoveredColumn", "", "getHoveredColumn$intellij_python_community_impl", "()I", "setHoveredColumn$intellij_python_community_impl", "(I)V", "model", "Lcom/jetbrains/python/packaging/toolwindow/ui/PyPackagesTableModel;", "Lcom/jetbrains/python/packaging/toolwindow/model/DisplayablePackage;", "getModel$annotations", "()V", "getModel", "()Lcom/jetbrains/python/packaging/toolwindow/ui/PyPackagesTableModel;", "value", "", "items", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "getCellRenderer", "Lcom/jetbrains/python/packaging/toolwindow/packages/PyPaginationAwareRenderer;", "row", "column", "selectedItem", "selectedItems", "Lkotlin/sequences/Sequence;", "selectPackage", "", "pkg", "initCrossNavigation", "service", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "loadMoreItems", "node", "Lcom/jetbrains/python/packaging/toolwindow/model/ExpandResultNode;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackagesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackagesTable.kt\ncom/jetbrains/python/packaging/toolwindow/packages/table/PyPackagesTable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,161:1\n31#2,2:162\n*S KotlinDebug\n*F\n+ 1 PyPackagesTable.kt\ncom/jetbrains/python/packaging/toolwindow/packages/table/PyPackagesTable\n*L\n44#1:162,2\n*E\n"})
public final class PyPackagesTable
extends JBTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PyPackagingToolWindowPanel controller;
    private int hoveredColumn;
    @NotNull
    private final PyPackagesTableModel<DisplayablePackage> model;
    @NotNull
    private static final String NEXT_ROW_ACTION = "selectNextRow";
    @NotNull
    private static final String PREVIOUS_ROW_ACTION = "selectPreviousRow";
    @NotNull
    private static final String ENTER_ACTION = "ENTER";

    public PyPackagesTable(@NotNull Project project, @NotNull PyPackagingTablesView tablesView, @NotNull PyPackagingToolWindowPanel controller) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tablesView, (String)"tablesView");
        Intrinsics.checkNotNullParameter((Object)((Object)controller), (String)"controller");
        super((TableModel)((Object)new PyPackagesTableModel()));
        this.project = project;
        this.controller = controller;
        this.hoveredColumn = -1;
        TableModel tableModel = this.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.jetbrains.python.packaging.toolwindow.ui.PyPackagesTableModel<com.jetbrains.python.packaging.toolwindow.model.DisplayablePackage>");
        this.model = (PyPackagesTableModel)((Object)tableModel);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PyPackagingToolWindowService> serviceClass$iv = PyPackagingToolWindowService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        final PyPackagingToolWindowService service = (PyPackagingToolWindowService)object;
        this.setShowGrid(false);
        this.setSelectionMode(2);
        TableColumn column = this.columnModel.getColumn(1);
        column.setMinWidth(130);
        column.setMaxWidth(130);
        column.setResizable(false);
        this.setBorder((Border)new SideBorder(NamedColorUtil.getBoundsColor(), 8));
        this.rowHeight = 20;
        this.initCrossNavigation(service, tablesView);
        PyPackagesHoverListener hoverListener = new PyPackagesHoverListener(this);
        hoverListener.addTo((JComponent)((Object)this));
        this.addMouseListener(new PyPackageTableMouseAdapter(this));
        this.selectionModel.addListSelectionListener(arg_0 -> PyPackagesTable._init_$lambda$0(this, tablesView, arg_0));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DisplayablePackage displayablePackage = this.selectedItem();
                if (displayablePackage == null) {
                    return true;
                }
                DisplayablePackage pkg = displayablePackage;
                if (pkg instanceof ExpandResultNode) {
                    this.loadMoreItems(service, (ExpandResultNode)pkg);
                }
                return true;
            }
        }.installOn((Component)((Object)this));
        AnAction anAction = ActionManager.getInstance().getAction("PyPackageToolwindowContext");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup packageActionGroup = (ActionGroup)anAction;
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this)), (ActionGroup)packageActionGroup, (String)"PackagePopup");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PyPackagingToolWindowPanel getController() {
        return this.controller;
    }

    public final int getHoveredColumn$intellij_python_community_impl() {
        return this.hoveredColumn;
    }

    public final void setHoveredColumn$intellij_python_community_impl(int n) {
        this.hoveredColumn = n;
    }

    @NotNull
    public final PyPackagesTableModel<DisplayablePackage> getModel() {
        return this.model;
    }

    public static /* synthetic */ void getModel$annotations() {
    }

    @NotNull
    public final List<DisplayablePackage> getItems() {
        List list = this.model.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return list;
    }

    public final void setItems(@NotNull List<? extends DisplayablePackage> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.model.setItems(CollectionsKt.toMutableList((Collection)value));
    }

    @NotNull
    public PyPaginationAwareRenderer getCellRenderer(int row, int column) {
        return new PyPaginationAwareRenderer();
    }

    @Nullable
    public final DisplayablePackage selectedItem() {
        return (DisplayablePackage)CollectionsKt.getOrNull(this.getItems(), (int)this.getSelectedRow());
    }

    @NotNull
    public final Sequence<DisplayablePackage> selectedItems() {
        int[] nArray = this.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        return SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((int[])nArray), arg_0 -> PyPackagesTable.selectedItems$lambda$1(this, arg_0));
    }

    public final void selectPackage(@NotNull DisplayablePackage pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        int index = this.getItems().indexOf(pkg);
        if (index != -1) {
            this.setRowSelectionInterval(index, index);
        }
    }

    private final void initCrossNavigation(PyPackagingToolWindowService service, PyPackagingTablesView tablesView) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), ENTER_ACTION);
        this.getActionMap().put(ENTER_ACTION, new AbstractAction(this, service){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingToolWindowService $service;
            {
                this.this$0 = $receiver;
                this.$service = $service;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                int index = this.this$0.getSelectedRow();
                DisplayablePackage displayablePackage = this.this$0.selectedItem();
                if (displayablePackage == null) {
                    return;
                }
                DisplayablePackage selectedItem = displayablePackage;
                if (selectedItem instanceof ExpandResultNode) {
                    PyPackagesTable.access$loadMoreItems(this.this$0, this.$service, (ExpandResultNode)selectedItem);
                }
                this.this$0.setRowSelectionInterval(index, index);
            }
        });
        Action nextRowAction = this.getActionMap().get(NEXT_ROW_ACTION);
        this.getActionMap().put(NEXT_ROW_ACTION, new AbstractAction(this, tablesView, nextRowAction){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingTablesView $tablesView;
            final /* synthetic */ Action $nextRowAction;
            {
                this.this$0 = $receiver;
                this.$tablesView = $tablesView;
                this.$nextRowAction = $nextRowAction;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                if (this.this$0.getSelectedRow() + 1 == this.this$0.getItems().size()) {
                    this.$tablesView.selectNextFrom((JTable)((Object)this.this$0));
                } else {
                    this.$nextRowAction.actionPerformed(e);
                }
            }
        });
        Action prevRowAction = this.getActionMap().get(PREVIOUS_ROW_ACTION);
        this.getActionMap().put(PREVIOUS_ROW_ACTION, new AbstractAction(this, tablesView, prevRowAction){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingTablesView $tablesView;
            final /* synthetic */ Action $prevRowAction;
            {
                this.this$0 = $receiver;
                this.$tablesView = $tablesView;
                this.$prevRowAction = $prevRowAction;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                if (this.this$0.getSelectedRow() == 0) {
                    this.$tablesView.selectPreviousOf((JTable)((Object)this.this$0));
                } else {
                    this.$prevRowAction.actionPerformed(e);
                }
            }
        });
    }

    private final void loadMoreItems(PyPackagingToolWindowService service, ExpandResultNode node) {
        PyPackagesViewData result2 = service.getMoreResultsForRepo(node.getRepository(), this.getItems().size() - 1);
        this.setItems(CollectionsKt.plus((Collection)CollectionsKt.dropLast(this.getItems(), (int)1), (Iterable)result2.getPackages()));
        if (result2.getMoreItems() > 0) {
            node.setMore(result2.getMoreItems());
            this.setItems(CollectionsKt.plus((Collection)this.getItems(), (Iterable)CollectionsKt.listOf((Object)node)));
        }
        this.revalidate();
        this.repaint();
    }

    private static final void _init_$lambda$0(PyPackagesTable this$0, PyPackagingTablesView $tablesView, ListSelectionEvent it) {
        DisplayablePackage pkg = this$0.selectedItem();
        if (pkg != null && !(pkg instanceof ExpandResultNode)) {
            $tablesView.removeSelectionNotFormTable((JTable)((Object)this$0));
            this$0.controller.packageSelected(pkg);
        } else {
            this$0.controller.setEmpty();
        }
    }

    private static final DisplayablePackage selectedItems$lambda$1(PyPackagesTable this$0, int it) {
        return (DisplayablePackage)CollectionsKt.getOrNull(this$0.getItems(), (int)it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/packages/table/PyPackagesTable$Companion;", "", "<init>", "()V", "NEXT_ROW_ACTION", "", "PREVIOUS_ROW_ACTION", "ENTER_ACTION", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

