/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestToExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.TaperingScope;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0016JV\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00140\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016JJ\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150 2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u0017H\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120 2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006,"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "internalAuthorities", "", "", "<init>", "(Ljava/util/Set;)V", "getIndicatorText", "Lorg/jetbrains/annotations/Nls;", "getEndpointTypesToSearch", "Lcom/intellij/microservices/endpoints/EndpointType;", "isToExternalService", "", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "(Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;)Z", "findRequestsToEndpointUrls", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "clientModules", "", "Lcom/intellij/openapi/module/Module;", "moduleToEndpoints", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createRequestsGraph", "", "serverModules", "moduleToRequests", "findRawUrlsInCode", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/url/references/UrlPathReference;", "modulesToSearchIn", "searchForRequestsFormingAnEdge", "edge", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "Companion", "RequestToUrl", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nRequestsToExternalEndpointsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToExternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,189:1\n1251#2,2:190\n992#2:200\n1021#2,3:201\n1024#2,3:211\n1317#2,2:245\n1755#3,3:192\n1246#3,4:196\n1216#3,2:217\n1246#3,4:219\n774#3:223\n865#3,2:224\n1557#3:226\n1628#3,3:227\n774#3:237\n865#3:238\n1755#3,3:239\n866#3:242\n1863#3,2:243\n412#4:195\n381#4,7:204\n381#4,7:230\n216#5:214\n217#5:216\n1#6:215\n1310#7,2:247\n*S KotlinDebug\n*F\n+ 1 RequestsToExternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher\n*L\n66#1:190,2\n91#1:200\n91#1:201,3\n91#1:211,3\n186#1:245,2\n68#1:192,3\n81#1:196,4\n106#1:217,2\n106#1:219,4\n110#1:223\n110#1:224,2\n111#1:226\n111#1:227,3\n181#1:237\n181#1:238\n181#1:239,3\n181#1:242\n182#1:243,2\n81#1:195\n91#1:204,7\n118#1:230,7\n92#1:214\n92#1:216\n154#1:247,2\n*E\n"})
public final class RequestsToExternalEndpointsSearcher
extends RequestsToEndpointUrlsSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> internalAuthorities;
    @NotNull
    private static final Set<EndpointType> CLIENT_ENDPOINT_TYPES;
    @NotNull
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;
    @NotNull
    private static final List<String> URL_FOOTPRINTS;

    public RequestsToExternalEndpointsSearcher(@NotNull Set<String> internalAuthorities) {
        Intrinsics.checkNotNullParameter(internalAuthorities, (String)"internalAuthorities");
        this.internalAuthorities = internalAuthorities;
    }

    @Override
    @NotNull
    public String getIndicatorText() {
        return MicroservicesUiBundle.message("microservices.diagrams.webservices.searching.external.http.requests", new Object[0]);
    }

    @Override
    @NotNull
    public Set<EndpointType> getEndpointTypesToSearch() {
        return CLIENT_ENDPOINT_TYPES;
    }

    private final boolean isToExternalService(RequestToUrl $this$isToExternalService) {
        boolean bl;
        block8: {
            RequestToUrl requestToUrl = $this$isToExternalService;
            if (requestToUrl instanceof RequestToUrl.WithKnownTargetInfo) {
                Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((RequestToUrl.WithKnownTargetInfo)$this$isToExternalService).getInfo().getAuthorities()), RequestsToExternalEndpointsSearcher::_get_isToExternalService_$lambda$0);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!this.internalAuthorities.contains(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            } else if (requestToUrl instanceof RequestToUrl.WithKnownPathReference) {
                Iterable $this$any$iv = ((RequestToUrl.WithKnownPathReference)$this$isToExternalService).getRef().getContext().getAuthorities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!(!this.internalAuthorities.contains(it))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> clientModules, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> moduleToEndpoints, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Map map;
        Intrinsics.checkNotNullParameter(clientModules, (String)"clientModules");
        Intrinsics.checkNotNullParameter(moduleToEndpoints, (String)"moduleToEndpoints");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Map $this$findRequestsToEndpointUrls_u24lambda_u2415 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Sequence $this$mapValuesTo$iv = moduleToEndpoints;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = $this$findRequestsToEndpointUrls_u24lambda_u2415;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            List targetInfos = (List)entry2.getValue();
            List list = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)targetInfos), RequestsToExternalEndpointsSearcher::findRequestsToEndpointUrls$lambda$15$lambda$5$lambda$3), arg_0 -> RequestsToExternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$15$lambda$5$lambda$4(this, arg_0)));
            map3.put(k, list);
        }
        $this$mapValuesTo$iv = SequencesKt.filter((Sequence)SequencesKt.map(this.findRawUrlsInCode((Iterable<? extends Module>)clientModules, project, searchParams), RequestsToExternalEndpointsSearcher::findRequestsToEndpointUrls$lambda$15$lambda$6), arg_0 -> RequestsToExternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$15$lambda$7(this, arg_0));
        boolean $i$f$groupBy = false;
        $this$associateByTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RequestToUrl.WithKnownPathReference it = (RequestToUrl.WithKnownPathReference)element$iv$iv;
            boolean bl4 = false;
            Module key$iv$iv = (Module)ActionsKt.runReadAction(() -> RequestsToExternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$15$lambda$9$lambda$8(it));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Module it;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl6 = false;
            Module module = (Module)entry.getKey();
            List urls = (List)entry.getValue();
            if (module == null) continue;
            boolean bl7 = false;
            $this$findRequestsToEndpointUrls_u24lambda_u2415.compute(it, (arg_0, arg_1) -> RequestsToExternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$15$lambda$14$lambda$13$lambda$12((arg_0, arg_1) -> RequestsToExternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$15$lambda$14$lambda$13$lambda$11(urls, arg_0, arg_1), arg_0, arg_1));
        }
        Map moduleToUrls = map;
        return this.createRequestsGraph((Iterable<? extends Module>)clientModules, moduleToEndpoints.keySet(), moduleToUrls);
    }

    /*
     * WARNING - void declaration
     */
    private final Network<MsDiagramEndpoint, MsDiagramRequest> createRequestsGraph(Iterable<? extends Module> clientModules, Iterable<? extends Module> serverModules, Map<Module, ? extends List<? extends RequestToUrl>> moduleToRequests) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        List allModules = CollectionsKt.plus(clientModules, serverModules);
        Iterable $this$associateBy$iv = allModules;
        boolean $i$f$associateBy = false;
        int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Module module = (Module)element$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            Module module2 = (Module)element$iv$iv;
            Module module3 = module;
            boolean bl22 = false;
            MsDiagramWebservice msDiagramWebservice = new MsDiagramWebservice(module2);
            object.put(module3, msDiagramWebservice);
        }
        Map moduleToWebservice = destination$iv$iv;
        Map authorityToEndpoint = new LinkedHashMap();
        Iterable capacity$iv232 = allModules;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            Module it = (Module)t;
            bl = false;
            List<? extends RequestToUrl> list = moduleToRequests.get(it);
            boolean bl3 = list != null ? !((Collection)list).isEmpty() : false;
            if (!bl3) continue;
            destination$iv$iv2.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            Module it = (Module)t;
            object = destination$iv$iv3;
            bl = false;
            object.add((MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)it));
        }
        List it = (List)destination$iv$iv3;
        boolean bl4 = false;
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf(it);
        for (Map.Entry<Module, ? extends List<? extends RequestToUrl>> entry : moduleToRequests.entrySet()) {
            Module sourceModule = entry.getKey();
            List<? extends RequestToUrl> urls = entry.getValue();
            Object v = moduleToWebservice.get(sourceModule);
            Intrinsics.checkNotNull(v);
            MsDiagramWebservice source = (MsDiagramWebservice)v;
            for (RequestToUrl requestToUrl : urls) {
                RequestToExternalEndpoint requestToExternalEndpoint;
                Object object2;
                String authority;
                if (requestToUrl.getAuthority() == null) continue;
                Map $this$getOrPut$iv = authorityToEndpoint;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(authority);
                if (value$iv == null) {
                    boolean bl42 = false;
                    Project project = sourceModule.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    RequestToUrl.WithKnownTargetInfo withKnownTargetInfo = requestToUrl instanceof RequestToUrl.WithKnownTargetInfo ? (RequestToUrl.WithKnownTargetInfo)requestToUrl : null;
                    MsDiagramExternalEndpoint answer$iv = new MsDiagramExternalEndpoint(project, authority, (UrlTargetInfo)(withKnownTargetInfo != null ? withKnownTargetInfo.getInfo() : null));
                    $this$getOrPut$iv.put(authority, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                MsDiagramExternalEndpoint externalEndpoint = (MsDiagramExternalEndpoint)object2;
                RequestToUrl requestToUrl2 = requestToUrl;
                if (requestToUrl2 instanceof RequestToUrl.WithKnownTargetInfo) {
                    requestToExternalEndpoint = new RequestToExternalEndpoint(source, externalEndpoint, ((RequestToUrl.WithKnownTargetInfo)requestToUrl).getInfo(), null);
                } else if (requestToUrl2 instanceof RequestToUrl.WithKnownPathReference) {
                    requestToExternalEndpoint = new RequestToExternalEndpoint(source, externalEndpoint, null, ((RequestToUrl.WithKnownPathReference)requestToUrl).getRef());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                RequestToExternalEndpoint request2 = requestToExternalEndpoint;
                requestsGraph.addEdge((Object)source, (Object)externalEndpoint, (Object)request2);
            }
        }
        return (Network)requestsGraph;
    }

    private final Sequence<UrlPathReference> findRawUrlsInCode(Iterable<? extends Module> modulesToSearchIn, Project project, RequestsSearcher.SearchParams searchParams) {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)URL_FOOTPRINTS), arg_0 -> RequestsToExternalEndpointsSearcher.findRawUrlsInCode$lambda$22(project, modulesToSearchIn, arg_0)), arg_0 -> RequestsToExternalEndpointsSearcher.findRawUrlsInCode$lambda$25(this, searchParams, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$forEach$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source instanceof MsDiagramWebservice && target instanceof MsDiagramExternalEndpoint && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWebservice)source).getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List $this$searchForRequestsFormingAnEdge_u24lambda_u2431 = list = (List)new ArrayList();
        boolean bl = false;
        Sequence sequence = this.findModulesEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)source).getModule()), this.getEndpointTypesToSearch(), project2, searchParams).get(((MsDiagramWebservice)source).getModule());
        if (sequence != null) {
            void $this$forEach$iv2;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = (Iterable)sequence;
            boolean $i$f$filter = false;
            void var13_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                Object element$iv$iv;
                block10: {
                    element$iv$iv = iterator.next();
                    UrlTargetInfo info = (UrlTargetInfo)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = info.getAuthorities();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Authority it = (Authority)element$iv;
                            boolean bl4 = false;
                            Authority.Exact exact = it instanceof Authority.Exact ? (Authority.Exact)it : null;
                            if (!Intrinsics.areEqual((Object)(exact != null ? exact.getText() : null), (Object)((MsDiagramExternalEndpoint)target).getAuthority())) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                UrlTargetInfo info = (UrlTargetInfo)element$iv;
                boolean bl5 = false;
                $this$searchForRequestsFormingAnEdge_u24lambda_u2431.add(new RequestToExternalEndpoint((MsDiagramWebservice)source, (MsDiagramExternalEndpoint)target, info, null));
            }
        }
        sequence = SequencesKt.filter(this.findRawUrlsInCode(CollectionsKt.listOf((Object)((MsDiagramWebservice)source).getModule()), project2, searchParams), arg_0 -> RequestsToExternalEndpointsSearcher.searchForRequestsFormingAnEdge$lambda$31$lambda$29(target, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UrlPathReference urlRef = (UrlPathReference)element$iv;
            boolean bl6 = false;
            $this$searchForRequestsFormingAnEdge_u24lambda_u2431.add(new RequestToExternalEndpoint((MsDiagramWebservice)source, (MsDiagramExternalEndpoint)target, ((MsDiagramExternalEndpoint)target).getTargetInfo(), urlRef));
        }
        return list;
    }

    private static final String _get_isToExternalService_$lambda$0(Authority it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Authority.Exact exact = it instanceof Authority.Exact ? (Authority.Exact)it : null;
        return exact != null ? exact.getText() : null;
    }

    private static final RequestToUrl.WithKnownTargetInfo findRequestsToEndpointUrls$lambda$15$lambda$5$lambda$3(UrlTargetInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RequestToUrl.WithKnownTargetInfo(it);
    }

    private static final boolean findRequestsToEndpointUrls$lambda$15$lambda$5$lambda$4(RequestsToExternalEndpointsSearcher this$0, RequestToUrl.WithKnownTargetInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isToExternalService(it);
    }

    private static final RequestToUrl.WithKnownPathReference findRequestsToEndpointUrls$lambda$15$lambda$6(UrlPathReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RequestToUrl.WithKnownPathReference(it);
    }

    private static final boolean findRequestsToEndpointUrls$lambda$15$lambda$7(RequestsToExternalEndpointsSearcher this$0, RequestToUrl.WithKnownPathReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isToExternalService(it) && !StringUtil.isEmpty((String)it.getAuthority());
    }

    private static final Module findRequestsToEndpointUrls$lambda$15$lambda$9$lambda$8(RequestToUrl.WithKnownPathReference $it) {
        return ModuleUtil.findModuleForPsiElement((PsiElement)$it.getRef().getElement());
    }

    private static final List findRequestsToEndpointUrls$lambda$15$lambda$14$lambda$13$lambda$11(List $urls, Module module, List acc) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
        List list2 = acc;
        if (list2 != null) {
            List list3;
            List $this$findRequestsToEndpointUrls_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410 = list3 = list2;
            boolean bl = false;
            $this$findRequestsToEndpointUrls_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410.addAll($urls);
            list = list3;
        } else {
            list = CollectionsKt.toMutableList((Collection)$urls);
        }
        return list;
    }

    private static final List findRequestsToEndpointUrls$lambda$15$lambda$14$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final Iterable findRawUrlsInCode$lambda$22(Project $project, Iterable $modulesToSearchIn, String urlFootprint) {
        Intrinsics.checkNotNullParameter((Object)urlFootprint, (String)"urlFootprint");
        SearchWordQueryBuilder searchWordQueryBuilder = SearchService.Companion.getInstance().searchWord($project, urlFootprint).caseSensitive(false);
        SearchContext searchContext = SearchContext.inStrings();
        Intrinsics.checkNotNullExpressionValue((Object)searchContext, (String)"inStrings(...)");
        Collection collection = searchWordQueryBuilder.inContexts(searchContext, new SearchContext[0]).inScope((SearchScope)new TaperingScope($project, CollectionsKt.toSet((Iterable)$modulesToSearchIn))).includeInjections().buildLeafOccurrenceQuery().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static final UrlPathReference findRawUrlsInCode$lambda$25$lambda$24(TextOccurrence $occurrence, RequestsToExternalEndpointsSearcher this$0, RequestsSearcher.SearchParams $searchParams) {
        Object v0;
        block3: {
            Class[] classArray = new Class[]{PsiLanguageInjectionHost.class};
            PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getNonStrictParentOfType((PsiElement)$occurrence.getElement(), (Class[])classArray);
            if (psiLanguageInjectionHost != null && (classArray = psiLanguageInjectionHost.getReferences()) != null) {
                void $this$firstOrNull$iv;
                Class[] classArray2 = classArray;
                boolean $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this$0.isAppropriateReference((PsiReference)it, $searchParams)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            } else {
                v0 = null;
            }
        }
        Object var3_12 = v0;
        return var3_12 instanceof UrlPathReference ? (UrlPathReference)var3_12 : null;
    }

    private static final UrlPathReference findRawUrlsInCode$lambda$25(RequestsToExternalEndpointsSearcher this$0, RequestsSearcher.SearchParams $searchParams, TextOccurrence occurrence) {
        return (UrlPathReference)ActionsKt.runReadAction(() -> RequestsToExternalEndpointsSearcher.findRawUrlsInCode$lambda$25$lambda$24(occurrence, this$0, $searchParams));
    }

    private static final boolean searchForRequestsFormingAnEdge$lambda$31$lambda$29(MsDiagramEndpoint $target, UrlPathReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContext().getAuthorities().contains(((MsDiagramExternalEndpoint)$target).getAuthority());
    }

    static {
        Object[] objectArray = new EndpointType[]{EndpointTypes.HTTP_CLIENT_TYPE, EndpointTypes.WEBSOCKET_CLIENT_TYPE};
        CLIENT_ENDPOINT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new MsDiagramRelationship[]{MsDiagramRelationshipsKt.BASE_HTTP_REQUEST_RELATIONSHIP, MsDiagramRelationshipsKt.WEBSOCKET_REQUEST_RELATIONSHIP};
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"http", "ws", "://"};
        URL_FOOTPRINTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$Companion;", "", "<init>", "()V", "CLIENT_ENDPOINT_TYPES", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "SUPPORTED_RELATIONSHIPS", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "URL_FOOTPRINTS", "", "", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "", "<init>", "()V", "authority", "", "getAuthority", "()Ljava/lang/String;", "WithKnownTargetInfo", "WithKnownPathReference", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownPathReference;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownTargetInfo;", "intellij.microservices.ui"})
    @SourceDebugExtension(value={"SMAP\nRequestsToExternalEndpointsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToExternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n808#2,11:190\n*S KotlinDebug\n*F\n+ 1 RequestsToExternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl\n*L\n56#1:190,11\n*E\n"})
    private static abstract class RequestToUrl {
        private RequestToUrl() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getAuthority() {
            String string;
            RequestToUrl requestToUrl = this;
            if (requestToUrl instanceof WithKnownTargetInfo) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((WithKnownTargetInfo)this).getInfo().getAuthorities();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Authority.Exact)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Authority.Exact exact = (Authority.Exact)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                string = exact != null ? exact.getText() : null;
            } else if (requestToUrl instanceof WithKnownPathReference) {
                string = (String)CollectionsKt.singleOrNull((List)((WithKnownPathReference)this).getRef().getContext().getAuthorities());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public /* synthetic */ RequestToUrl(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownPathReference;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "ref", "Lcom/intellij/microservices/url/references/UrlPathReference;", "<init>", "(Lcom/intellij/microservices/url/references/UrlPathReference;)V", "getRef", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices.ui"})
        public static final class WithKnownPathReference
        extends RequestToUrl {
            @NotNull
            private final UrlPathReference ref;

            public WithKnownPathReference(@NotNull UrlPathReference ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                super(null);
                this.ref = ref;
            }

            @NotNull
            public final UrlPathReference getRef() {
                return this.ref;
            }

            @NotNull
            public final UrlPathReference component1() {
                return this.ref;
            }

            @NotNull
            public final WithKnownPathReference copy(@NotNull UrlPathReference ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                return new WithKnownPathReference(ref);
            }

            public static /* synthetic */ WithKnownPathReference copy$default(WithKnownPathReference withKnownPathReference, UrlPathReference urlPathReference, int n, Object object) {
                if ((n & 1) != 0) {
                    urlPathReference = withKnownPathReference.ref;
                }
                return withKnownPathReference.copy(urlPathReference);
            }

            @NotNull
            public String toString() {
                return "WithKnownPathReference(ref=" + this.ref + ")";
            }

            public int hashCode() {
                return this.ref.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithKnownPathReference)) {
                    return false;
                }
                WithKnownPathReference withKnownPathReference = (WithKnownPathReference)other;
                return Intrinsics.areEqual((Object)this.ref, (Object)withKnownPathReference.ref);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownTargetInfo;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "info", "Lcom/intellij/microservices/url/UrlTargetInfo;", "<init>", "(Lcom/intellij/microservices/url/UrlTargetInfo;)V", "getInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices.ui"})
        public static final class WithKnownTargetInfo
        extends RequestToUrl {
            @NotNull
            private final UrlTargetInfo info;

            public WithKnownTargetInfo(@NotNull UrlTargetInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super(null);
                this.info = info;
            }

            @NotNull
            public final UrlTargetInfo getInfo() {
                return this.info;
            }

            @NotNull
            public final UrlTargetInfo component1() {
                return this.info;
            }

            @NotNull
            public final WithKnownTargetInfo copy(@NotNull UrlTargetInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return new WithKnownTargetInfo(info);
            }

            public static /* synthetic */ WithKnownTargetInfo copy$default(WithKnownTargetInfo withKnownTargetInfo, UrlTargetInfo urlTargetInfo, int n, Object object) {
                if ((n & 1) != 0) {
                    urlTargetInfo = withKnownTargetInfo.info;
                }
                return withKnownTargetInfo.copy(urlTargetInfo);
            }

            @NotNull
            public String toString() {
                return "WithKnownTargetInfo(info=" + this.info + ")";
            }

            public int hashCode() {
                return this.info.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithKnownTargetInfo)) {
                    return false;
                }
                WithKnownTargetInfo withKnownTargetInfo = (WithKnownTargetInfo)other;
                return Intrinsics.areEqual((Object)this.info, (Object)withKnownTargetInfo.info);
            }
        }
    }
}

