/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSParameterSignatureBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/HtmlParameterSignatureBuilder;", "Lcom/intellij/javascript/JSParameterSignatureBuilder;", "context", "Lcom/intellij/psi/PsiElement;", "typeRenderer", "Lkotlin/Function1;", "Lcom/intellij/lang/javascript/psi/JSType;", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "dialect", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "highlighter", "Lcom/intellij/lang/javascript/highlighting/JSHighlighter;", "renderOperator", "operator", "appendParameterName", "name", "getParameterInitializerText", "text", "intellij.javascript.impl"})
final class HtmlParameterSignatureBuilder
extends JSParameterSignatureBuilder {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final DialectOptionHolder dialect;
    @NotNull
    private final JSHighlighter highlighter;

    public HtmlParameterSignatureBuilder(@NotNull PsiElement context2, @NotNull Function1<? super JSType, String> typeRenderer) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeRenderer, (String)"typeRenderer");
        super(typeRenderer, null);
        this.context = context2;
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement(this.context);
        if (dialectOptionHolder == null) {
            dialectOptionHolder = DialectOptionHolder.JS_WITH_JSX;
        }
        this.dialect = dialectOptionHolder;
        this.highlighter = this.dialect.isTypeScript ? (JSHighlighter)new TypeScriptHighlighter(this.dialect) : new JSHighlighter(this.dialect);
    }

    @Override
    @NotNull
    protected String renderOperator(@NotNull String operator) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        return QuickDocHighlightingHelper.getStyledFragment((String)operator, (TextAttributesKey)this.highlighter.getMappedKey(JSHighlighter.JS_OPERATION_SIGN));
    }

    @Override
    @NotNull
    public JSParameterSignatureBuilder appendParameterName(@NotNull String name) {
        HtmlParameterSignatureBuilder htmlParameterSignatureBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HtmlParameterSignatureBuilder $this$appendParameterName_u24lambda_u240 = htmlParameterSignatureBuilder = this;
        boolean bl = false;
        $this$appendParameterName_u24lambda_u240.getBuilder().append(QuickDocHighlightingHelper.getStyledFragment((String)name, (TextAttributesKey)$this$appendParameterName_u24lambda_u240.highlighter.getMappedKey(JSHighlighter.JS_PARAMETER)));
        return htmlParameterSignatureBuilder;
    }

    @Override
    @NotNull
    public String getParameterInitializerText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = this.renderOperator("=");
        Project project = this.context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Language language = this.context.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return " " + string + " " + JSTooltipWithHtmlHighlighter.Companion.highlightWithLexer(project, text, language, false);
    }
}

