/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpSyntheticLibrary
extends SyntheticLibrary
implements ItemPresentation,
NavigatableWithText {
    private final YarnPnpWorkspace myWorkspace;
    private final String myLibraryName;
    private final List<VirtualFile> mySourceRoots;
    private final Set<VirtualFile> myExcludedRoots;

    public YarnPnpSyntheticLibrary(@NotNull YarnPnpWorkspace workspace, @NotNull String libraryName, @NotNull List<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> excludedRoots) {
        if (workspace == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (libraryName == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (sourceRoots == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(2);
        }
        if (excludedRoots == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(3);
        }
        super("YarnPnpSyntheticLibrary:" + workspace.getPnpFile().getPnpFile().getUrl() + ":" + workspace.getLocation(), null);
        this.myWorkspace = workspace;
        this.myLibraryName = libraryName;
        this.mySourceRoots = ImmutableList.copyOf(sourceRoots);
        this.myExcludedRoots = Set.copyOf(excludedRoots);
    }

    @NotNull
    public YarnPnpFile getPnpFile() {
        YarnPnpFile yarnPnpFile = this.myWorkspace.getPnpFile();
        if (yarnPnpFile == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return yarnPnpFile;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public YarnPnpWorkspace getWorkspace() {
        YarnPnpWorkspace yarnPnpWorkspace = this.myWorkspace;
        if (yarnPnpWorkspace == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(6);
        }
        return yarnPnpWorkspace;
    }

    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        List<VirtualFile> list = this.mySourceRoots;
        if (list == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = this.myExcludedRoots;
        if (set == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        YarnPnpSyntheticLibrary other = (YarnPnpSyntheticLibrary)((Object)o);
        if (!this.myWorkspace.equals(other.myWorkspace)) {
            return false;
        }
        if (!this.mySourceRoots.equals(other.getSourceRoots())) {
            return false;
        }
        return this.myExcludedRoots.equals(other.getExcludedRoots());
    }

    public int hashCode() {
        return Objects.hash(this.myWorkspace, this.mySourceRoots, this.myExcludedRoots);
    }

    public String toString() {
        return this.myWorkspace.toString();
    }

    @Nullable
    public String getPresentableText() {
        return this.myLibraryName;
    }

    @Nullable
    public String getLocationString() {
        return "Yarn";
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return JavaScriptLanguageIcons.Nodejs.Yarn;
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        return JavaScriptBundle.message("intention.name.navigate.to", "package.json");
    }

    public void navigate(boolean requestFocus) {
        VirtualFile packageJson = this.myWorkspace.findPackageJson();
        if (packageJson != null) {
            new OpenFileDescriptor(this.myWorkspace.getPnpFile().getProject(), packageJson, -1).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

