/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface ES6MoveModuleDestination {
    public boolean isNewFile();

    @NotNull
    public PsiElement getOrCreateModule();

    @Nullable
    public JSLanguageDialect getLanguage();

    @Nullable
    public static ES6MoveModuleDestination getModuleDestination(@NotNull PsiElement source, String path2) {
        PsiFile psiFile;
        if (source == null) {
            ES6MoveModuleDestination.$$$reportNull$$$0(0);
        }
        if ((psiFile = ES6MoveModuleDestination.getDestinationPsiFile(source, path2)) == null) {
            return new PathDestination(source, path2);
        }
        PsiElement psi = ES6MoveModuleDestination.getModule(psiFile);
        return psi != null ? new PsiDestination(psi) : null;
    }

    @Nullable
    public static PsiFile getDestinationPsiFile(@NotNull PsiElement context2, String path2) {
        if (context2 == null) {
            ES6MoveModuleDestination.$$$reportNull$$$0(1);
        }
        path2 = FileUtil.toSystemIndependentName((String)path2);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context2);
        Object system = file != null ? file.getFileSystem() : LocalFileSystem.getInstance();
        VirtualFile vFile = system.findFileByPath(path2);
        if (vFile == null) {
            return null;
        }
        return context2.getManager().findFile(vFile);
    }

    @Nullable
    public static PsiElement getModule(@Nullable PsiFile psiFile) {
        return psiFile instanceof XmlFile ? JSUtils.findScriptTagContent((XmlFile)psiFile) : psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleDestination";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleDestination";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDestinationPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class PathDestination
    implements ES6MoveModuleDestination {
        @NotNull
        private final NotNullLazyValue<PsiElement> myFile;
        @NotNull
        private final String myPath;
        @Nullable
        private final JSLanguageDialect myLanguageDialect;
        private final boolean myNewFile;

        PathDestination(@NotNull PsiElement context2, @NotNull String path2) {
            if (context2 == null) {
                PathDestination.$$$reportNull$$$0(0);
            }
            if (path2 == null) {
                PathDestination.$$$reportNull$$$0(1);
            }
            Project project = context2.getProject();
            VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)context2);
            LocalFileSystem system = contextFile == null ? LocalFileSystem.getInstance() : contextFile.getFileSystem();
            this.myPath = FileUtil.toSystemIndependentName((String)path2.trim());
            String fileName = VfsUtil.extractFileName((String)this.myPath);
            assert (fileName != null);
            FileType destinationFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
            this.myLanguageDialect = PathDestination.extractLanguage(project, destinationFileType);
            VirtualFile candidate = system.findFileByPath(this.myPath);
            this.myNewFile = candidate == null;
            this.myFile = NotNullLazyValue.createValue(() -> this.lambda$new$1(candidate, project, (VirtualFileSystem)system, fileName));
        }

        @Nullable
        private static JSLanguageDialect extractLanguage(@NotNull Project project, @NotNull FileType destinationFileType) {
            if (project == null) {
                PathDestination.$$$reportNull$$$0(2);
            }
            if (destinationFileType == null) {
                PathDestination.$$$reportNull$$$0(3);
            }
            if (destinationFileType instanceof LanguageFileType) {
                Language language = ((LanguageFileType)destinationFileType).getLanguage();
                if (language == JavascriptLanguage.INSTANCE) {
                    return DialectDetector.getConfiguredJSVersion(null, project);
                }
                return (JSLanguageDialect)ObjectUtils.tryCast((Object)language, JSLanguageDialect.class);
            }
            return null;
        }

        @Override
        public boolean isNewFile() {
            return this.myNewFile;
        }

        @Override
        public JSLanguageDialect getLanguage() {
            return this.myLanguageDialect;
        }

        @Override
        @NotNull
        public PsiElement getOrCreateModule() {
            PsiElement psiElement = (PsiElement)this.myFile.getValue();
            if (psiElement == null) {
                PathDestination.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        private /* synthetic */ PsiElement lambda$new$1(VirtualFile candidate, Project project, VirtualFileSystem system, String fileName) {
            try {
                VirtualFile compute = candidate != null ? candidate : (VirtualFile)WriteCommandAction.writeCommandAction((Project)project).withName(JavaScriptBundle.message("es6.move.module.members.refactoring.create.file", new Object[0])).compute(() -> {
                    String parentDir = VfsUtil.getParentDir((String)this.myPath);
                    assert (parentDir != null);
                    VirtualFile directories = VfsUtil.createDirectoryIfMissing((VirtualFileSystem)system, (String)parentDir);
                    assert (directories != null);
                    return directories.createChildData((Object)this, fileName);
                });
                return (PsiElement)Objects.requireNonNull(PsiManager.getInstance((Project)project).findFile(compute));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destinationFileType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleDestination$PathDestination";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleDestination$PathDestination";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "extractLanguage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class PsiDestination
    implements ES6MoveModuleDestination {
        @NotNull
        private final PsiElement myElement;

        PsiDestination(@NotNull PsiElement element) {
            if (element == null) {
                PsiDestination.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        public boolean isNewFile() {
            return false;
        }

        @Override
        @NotNull
        public PsiElement getOrCreateModule() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                PsiDestination.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @Override
        @Nullable
        public JSLanguageDialect getLanguage() {
            return DialectDetector.languageDialectOfElement(this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleDestination$PsiDestination";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleDestination$PsiDestination";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

