/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSModuleImportOptimizerBase
implements ImportOptimizer {
    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(0);
        }
        if (!JSOptimizeImportUtil.isAvailable(file)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(1);
            }
            return runnable;
        }
        Collection<UnusedModuleInfo> infos = this.getModulesInfo((PsiElement)file, Collections.emptySet());
        if (infos.isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(2);
            }
            return runnable;
        }
        Runnable runnable = () -> {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            if (document != null) {
                manager.commitDocument(document);
            }
            Project project = file.getProject();
            FormatFixer.fixAll(ContainerUtil.mapNotNull((Collection)infos, info -> JSModuleImportOptimizerBase.processModule(project, document, info)));
        };
        if (runnable == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    @Nullable
    protected static FormatFixer processModule(@NotNull Project project, @Nullable Document document, @NotNull UnusedModuleInfo info) {
        String text;
        if (project == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(4);
        }
        if (info == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(5);
        }
        List<PsiElement> oldImports = info.getOldImports();
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> commentInfos = JSModuleImportOptimizerBase.getCommentInfos(document, oldImports);
        List<String> importTexts = info.getImportTexts();
        PsiElement anchor = info.getAnchor();
        if (anchor == null) {
            return null;
        }
        FormatFixer formatFixer = null;
        if (!importTexts.isEmpty() && !StringUtil.isEmptyOrSpaces((String)(text = StringUtil.join(importTexts, (String)"")))) {
            PsiFile fakeFile = JSOptimizeImportUtil.createFileWithImports(project, document, text, anchor);
            if (!JSModuleImportOptimizerBase.hasChangesInImports(fakeFile, info, oldImports)) {
                return FormatFixer.create(anchor.getContainingFile(), JSModuleImportOptimizerBase.toTextRange(oldImports), FormatFixer.Mode.Reformat);
            }
            formatFixer = JSOptimizeImportUtil.addNewImportTexts(fakeFile.getFirstChild(), fakeFile.getLastChild(), document, anchor);
        }
        JSModuleImportOptimizerBase.removeOldImports(anchor, oldImports, commentInfos);
        return formatFixer;
    }

    @NotNull
    private static String toText(@NotNull List<PsiElement> sortedImports) {
        TextRange range;
        if (sortedImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(6);
        }
        if ((range = JSModuleImportOptimizerBase.toTextRange(sortedImports)).isEmpty()) {
            return "";
        }
        PsiFile oldText = sortedImports.get(0).getContainingFile();
        CharSequence chars = oldText.getNode().getChars();
        if (chars.length() < range.getEndOffset()) {
            Logger.getInstance(JSModuleImportOptimizerBase.class).error("Incorrect range:" + String.valueOf(range), new Attachment[]{new Attachment("Imports:", sortedImports.stream().map(PsiElement::getText).collect(Collectors.joining()))});
            return "";
        }
        String string = range.subSequence(chars).toString();
        if (string == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static TextRange toTextRange(@NotNull List<PsiElement> sortedImports) {
        if (sortedImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(8);
        }
        if (sortedImports.isEmpty() || ContainerUtil.exists(sortedImports, el -> !el.isValid())) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        if (sortedImports.size() == 1) {
            TextRange textRange = sortedImports.get(0).getTextRange();
            if (textRange == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        PsiElement start = sortedImports.get(0);
        PsiElement end = (PsiElement)ContainerUtil.getLastItem(sortedImports);
        return new TextRange(start.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
    }

    private static boolean hasChangesInImports(@NotNull PsiFile fakeFile, @NotNull UnusedModuleInfo info, @NotNull List<PsiElement> oldImports) {
        String oldText;
        String newText;
        List<PsiElement> newImports;
        if (fakeFile == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(11);
        }
        if (info == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(12);
        }
        if (oldImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(13);
        }
        if ((newImports = info.getImportsForScope((PsiElement)fakeFile)).size() == oldImports.size() && Objects.equals(newText = fakeFile.getText(), oldText = JSModuleImportOptimizerBase.toText(oldImports)) && !StringUtil.isEmpty((String)oldText)) {
            PsiElement sibling = ((PsiElement)ContainerUtil.getLastItem(oldImports)).getNextSibling();
            int count = 0;
            while (sibling instanceof PsiWhiteSpace) {
                count += StringUtil.countNewLines((CharSequence)sibling.getText());
                sibling = sibling.getNextSibling();
            }
            return count > 2;
        }
        return true;
    }

    private static void removeOldImports(@NotNull PsiElement anchor, @NotNull List<PsiElement> oldImports, @NotNull Map<PsiElement, JSOptimizeImportUtil.CommentHolder> comments) {
        PsiElement parent;
        if (anchor == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(14);
        }
        if (oldImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(15);
        }
        if (comments == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(16);
        }
        boolean shouldHaveNewLineAtTheEnd = (parent = anchor.getParent()) instanceof JSEmbeddedContent || parent instanceof JSFile ? JSOptimizeImportUtil.endsWithNewLine(parent) : false;
        for (int i = 0; i < oldImports.size(); ++i) {
            boolean isFirst = i == 0;
            PsiElement declaration = oldImports.get(i);
            JSOptimizeImportUtil.CommentHolder pair = comments.get(declaration);
            List<PsiElement> prevComments = pair.prevComments;
            PsiElement sameLineEndComment = pair.lineComment;
            boolean hasComments = !prevComments.isEmpty();
            PsiElement beforeElement = hasComments ? prevComments.get(0) : declaration;
            PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
            JSOptimizeImportUtil.deleteSiblingWhitespaceBetweenImports(beforeElement, afterElement, !isFirst);
            if (hasComments || sameLineEndComment != null) {
                declaration.getParent().deleteChildRange(beforeElement, afterElement);
                continue;
            }
            declaration.delete();
        }
        if (shouldHaveNewLineAtTheEnd && !JSOptimizeImportUtil.endsWithNewLine(parent)) {
            PsiElement lastChild = parent.getLastChild();
            if (lastChild instanceof PsiWhiteSpace) {
                lastChild.replace(JSChangeUtil.createTokenElement(parent, TokenType.WHITE_SPACE, lastChild.getText() + "\n"));
            } else if (lastChild != null) {
                parent.addAfter(JSChangeUtil.createNewLine(parent), lastChild);
            }
        }
    }

    @NotNull
    private static HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> getCommentInfos(@Nullable Document document, @NotNull List<PsiElement> imports) {
        if (imports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(17);
        }
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> prevDeclarations = new HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder>();
        for (PsiElement declaration : imports) {
            prevDeclarations.put(declaration, new JSOptimizeImportUtil.CommentHolder(JSOptimizeImportUtil.getPrevComments(document, declaration), JSOptimizeImportUtil.getLineComment(document, declaration)));
        }
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> hashMap = prevDeclarations;
        if (hashMap == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @NotNull
    public abstract Collection<UnusedModuleInfo> getModulesInfo(@NotNull PsiElement var1, @NotNull Set<JSReferenceExpression> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 9, 10, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedImports";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeFile";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldImports";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toTextRange";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toTextRange";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasChangesInImports";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeOldImports";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommentInfos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 9, 10, 18 -> new IllegalStateException(string);
        };
    }

    public static interface UnusedModuleInfo {
        @NotNull
        public List<String> getImportTexts();

        @Nullable
        public PsiElement getAnchor();

        @NotNull
        public List<PsiElement> getOldImports();

        public List<PsiElement> getImportsForScope(@NotNull PsiElement var1);
    }
}

