/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.ES6AddExportModifierIntention;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertDefaultImportToSpecifierFix;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertSpecifierToDefaultFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J/\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/lang/javascript/modules/ES6CheckImportVisitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "<init>", "()V", "visitES6ImportedBindingImpl", "", "importedBinding", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "visitSpecifierImpl", "node", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportSpecifier;", "isSpecialReactSvgImport", "", "fromClause", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "isUnresolvedFromPart", "addSpecifierError", "elementForError", "Lcom/intellij/psi/PsiElement;", "name", "", "getFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "importExportPart", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;", "resolveResult", "resolveProblemKind", "Lcom/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind;", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.javascript.impl"})
public class ES6CheckImportVisitor
extends JSElementVisitor {
    @JvmOverloads
    public final void visitES6ImportedBindingImpl(@NotNull ES6ImportedBinding importedBinding, @NotNull ProblemsHolder holder, @NotNull ProblemHighlightType problemHighlightType) {
        Intrinsics.checkNotNullParameter((Object)importedBinding, (String)"importedBinding");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)problemHighlightType, (String)"problemHighlightType");
        if (importedBinding.isNamespaceImport()) {
            return;
        }
        ES6ImportDeclaration parent = importedBinding.getDeclaration();
        if (parent != null) {
            Collection<PsiElement> collection = importedBinding.findReferencedElements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"findReferencedElements(...)");
            Collection<PsiElement> referencedElements = collection;
            ES6FromClause fromClause = parent.getFromClause();
            if (fromClause != null && referencedElements.isEmpty()) {
                Collection<PsiElement> collection2 = fromClause.resolveReferencedElements();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"resolveReferencedElements(...)");
                Collection<PsiElement> modules = collection2;
                PsiElement module = (PsiElement)CollectionsKt.firstOrNull((Iterable)modules);
                if (modules.size() == 1 && module instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)module).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6) {
                    PsiElement psiElement = importedBinding.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)importedBinding;
                    }
                    PsiElement elementForError = psiElement;
                    LocalQuickFix[] localQuickFixArray = this.getFixes(importedBinding, null, null);
                    holder.registerProblem(elementForError, JavaScriptBundle.message("es6.default.export.not.declared", new Object[0]), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
        }
    }

    public static /* synthetic */ void visitES6ImportedBindingImpl$default(ES6CheckImportVisitor eS6CheckImportVisitor, ES6ImportedBinding eS6ImportedBinding, ProblemsHolder problemsHolder, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitES6ImportedBindingImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportVisitor.visitES6ImportedBindingImpl(eS6ImportedBinding, problemsHolder, problemHighlightType);
    }

    @JvmOverloads
    public final void visitSpecifierImpl(@NotNull ProblemsHolder holder, @NotNull ES6ImportExportSpecifier node, @NotNull ProblemHighlightType problemHighlightType) {
        PsiElement elementForError;
        ES6FromClause fromClause;
        ES6ImportExportDeclaration declaration;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)problemHighlightType, (String)"problemHighlightType");
        ES6ImportExportDeclaration eS6ImportExportDeclaration = declaration = node.getDeclaration();
        ES6FromClause eS6FromClause = fromClause = eS6ImportExportDeclaration != null ? eS6ImportExportDeclaration.getFromClause() : null;
        if (fromClause == null || this.isUnresolvedFromPart(fromClause) || this.isSpecialReactSvgImport(node, fromClause)) {
            return;
        }
        ResolveResult[] resolveResultArray = node.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        ResolveResult[] results = resolveResultArray;
        PsiElement psiElement = node.getReferenceNameElement();
        if (psiElement == null) {
            psiElement = elementForError = (PsiElement)node;
        }
        if (results.length == 0) {
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        } else {
            List<PsiElement> list = JSResolveResult.toElements(results);
            Intrinsics.checkNotNullExpressionValue(list, (String)"toElements(...)");
            List<PsiElement> elements = list;
            if (!((Collection)elements).isEmpty()) {
                return;
            }
            for (ResolveResult result2 : results) {
                JSResolveResult.ProblemKind resolveProblemKey;
                if (!(result2 instanceof JSResolveResult) || (resolveProblemKey = ((JSResolveResult)result2).getResolveProblemKind()) == null) continue;
                LocalQuickFix[] fixes = this.getFixes(node, ((JSResolveResult)result2).getElement(), resolveProblemKey);
                holder.registerProblem(elementForError, JavaScriptBundle.message(resolveProblemKey.getMessageKey(), new Object[0]), problemHighlightType, Arrays.copyOf(fixes, fixes.length));
                return;
            }
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        }
    }

    public static /* synthetic */ void visitSpecifierImpl$default(ES6CheckImportVisitor eS6CheckImportVisitor, ProblemsHolder problemsHolder, ES6ImportExportSpecifier eS6ImportExportSpecifier, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitSpecifierImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportVisitor.visitSpecifierImpl(problemsHolder, eS6ImportExportSpecifier, problemHighlightType);
    }

    private final boolean isSpecialReactSvgImport(ES6ImportExportSpecifier node, ES6FromClause fromClause) {
        String string = fromClause.getReferenceText();
        if (string == null) {
            return false;
        }
        String referenceText = string;
        String string2 = JSStringUtil.unquoteStringLiteralValue(referenceText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteStringLiteralValue(...)");
        if (StringsKt.endsWith$default((String)string2, (String)".svg", (boolean)false, (int)2, null)) {
            String specifierName = node.getReferenceName();
            return Intrinsics.areEqual((Object)"ReactComponent", (Object)specifierName);
        }
        return false;
    }

    private final boolean isUnresolvedFromPart(ES6FromClause fromClause) {
        String string = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)fromClause.getReferenceText()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteStringLiteralValue(...)");
        return ((CharSequence)string).length() > 0 && fromClause.resolveReferencedElements().isEmpty();
    }

    private final void addSpecifierError(ES6ImportExportSpecifier node, ProblemsHolder holder, PsiElement elementForError, String name, ProblemHighlightType problemHighlightType) {
        Object[] objectArray = new Object[]{name};
        String string = JavaScriptBundle.message("es6.validate.import.error", objectArray);
        objectArray = this.getFixes(node, null, null);
        holder.registerProblem(elementForError, string, problemHighlightType, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @NotNull
    protected LocalQuickFix[] getFixes(@NotNull ES6ImportExportDeclarationPart importExportPart, @Nullable PsiElement resolveResult, @Nullable JSResolveResult.ProblemKind resolveProblemKind) {
        Intrinsics.checkNotNullParameter((Object)importExportPart, (String)"importExportPart");
        LocalQuickFixAndIntentionActionOnPsiElement fix = null;
        if (importExportPart instanceof ES6ImportSpecifier) {
            fix = new ES6ConvertSpecifierToDefaultFix((ES6ImportSpecifier)importExportPart);
        } else if (importExportPart instanceof ES6ImportedBinding) {
            fix = new ES6ConvertDefaultImportToSpecifierFix((ES6ImportedBinding)importExportPart);
        }
        if (fix != null && fix.isAvailable(importExportPart.getProject(), null, importExportPart.getContainingFile())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
            return localQuickFixArray;
        }
        if (resolveProblemKind == JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED && resolveResult instanceof JSNamedElement) {
            PsiFile psiFile = ((JSNamedElement)resolveResult).getContainingFile();
            JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
            if ((jSFile != null ? jSFile.getModuleStatus() : null) != JSModuleStatusOwner.ModuleStatus.COMMONJS) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{ES6AddExportModifierIntention.createFixForElement((JSNamedElement)resolveResult)};
                return localQuickFixArray;
            }
        }
        LocalQuickFix[] localQuickFixArray = JSReferenceChecker.getCreateFixesForUnresolvedRef(importExportPart);
        Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"getCreateFixesForUnresolvedRef(...)");
        return localQuickFixArray;
    }

    @JvmOverloads
    public final void visitES6ImportedBindingImpl(@NotNull ES6ImportedBinding importedBinding, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)importedBinding, (String)"importedBinding");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ES6CheckImportVisitor.visitES6ImportedBindingImpl$default(this, importedBinding, holder, null, 4, null);
    }

    @JvmOverloads
    public final void visitSpecifierImpl(@NotNull ProblemsHolder holder, @NotNull ES6ImportExportSpecifier node) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ES6CheckImportVisitor.visitSpecifierImpl$default(this, holder, node, null, 4, null);
    }
}

